/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaTerm;

/**
 * @author Peter Shin
 */
public class JavaTermMetadataLineBreakCheck extends BaseJavaTermCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, JavaTerm javaTerm,
			String fileContent)
		throws Exception {

		UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(
			new UnsyncStringReader(javaTerm.getContent()));

		String line = null;

		StringBundler newSB = new StringBundler();
		StringBundler oldSB = new StringBundler();

		boolean foundJavaTermDefinition = false;
		String indent = SourceUtil.getIndent(javaTerm.getContent());

		while ((line = unsyncBufferedReader.readLine()) != null) {
			if (line.matches(indent + _JAVA_TERM_DEFINITION_REGEX)) {
				foundJavaTermDefinition = true;

				break;
			}

			oldSB.append(line);
			oldSB.append("\n");

			if (Validator.isNotNull(line)) {
				newSB.append(line);
				newSB.append("\n");
			}
		}

		if ((oldSB.length() < 1) || !foundJavaTermDefinition) {
			return javaTerm.getContent();
		}

		return StringUtil.replaceFirst(
			javaTerm.getContent(), oldSB.toString(), newSB.toString());
	}

	@Override
	protected String[] getCheckableJavaTermNames() {
		return new String[] {JAVA_METHOD, JAVA_VARIABLE};
	}

	private static final String _JAVA_TERM_DEFINITION_REGEX =
		"((private|protected|public)( .*|$)|static \\{)";

}