/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaStylingCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (content.contains("$\n */")) {
			content = StringUtil.replace(content, "$\n */", "$\n *\n */");
		}

		if (content.contains(" * @author Raymond Aug") &&
			!content.contains(" * @author Raymond Aug\u00e9")) {

			content = content.replaceFirst(
				"Raymond Aug.++", "Raymond Aug\u00e9");
		}

		content = StringUtil.replace(
			content, " final static ", " static final ");

		content = StringUtil.replace(
			content,
			new String[] {
				";\n/**", "\t/*\n\t *", ";;\n", "\n/**\n *\n *",
				"\n */\npackage "
			},
			new String[] {
				";\n\n/**", "\t/**\n\t *", ";\n", "\n/**\n *",
				"\n */\n\npackage "
			});

		content = StringUtil.replace(
			content,
			new String[] {"!Validator.isNotNull(", "!Validator.isNull("},
			new String[] {"Validator.isNull(", "Validator.isNotNull("});

		content = StringUtil.replace(
			content, StringPool.TAB + "for (;;) {",
			StringPool.TAB + "while (true) {");

		Matcher matcher = _incorrectSynchronizedPattern.matcher(content);

		content = matcher.replaceAll("$1$3 $2");

		return content;
	}

	private final Pattern _incorrectSynchronizedPattern = Pattern.compile(
		"([\n\t])(synchronized) (private|public|protected)");

}