/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaDiamondOperatorCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		return _applyDiamondOperator(content);
	}

	private String _applyDiamondOperator(String content) {
		Matcher matcher = _diamondOperatorPattern.matcher(content);

		while (matcher.find()) {
			String match = matcher.group();

			if (match.contains("{\n")) {
				continue;
			}

			String className = matcher.group(3);
			String parameterType = matcher.group(5);

			// LPS-70579

			if ((className.equals("AutoResetThreadLocal") ||
				 className.equals("InitialThreadLocal")) &&
				(parameterType.startsWith("Map<") ||
				 parameterType.startsWith("Set<"))) {

				continue;
			}

			String whitespace = matcher.group(4);

			String replacement = StringUtil.replaceFirst(
				match,
				StringBundler.concat(whitespace, "<", parameterType, ">"),
				"<>");

			content = StringUtil.replace(content, match, replacement);
		}

		return content;
	}

	private final Pattern _diamondOperatorPattern = Pattern.compile(
		"(return|=)\n?(\t+| )new ([A-Za-z]+)(\\s*)<([^>][^;]*?)>" +
			"\\(\n*\t*.*?\\);\n",
		Pattern.DOTALL);

}