/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaBooleanUsageCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		content = _fixIncorrectBooleanUse(content, "setAttribute");

		return content;
	}

	private String _fixIncorrectBooleanUse(String content, String methodName) {
		Pattern pattern = Pattern.compile(
			"\\." + methodName + "\\((.*?)\\);\n", Pattern.DOTALL);

		Matcher matcher = pattern.matcher(content);

		while (matcher.find()) {
			if (ToolsUtil.isInsideQuotes(content, matcher.start())) {
				continue;
			}

			String match = matcher.group();

			if (match.contains("\t//")) {
				continue;
			}

			List<String> parametersList = JavaSourceUtil.getParameterList(
				match);

			if (parametersList.size() != 2) {
				continue;
			}

			String secondParameterName = parametersList.get(1);

			if (secondParameterName.equals("false") ||
				secondParameterName.equals("true")) {

				String replacement = StringUtil.replaceLast(
					match, secondParameterName,
					"Boolean." + StringUtil.toUpperCase(secondParameterName));

				return StringUtil.replace(content, match, replacement);
			}
		}

		return content;
	}

}