/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JSPLanguageKeysCheck extends LanguageKeysCheck {

	@Override
	protected List<Pattern> getPatterns() {
		return Arrays.asList(
			languageKeyPattern, _taglibLanguageKeyPattern1,
			_taglibLanguageKeyPattern2, _taglibLanguageKeyPattern3);
	}

	private final Pattern _taglibLanguageKeyPattern1 = Pattern.compile(
		"(?:confirmation|label|(?:M|m)essage|message key|names|title)=\"[^A-Z" +
			"<=%\\[\\s]+\"");
	private final Pattern _taglibLanguageKeyPattern2 = Pattern.compile(
		StringBundler.concat(
			"(aui:)(?:input|select|field-wrapper) (?!.*label=(?:'|\").*",
			"(?:'|\\\").*name=\"[^<=%\\[\\s]+\")(?!.*name=\"[^<=%\\[\\s]+\".*",
			"title=(?:'|\").+(?:'|\"))(?!.*name=\"[^<=%\\[\\s]+\".*type=\"",
			"hidden\").*name=\"([^<=%\\[\\s]+)\""));
	private final Pattern _taglibLanguageKeyPattern3 = Pattern.compile(
		"(liferay-ui:)(?:input-resource) .*id=\"([^<=%\\[\\s]+)\"(?!.*title=" +
			"(?:'|\").+(?:'|\"))");

}