/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class PropertiesSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws Exception {
		return getFileNames(new String[] {"**/docroot/dtd/**"}, getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		if (portalSource || subrepository) {
			return new String[] {
				"**/app-server.properties", "**/ci.properties",
				"**/lib/*/dependencies.properties", "**/framework.properties",
				"**/gradle-wrapper.properties", "**/imported-files.properties",
				"**/Language*.properties",
				"**/liferay-plugin-package*.properties", "**/portal.properties",
				"**/portal-ext.properties", "**/portal-legacy-*.properties",
				"**/portlet.properties", "**/service.properties",
				"**/source-formatter.properties", "**/test.properties"
			};
		}

		return new String[] {
			"**/liferay-plugin-package.properties", "**/portal.properties",
			"**/portal-ext.properties", "**/portlet.properties",
			"**/service.properties", "**/source-formatter.properties"
		};
	}

}