/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

/**
 * @author Peter Shin
 */
public enum ExcludeSyntax {

	GLOB("glob"), REGEX("regex");

	public static ExcludeSyntax parse(String value) {
		String globValue = GLOB.getValue();

		if (globValue.equals(value)) {
			return GLOB;
		}

		String regexValue = REGEX.getValue();

		if (regexValue.equals(value)) {
			return REGEX;
		}

		throw new IllegalArgumentException("Invalid value " + value);
	}

	public String getValue() {
		return _value;
	}

	@Override
	public String toString() {
		return _value;
	}

	private ExcludeSyntax(String value) {
		_value = value;
	}

	private final String _value;

}