/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ArquillianCheck
extends AbstractCheck {
    public static final String MSG_INVALID_IMPORT = "import.invalid";

    public int[] getDefaultTokens() {
        return new int[]{16};
    }

    public void visitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        int pos = fileName.indexOf("/testIntegration/");
        if (pos == -1) {
            return;
        }
        List<String> importNames = this._getImportNames(detailAST);
        if (!importNames.contains("org.jboss.arquillian.junit.Arquillian") || importNames.contains("org.jboss.arquillian.container.test.api.RunAsClient")) {
            return;
        }
        File xmlFile = new File(fileName.substring(0, pos) + "/testIntegration/resources/arquillian.xml");
        if (!xmlFile.exists()) {
            this.log(detailAST.getLineNo(), MSG_INVALID_IMPORT, new Object[0]);
        }
    }

    private List<String> _getImportNames(DetailAST detailAST) {
        ArrayList<String> importASTList = new ArrayList<String>();
        DetailAST sibling = detailAST.getNextSibling();
        while (sibling.getType() == 30) {
            FullIdent importIdent = FullIdent.createFullIdentBelow((DetailAST)sibling);
            importASTList.add(importIdent.getText());
            sibling = sibling.getNextSibling();
        }
        return importASTList;
    }
}

