/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checkstyle.util.CheckStyleUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    private static final String _CHECK_JAVA_FIELD_TYPES_EXCLUDES = "check.java.field.types.excludes";
    private static final String _DIAMOND_OPERATOR_EXCLUDES = "diamond.operator.excludes";
    private static final String _FIT_ON_SINGLE_LINE_EXCLUDES = "fit.on.single.line.excludes";
    private static final String _HIBERNATE_SQL_QUERY_EXCLUDES = "hibernate.sql.query.excludes";
    private static final String[] _INCLUDES = new String[]{"**/*.java"};
    private static final String _JAVATERM_SORT_EXCLUDES = "javaterm.sort.excludes";
    private static final String _LINE_LENGTH_EXCLUDES = "line.length.excludes";
    private static final String _PROXY_EXCLUDES = "proxy.excludes";
    private static final String _SECURE_DESERIALIZATION_EXCLUDES = "secure.deserialization.excludes";
    private static final String _SECURE_RANDOM_EXCLUDES = "secure.random.excludes";
    private static final String _SECURE_XML_EXCLUDES = "secure.xml.excludes";
    private static final String _STATIC_LOG_EXCLUDES = "static.log.excludes";
    private static final String _TEST_ANNOTATIONS_EXCLUDES = "test.annotations.excludes";
    private static final String _UPGRADE_DATA_ACCESS_CONNECTION_EXCLUDES = "upgrade.data.access.connection.excludes";
    private static final String _UPGRADE_SERVICE_UTIL_EXCLUDES = "upgrade.service.util.excludes";
    private static final Pattern _annotationPattern = Pattern.compile("(\t*)@(.+)\\(\n([\\s\\S]*?)\\)\n");
    private boolean _addMissingDeprecationReleaseVersion;
    private boolean _allowUseServiceUtilInServiceImpl;
    private final Pattern _annotationLineBreakPattern1 = Pattern.compile("[{=]\n.*(\" \\+\n\t*\")");
    private final Pattern _annotationLineBreakPattern2 = Pattern.compile("=(\n\t*)\"");
    private final Pattern _annotationMetaTypePattern = Pattern.compile("[\\s\\(](name|description) = \"%");
    private final Pattern _anonymousClassPattern = Pattern.compile("\n(\t+)(\\S.* )?new .*\\) \\{\n\n");
    private final Pattern _arrayPattern = Pattern.compile("(\n\t*.* =) (new \\w*\\[\\] \\{)\n(\t*)(.+)\n\t*(\\};)\n");
    private final Pattern _assertEqualsPattern = Pattern.compile("Assert\\.assertEquals\\((.*?)\\);\n", 32);
    private final Pattern _catchExceptionPattern = Pattern.compile("\n(\t+)catch \\((.+Exception) (.+)\\) \\{\n");
    private boolean _checkRegistryInTestClasses;
    private final Pattern _classPattern = Pattern.compile("(\n(\t*)(private|protected|public) ((abstract|static) )*(class|enum|interface) ([\\s\\S]*?) \\{)\n(\\s*)(\\S)");
    private final Pattern _combinedLinesPattern1 = Pattern.compile("\n(\t*).+(=|\\]) (\\{)\n");
    private final Pattern _combinedLinesPattern2 = Pattern.compile("\n(\t*)@.+(\\()\n");
    private final Pattern _componentAnnotationPattern = Pattern.compile("@Component(\n|\\([\\s\\S]*?\\)\n)");
    private final Pattern _customSQLFilePattern = Pattern.compile("<sql file=\"(.*)\" \\/>");
    private final Pattern _deprecatedPattern = Pattern.compile("(^\\s*\\* @deprecated)( As of ([0-9\\.]+)(.+)?)?");
    private final Pattern _diamondOperatorPattern = Pattern.compile("(return|=)\n?(\t+| )new ([A-Za-z]+)(\\s*)<(.+)>\\(\n*\t*.*\\);\n");
    private final Pattern _fetchByPrimaryKeysMethodPattern = Pattern.compile("@Override\n\tpublic Map<(.+)> fetchByPrimaryKeys\\(");
    private final Pattern _ifStatementCriteriaPattern = Pattern.compile(".*?( [|&^]+( |\\Z)|\\) \\{\\Z)");
    private final Pattern _incorrectCloseCurlyBracePattern1 = Pattern.compile("\n(.+)\n\n(\t+)}\n");
    private final Pattern _incorrectCloseCurlyBracePattern2 = Pattern.compile("(\t| )@?(class|enum|interface|new)\\s");
    private final Pattern _incorrectLineBreakPattern1 = Pattern.compile("\t(catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
    private final Pattern _incorrectLineBreakPattern2 = Pattern.compile("\\{\n\n\t*\\}");
    private final Pattern _incorrectLineBreakPattern3 = Pattern.compile(", (new .*\\(.*\\) \\{)\n");
    private final Pattern _incorrectLineBreakPattern4 = Pattern.compile("\n(\t*)(.*\\) \\{)([\t ]*\\}\n)");
    private final Pattern _incorrectLineBreakPattern5 = Pattern.compile("\n(\t*).*\\}\n(\t*)\\);");
    private final Pattern _incorrectLineBreakPattern6 = Pattern.compile("\n(\t*)\\{.+(?<!\\}(,|;)?)\n");
    private final Pattern _incorrectLineBreakPattern7 = Pattern.compile("\n(\t+\\{)\n(.*[^;])\n\t+(\\},?)");
    private final Pattern _incorrectMultiLineCommentPattern = Pattern.compile("(\n\t*/\\*)\n\t*(.*?)\n\t*(\\*/\n)", 32);
    private final Pattern _incorrectSynchronizedPattern = Pattern.compile("([\n\t])(synchronized) (private|public|protected)");
    private final Pattern _internalImportPattern = Pattern.compile("\nimport com\\.liferay\\.(.*\\.internal\\.([a-z].*?\\.)?[A-Z].*?)[\\.|;]");
    private final Pattern[] _javaSerializationVulnerabilityPatterns = new Pattern[]{Pattern.compile(".*(new [a-z\\.\\s]*ObjectInputStream).*", 32), Pattern.compile(".*(extends [a-z\\.\\s]*ObjectInputStream).*", 32)};
    private final Pattern _lineStartingWithOpenParenthesisPattern = Pattern.compile("(.)\n+(\t+)\\)[^.].*\n");
    private final Pattern _logLevelPattern = Pattern.compile("\n(\t+)_log.(debug|error|info|trace|warn)\\(");
    private final Pattern _logPattern = Pattern.compile("\n\tprivate static final Log _log = LogFactoryUtil.getLog\\(\n*\t*(.+)\\.class\\)");
    private final Pattern _lowerCaseNumberOrPeriodPattern = Pattern.compile("[a-z0-9.]");
    private int _maxLineLength;
    private final Pattern _missingEmptyLinePattern1 = Pattern.compile("(\t| = |return )new .*\\(.*\\) \\{\n\t+[^{\t]");
    private final Pattern _missingEmptyLinePattern2 = Pattern.compile("(\n\t*)(public|private|protected) [^;]+? \\{");
    private final Map<String, String> _moduleFileContentsMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> _moduleFileNamesMap;
    private final Pattern _packagePattern = Pattern.compile("(\n|^)\\s*package (.*);\n");
    private String _portalCustomSQLContent;
    private final Pattern _processCallablePattern = Pattern.compile("implements ProcessCallable\\b");
    private final Pattern _redundantCommaPattern = Pattern.compile(",\n\t+\\}");
    private final Pattern _redundantEmptyLines1 = Pattern.compile("\n\npublic ((abstract|static) )*(class|enum|interface) ");
    private final Pattern _redundantEmptyLines2 = Pattern.compile(" \\* @author .*\n \\*\\/\n\n");
    private final Pattern _referenceMethodContentPattern = Pattern.compile("^(\\w+) =\\s+\\w+;$");
    private final Pattern _referenceMethodPattern = Pattern.compile("\n\t@Reference([\\s\\S]*?)\\s+((protected|public) void (\\w+?))\\(\\s*([ ,<>\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)\\s*?\n\t\\}\n");
    private final Pattern _registryImportPattern = Pattern.compile("\nimport (com\\.liferay\\.registry\\..+);");
    private final Pattern _registryRegisterPattern = Pattern.compile("registry\\.register\\((.*?)\\);\n", 32);
    private final Pattern _serviceUtilImportPattern = Pattern.compile("\nimport ([A-Za-z1-9\\.]*)\\.([A-Za-z1-9]*ServiceUtil);");
    private final Pattern _setVariablePattern = Pattern.compile("\t[A-Z]\\w+ (\\w+) =\\s+((?!\\{\n).)*?;\n", 32);
    private final Pattern _stagedModelTypesPattern = Pattern.compile("StagedModelType\\(([a-zA-Z.]*(class|getClassName[\\(\\)]*))\\)");
    private final Pattern _throwsExceptionsPattern = Pattern.compile("\\sthrows ([\\s\\w,]*)[;{]\n");
    private final Pattern _throwsSystemExceptionPattern = Pattern.compile("(\n\t+.*)throws(.*) SystemException(.*)( \\{|;\n)");
    private final Set<File> _ungeneratedFiles = new CopyOnWriteArraySet<File>();
    private final Pattern _upgradeClassNamePattern = Pattern.compile("new .*?(\\w+)\\(", 32);

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    protected String applyDiamondOperator(String content) {
        Matcher matcher = this._diamondOperatorPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String whitespace = matcher.group(4);
            String parameterType = matcher.group(5);
            String replacement = StringUtil.replaceFirst(match, whitespace + "<" + parameterType + ">", "<>");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }

    protected String checkAnnotationLineBreaks(String content, String annotation) {
        Matcher matcher = this._annotationLineBreakPattern1.matcher(annotation);
        if (matcher.find()) {
            String replacement = StringUtil.replaceFirst(annotation, matcher.group(1), "", matcher.start());
            return StringUtil.replace(content, annotation, replacement);
        }
        matcher = this._annotationLineBreakPattern2.matcher(annotation);
        if (matcher.find()) {
            String replacement = StringUtil.replaceFirst(annotation, matcher.group(1), " ", matcher.start());
            return StringUtil.replace(content, annotation, replacement);
        }
        return content;
    }

    protected String checkAnnotationMetaTypeProperties(String content, String annotation) {
        if (!annotation.contains("@Meta.")) {
            return content;
        }
        Matcher matcher = this._annotationMetaTypePattern.matcher(annotation);
        if (!matcher.find()) {
            return content;
        }
        String newAnnotation = StringUtil.replaceFirst(annotation, "%", "", matcher.start());
        return StringUtil.replace(content, annotation, newAnnotation);
    }

    protected String checkAnnotationParameterProperties(String content, String annotation) {
        int x = annotation.indexOf("property = {");
        if (x == -1) {
            return content;
        }
        int y = x;
        while (ToolsUtil.isInsideQuotes(annotation, y = annotation.indexOf(125, y + 1))) {
        }
        String parameterProperties = annotation.substring(x + 12, y);
        parameterProperties = StringUtil.replace(parameterProperties, "\n", " ");
        String[] parameterPropertiesArray = StringUtil.split(parameterProperties, ", ");
        String previousPropertyName = null;
        String previousPropertyNameAndValue = null;
        for (String parameterProperty : parameterPropertiesArray) {
            x = parameterProperty.indexOf(34);
            y = parameterProperty.indexOf(61, x);
            int z = x;
            while ((z = parameterProperty.indexOf(34, z + 1)) != -1 && ToolsUtil.isInsideQuotes(parameterProperty, z)) {
            }
            if (x == -1 || y == -1 || z == -1) {
                return content;
            }
            String propertyName = parameterProperty.substring(x + 1, y);
            String propertyNameAndValue = parameterProperty.substring(x + 1, z);
            if (Validator.isNotNull(previousPropertyName) && previousPropertyName.compareToIgnoreCase(propertyName) > 0) {
                content = StringUtil.replaceFirst(content, previousPropertyNameAndValue, propertyNameAndValue);
                content = StringUtil.replaceLast(content, propertyNameAndValue, previousPropertyNameAndValue);
                return content;
            }
            previousPropertyName = propertyName;
            previousPropertyNameAndValue = propertyNameAndValue;
        }
        return content;
    }

    protected void checkBndInheritAnnotationOption() {
        Map<String, BNDSettings> bndSettingsMap = this.getBNDSettingsMap();
        for (Map.Entry<String, BNDSettings> entry : bndSettingsMap.entrySet()) {
            BNDSettings bndSettings = entry.getValue();
            String content = bndSettings.getContent();
            String fileLocation = bndSettings.getFileLocation();
            boolean inheritRequired = bndSettings.isInheritRequired();
            if (content.contains("-dsannotations-options: inherit") || !inheritRequired) continue;
            this.printError(fileLocation, "Add '-dsannotations-options: inherit': " + fileLocation + "bnd.bnd");
        }
    }

    protected void checkDeserializationSecurity(String fileName, String content, boolean isRunOutsidePortalExclusion) {
        for (Pattern vulnerabilityPattern : this._javaSerializationVulnerabilityPatterns) {
            Matcher matcher = vulnerabilityPattern.matcher(content);
            if (!matcher.matches()) continue;
            StringBundler sb = new StringBundler(3);
            if (isRunOutsidePortalExclusion) {
                sb.append("Possible Java Serialization Remote Code Execution ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use ProtectedObjectInputStream instead of ");
            }
            sb.append(matcher.group(1));
            this.processMessage(fileName, sb.toString());
        }
    }

    protected void checkFinderCacheInterfaceMethod(String fileName, String content) {
        if (!fileName.endsWith("FinderImpl.java") || !content.contains("public static final FinderPath")) {
            return;
        }
        Matcher matcher = this._fetchByPrimaryKeysMethodPattern.matcher(content);
        if (!matcher.find()) {
            this.processMessage(fileName, "Missing override of BasePersistenceImpl.fetchByPrimaryKeys(Set<Serializable>), see LPS-49552");
        }
    }

    protected void checkIndentationAndLineBreaks(String line, String previousLine, String fileName, int lineCount) {
        int y;
        int x;
        int x2;
        String trimmedLine = StringUtil.trimLeading(line);
        if (previousLine.contains("\t/*") || trimmedLine.startsWith("//") || trimmedLine.endsWith("*/")) {
            return;
        }
        if (trimmedLine.startsWith("},") && !trimmedLine.equals("},")) {
            this.processMessage(fileName, "There should be a line break after '},'", lineCount);
        }
        int lineLeadingTabCount = this.getLeadingTabCount(line);
        int previousLineLeadingTabCount = this.getLeadingTabCount(previousLine);
        if (previousLine.endsWith(",") && previousLine.contains("(") && !previousLine.contains("for (") && lineLeadingTabCount > previousLineLeadingTabCount) {
            this.processMessage(fileName, "There should be a line break after '('", lineCount - 1);
        }
        if (lineLeadingTabCount == previousLineLeadingTabCount && (previousLine.endsWith("=") || previousLine.endsWith("("))) {
            this.processMessage(fileName, "Line should be indented", lineCount);
        }
        if (Validator.isNotNull(previousLine) && !previousLine.matches(".*\t(abstract|else|extends|for|if|implements|private|protected|public|try|while) .*") && previousLineLeadingTabCount <= lineLeadingTabCount - 2) {
            this.processMessage(fileName, "Incorrect indent", lineCount);
        }
        if (Validator.isNotNull(trimmedLine)) {
            int expectedTabCount = -1;
            if (previousLine.endsWith("{") && !trimmedLine.startsWith("}")) {
                expectedTabCount = previousLineLeadingTabCount + 1;
            } else if (previousLine.matches(".*\t(for|if|try) .*[(:]")) {
                expectedTabCount = previousLineLeadingTabCount + 2;
            } else if (previousLine.matches(".*\t(else if|while) .*[(:]")) {
                expectedTabCount = previousLineLeadingTabCount + 3;
            }
            if (expectedTabCount != -1 && lineLeadingTabCount != expectedTabCount) {
                this.processMessage(fileName, "Line starts with " + lineLeadingTabCount + " tabs, but should be " + expectedTabCount, lineCount);
            }
        }
        if (previousLine.endsWith(".") && (x2 = trimmedLine.indexOf(40)) != -1 && this.getLineLength(previousLine) + x2 < this._maxLineLength && (trimmedLine.endsWith("(") || trimmedLine.charAt(x2 + 1) != ')')) {
            this.processMessage(fileName, "Incorrect line break", lineCount);
        }
        int diff = lineLeadingTabCount - previousLineLeadingTabCount;
        if (previousLine.contains("\tthrows ") && diff == 0 || trimmedLine.startsWith("throws ") && (diff == 0 || diff > 1)) {
            this.processMessage(fileName, "incorrect indent", lineCount);
        }
        String strippedQuotesLine = this.stripQuotes(trimmedLine);
        int strippedQuotesLineOpenParenthesisCount = StringUtil.count(strippedQuotesLine, '(');
        if (!trimmedLine.startsWith("(") && trimmedLine.endsWith(") {") && strippedQuotesLineOpenParenthesisCount > 0 && this.getLevel(trimmedLine) > 0) {
            this.processMessage(fileName, "Incorrect line break", lineCount);
        }
        if (line.endsWith("(")) {
            String linePart;
            int pos;
            x = line.lastIndexOf(" && ");
            int z = Math.max(x, y = line.lastIndexOf(" || "));
            if (z != -1) {
                this.processMessage(fileName, "There should be a line break after '" + line.substring(z + 1, z + 3) + "'", lineCount);
            }
            if ((pos = strippedQuotesLine.indexOf(" + ")) != -1 && this.getLevel(linePart = strippedQuotesLine.substring(0, pos), "(", ")") == 0 && this.getLevel(linePart, "[", "]") == 0) {
                this.processMessage(fileName, "There should be a line break after '+'", lineCount);
            }
        }
        if (trimmedLine.matches("\\)\\..*\\([^)].*")) {
            int pos = trimmedLine.indexOf("(");
            this.processMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, pos + 1) + "'", lineCount);
        }
        if (trimmedLine.matches("^[^(].*\\+$") && this.getLevel(trimmedLine) > 0) {
            this.processMessage(fileName, "There should be a line break after '('", lineCount);
        }
        if (!trimmedLine.contains("\t//") && !line.endsWith("{") && strippedQuotesLine.contains("{") && !strippedQuotesLine.contains("}")) {
            this.processMessage(fileName, "There should be a line break after '{'", lineCount);
        }
        if (previousLine.endsWith("(") || previousLine.endsWith("+")) {
            x = -1;
            while ((x = trimmedLine.indexOf(", ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(trimmedLine, x)) continue;
                String linePart = trimmedLine.substring(0, x + 1);
                int level = this.getLevel(linePart);
                if ((!previousLine.endsWith("(") || level >= 0) && (!previousLine.endsWith("+") || level > 0)) continue;
                this.processMessage(fileName, "There should be a line break after '" + linePart + "'", lineCount);
            }
        }
        if ((x = trimmedLine.indexOf(", ")) != -1) {
            String linePart;
            if (!ToolsUtil.isInsideQuotes(trimmedLine, x) && this.getLevel(linePart = trimmedLine.substring(0, x + 1)) < 0) {
                this.processMessage(fileName, "There should be a line break after '" + linePart + "'", lineCount);
            }
        } else if (trimmedLine.endsWith(",") && !trimmedLine.startsWith("for (") && this.getLevel(trimmedLine) > 0) {
            this.processMessage(fileName, "Incorrect line break", lineCount);
        }
        if ((line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) && (x = line.indexOf(" = ")) != -1 && ((y = line.indexOf(34)) == -1 || x < y)) {
            this.processMessage(fileName, "There should be a line break after '='", lineCount);
        }
        if (line.endsWith(" throws") || (previousLine.endsWith(",") || previousLine.endsWith("(")) && line.contains(" throws ") && (line.endsWith("{") || line.endsWith(";"))) {
            this.processMessage(fileName, "There should be a line break before 'throws'", lineCount);
        }
        if (line.endsWith(".") && line.contains("=")) {
            this.processMessage(fileName, "There should be a line break after '='", lineCount);
        }
        if (trimmedLine.matches("^\\} (catch|else|finally) .*")) {
            this.processMessage(fileName, "There should be a line break after '}'", lineCount);
        }
    }

    protected void checkInternalImports(String fileName, String absolutePath, String content) {
        if (absolutePath.contains("/modules/core/") || absolutePath.contains("/modules/util/") || fileName.contains("/test/") || fileName.contains("/testIntegration/")) {
            return;
        }
        Matcher matcher = this._internalImportPattern.matcher(content);
        int pos = -1;
        while (matcher.find()) {
            String expectedImportFileLocation;
            File file;
            if (pos == -1) {
                pos = absolutePath.lastIndexOf("/com/liferay/");
            }
            if ((file = new File(expectedImportFileLocation = absolutePath.substring(0, pos + 13) + StringUtil.replace(matcher.group(1), ".", "/") + ".java")).exists()) continue;
            this.processMessage(fileName, "Do not import internal class from another module", this.getLineCount(content, matcher.start(1)));
        }
    }

    protected void checkLogLevel(String content, String fileName) {
        if (fileName.contains("Log")) {
            return;
        }
        Matcher matcher = this._logLevelPattern.matcher(content);
        while (matcher.find()) {
            String s;
            char c;
            int pos = matcher.start();
            while ((c = content.charAt((pos = content.lastIndexOf("\n\t", pos - 1)) + 2)) == '\t') {
            }
            String codeBlock = content.substring(pos, matcher.start());
            if (!(codeBlock.contains(s = "_log.is" + StringUtil.upperCaseFirstLetter(matcher.group(2)) + "Enabled()") ^ !s.equals("_log.isErrorEnabled()"))) continue;
            int lineCount = this.getLineCount(content, matcher.start(1));
            if (codeBlock.contains(s)) {
                this.processMessage(fileName, "Do not use _log.isErrorEnabled()", lineCount);
                continue;
            }
            this.processMessage(fileName, "Use " + s, lineCount);
        }
    }

    protected void checkPackagePath(String fileName, String packagePath) {
        int pos;
        String filePath;
        if (Validator.isNull(packagePath)) {
            this.processMessage(fileName, "Missing package");
        }
        if (!(filePath = StringUtil.replace(fileName.substring(0, pos = fileName.lastIndexOf(47)), '/', '.')).endsWith(packagePath)) {
            this.processMessage(fileName, "The declared package '" + packagePath + "' does not match the expected package");
        }
    }

    protected void checkSystemEventAnnotations(String content, String fileName) throws Exception {
        if (!portalSource || !fileName.endsWith("PortletDataHandler.java")) {
            return;
        }
        int pos = content.indexOf("setDeletionSystemEventStagedModelTypes");
        if (pos == -1) {
            return;
        }
        String deletionSystemEventStagedModelTypes = content.substring(pos, content.indexOf(");", pos));
        Matcher matcher = this._stagedModelTypesPattern.matcher(deletionSystemEventStagedModelTypes);
        while (matcher.find()) {
            String stagedModelTypeClassName = matcher.group(1);
            pos = stagedModelTypeClassName.indexOf(".class");
            if (pos == -1) {
                pos = stagedModelTypeClassName.indexOf("Constants");
            }
            if (pos == -1) {
                return;
            }
            String className = stagedModelTypeClassName.substring(0, pos);
            Pattern packageNamePattern = Pattern.compile("import (com\\.liferay\\.[a-zA-Z\\.]*)\\.model\\." + className + ";");
            Matcher packageNameMatcher = packageNamePattern.matcher(content);
            if (!packageNameMatcher.find()) {
                return;
            }
            StringBundler sb = new StringBundler(5);
            sb.append(fileName.substring(0, fileName.indexOf("/src/") + 5));
            sb.append(StringUtil.replace(packageNameMatcher.group(1), ".", "/"));
            sb.append("/service/impl/");
            sb.append(className);
            sb.append("LocalServiceImpl.java");
            String localServiceImplFileName = sb.toString();
            String localServiceImplContent = FileUtil.read(new File(localServiceImplFileName));
            if (localServiceImplContent == null) {
                return;
            }
            if (localServiceImplContent.contains("@SystemEvent")) continue;
            this.processMessage(fileName, "Missing deletion system event '" + localServiceImplFileName + "', see LPS-46632");
        }
    }

    protected void checkUpgradeClass(String fileName, String absolutePath, String className, String content) {
        String componentAnnotation;
        Matcher matcher;
        if (!fileName.contains("/upgrade/")) {
            return;
        }
        int pos = content.indexOf("LocaleUtil.getDefault()");
        if (pos != -1) {
            this.processMessage(fileName, "Use UpgradeProcessUtil.getDefaultLanguageId(companyId) instead of LocaleUtil.getDefault()", this.getLineCount(content, pos));
        }
        if ((pos = content.indexOf("rs.getDate(")) != -1) {
            this.processMessage(fileName, "Use rs.getTimeStamp instead of rs.getDate", this.getLineCount(content, pos));
        }
        if (portalSource && !this.isExcludedPath(_UPGRADE_SERVICE_UTIL_EXCLUDES, absolutePath) && fileName.contains("/portal/upgrade/") && !fileName.contains("/test/") && !fileName.contains("/testIntegration/") && (pos = content.indexOf("ServiceUtil.")) != -1) {
            this.processMessage(fileName, "Do not use *ServiceUtil classes in upgrade classes, see LPS-34911", this.getLineCount(content, pos));
        }
        if (!fileName.endsWith("Upgrade.java")) {
            return;
        }
        if (content.contains("implements UpgradeStepRegistrator") && (matcher = this._componentAnnotationPattern.matcher(content)).find() && !(componentAnnotation = matcher.group()).contains("service =")) {
            this.processMessage(fileName, "@Component requires 'service' parameter");
        }
        Matcher matcher1 = this._registryRegisterPattern.matcher(content);
        block0: while (matcher1.find()) {
            String parameter;
            Matcher matcher2;
            List<String> parametersList = this.getParameterList(content.substring(matcher1.start()));
            if (parametersList.size() <= 4) continue;
            String previousUpgradeClassName = null;
            for (int i = 3; i < parametersList.size() && (matcher2 = this._upgradeClassNamePattern.matcher(parameter = parametersList.get(i))).find(); ++i) {
                String upgradeClassName = matcher2.group(1);
                if (previousUpgradeClassName != null && previousUpgradeClassName.compareTo(upgradeClassName) > 0) {
                    this.processMessage(fileName, "Break up Upgrade classes with a minor version increment or order alphabetically, see LPS-65685", this.getLineCount(content, matcher1.start()));
                    continue block0;
                }
                previousUpgradeClassName = upgradeClassName;
            }
        }
    }

    protected void checkVerifyUpgradeConnection(String fileName, String className, String content) {
        if (fileName.endsWith("Test.java") || fileName.endsWith("UpgradeTableListener.java") || !className.contains("Upgrade") && !className.contains("Verify")) {
            return;
        }
        if (this.isExcludedPath(_UPGRADE_DATA_ACCESS_CONNECTION_EXCLUDES, fileName) || content.contains("ThrowableAwareRunnable")) {
            return;
        }
        int x = -1;
        while ((x = content.indexOf("DataAccess.getUpgradeOptimizedConnection", x + 1)) != -1) {
            this.processMessage(fileName, "Use existing connection field instead of DataAccess.getUpgradeOptimizedConnection", this.getLineCount(content, x));
        }
    }

    protected void checkXMLSecurity(String fileName, String content, boolean isRunOutsidePortalExclusion) {
        String[] xmlVulnerabitilies;
        for (String xmlVulnerabitily : xmlVulnerabitilies = new String[]{"DocumentBuilderFactory.newInstance", "new javax.xml.parsers.SAXParser", "new org.apache.xerces.parsers.SAXParser", "new org.dom4j.io.SAXReader", "new SAXParser", "new SAXReader", "SAXParserFactory.newInstance", "saxParserFactory.newInstance", "SAXParserFactory.newSAXParser", "saxParserFactory.newSAXParser", "XMLInputFactory.newFactory", "xmlInputFactory.newFactory", "XMLInputFactory.newInstance", "xmlInputFactory.newInstance"}) {
            if (!content.contains(xmlVulnerabitily)) continue;
            StringBundler sb = new StringBundler(3);
            if (isRunOutsidePortalExclusion) {
                sb.append("Possible XXE or Quadratic Blowup security ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use SecureXMLFactoryProviderUtil.");
                sb.append("newDocumentBuilderFactory instead of ");
            }
            sb.append(xmlVulnerabitily);
            this.processMessage(fileName, sb.toString());
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        boolean isRunOutsidePortalExclusion;
        String logClassName;
        if (this.hasGeneratedTag(content)) {
            return content;
        }
        this._ungeneratedFiles.add(file);
        String className = file.getName();
        int pos = className.lastIndexOf(46);
        className = className.substring(0, pos);
        String packagePath = "";
        Matcher matcher = this._packagePattern.matcher(content);
        if (matcher.find()) {
            packagePath = matcher.group(2);
        }
        this.checkPackagePath(fileName, packagePath);
        if (packagePath.endsWith(".model") && content.contains("extends " + className + "Model")) {
            return content;
        }
        String newContent = this.trimContent(content, false);
        if (newContent.contains("$\n */")) {
            this.processMessage(fileName, "*");
            newContent = StringUtil.replace(newContent, "$\n */", "$\n *\n */");
        }
        if ((newContent = this.fixCopyright(newContent, absolutePath, fileName, className)).contains(className + ".java.html")) {
            this.processMessage(fileName, "Java2HTML");
        }
        if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
            newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
            this.processMessage(fileName, "UTF-8");
        }
        newContent = this.fixDataAccessConnection(className, newContent);
        newContent = this.fixSessionKey(fileName, newContent, sessionKeyPattern);
        newContent = StringUtil.replace(newContent, new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil"}, new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil"});
        newContent = StringUtil.replace(newContent, " final static ", " static final ");
        newContent = this.fixCompatClassImports(absolutePath, newContent);
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        newContent = importsFormatter.format(newContent, packagePath, className);
        newContent = StringUtil.replace(newContent, new String[]{";\n/**", "\t/*\n\t *", ";;\n", "\n/**\n *\n *"}, new String[]{";\n\n/**", "\t/**\n\t *", ";\n", "\n/**\n *"});
        newContent = this.fixMissingEmptyLines(newContent);
        newContent = this.fixRedundantEmptyLines(newContent);
        newContent = this.fixIncorrectLineBreaks(newContent, fileName);
        matcher = this._logPattern.matcher(newContent = this.formatAnnotations(fileName, "", newContent, "", true));
        if (matcher.find() && !(logClassName = matcher.group(1)).equals(className)) {
            newContent = StringUtil.replaceLast(newContent, logClassName + ".class)", className + ".class)");
        }
        if (!this.isExcludedPath(_STATIC_LOG_EXCLUDES, absolutePath)) {
            newContent = StringUtil.replace(newContent, "private Log _log", "private static final Log _log");
        }
        if ((newContent = StringUtil.replace(newContent, new String[]{"!Validator.isNotNull(", "!Validator.isNull("}, new String[]{"Validator.isNull(", "Validator.isNotNull("})).contains("*/\npackage ")) {
            this.processMessage(fileName, "package");
        }
        if (portalSource && !this._allowUseServiceUtilInServiceImpl && !fileName.contains("/wsrp/internal/bind/") && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
            this.processMessage(fileName, "Do not use *ServiceUtil in *ServiceImpl class, create a reference via service.xml instead");
        }
        if (!(isRunOutsidePortalExclusion = this.isExcludedPath("run.outside.portal.excludes", absolutePath)) && !this.isExcludedPath(_PROXY_EXCLUDES, absolutePath) && newContent.contains("import java.lang.reflect.Proxy;")) {
            this.processMessage(fileName, "Use ProxyUtil instead of java.lang.reflect.Proxy");
        }
        if (newContent.contains("import edu.emory.mathcs.backport.java")) {
            this.processMessage(fileName, "Illegal import: edu.emory.mathcs.backport.java");
        }
        if (newContent.contains("import jodd.util.StringPool")) {
            this.processMessage(fileName, "Illegal import: jodd.util.StringPool");
        }
        if (newContent.contains("com.liferay.portal.kernel.util.UnmodifiableList")) {
            this.processMessage(fileName, "Use java.util.Collections.unmodifiableList instead of com.liferay.portal.kernel.util.UnmodifiableList");
        }
        int pos1 = -1;
        while ((pos1 = newContent.indexOf("\ttry {", pos1 + 1)) != -1) {
            int pos2 = newContent.indexOf("\ttry {", pos1 + 1);
            int pos3 = newContent.indexOf("\"select count(", pos1);
            if (pos2 != -1 && pos3 != -1 && pos2 < pos3) continue;
            int pos4 = newContent.indexOf("rs.getLong(1)", pos1);
            int pos5 = newContent.indexOf("\tfinally {", pos1);
            if (pos3 == -1 || pos4 == -1 || pos5 == -1) break;
            if (pos3 >= pos4 || pos4 >= pos5) continue;
            this.processMessage(fileName, "Use rs.getInt(1) for count, see LPS-28266");
        }
        matcher = this._processCallablePattern.matcher(content);
        if (matcher.find() && !content.contains("private static final long serialVersionUID")) {
            this.processMessage(fileName, "Assign ProcessCallable implementation a serialVersionUID");
        }
        this.checkLanguageKeys(fileName, absolutePath, newContent, languageKeyPattern);
        newContent = this.sortMethodCalls(absolutePath, newContent);
        newContent = this.formatStringBundler(fileName, newContent, this._maxLineLength);
        newContent = StringUtil.replace(newContent, "\tfor (;;) {", "\twhile (true) {");
        newContent = this.formatExceptions(newContent, file, packagePath, fileName);
        if (!isRunOutsidePortalExclusion && !this.isExcludedPath(_SECURE_RANDOM_EXCLUDES, absolutePath) && content.contains("java.security.SecureRandom") && !content.contains("javax.crypto.KeyGenerator")) {
            this.processMessage(fileName, "Use SecureRandomUtil or com.liferay.portal.kernel.security.SecureRandom instead of java.security.SecureRandom");
        }
        this.checkLogLevel(newContent, fileName);
        this.checkSystemEventAnnotations(newContent, fileName);
        newContent = StringUtil.replace(newContent, " static interface ", " interface ");
        newContent = this.fixSystemExceptions(newContent);
        if (portalSource && (fileName.contains("/test/integration/") || fileName.contains("/testIntegration/java"))) {
            newContent = StringUtil.replace(newContent, "FinderCacheUtil.clearCache();", "");
        }
        newContent = this.fixIncorrectParameterTypeForLanguageUtil(newContent, false, fileName);
        if (portalSource && fileName.contains("/portal-kernel/") && content.contains("import javax.servlet.jsp.")) {
            this.processMessage(fileName, "Never import javax.servlet.jsp.* from portal-kernel, see LPS-47682");
        }
        if (!this.isExcludedPath(_DIAMOND_OPERATOR_EXCLUDES, absolutePath)) {
            newContent = this.applyDiamondOperator(newContent);
        }
        this.checkFinderCacheInterfaceMethod(fileName, newContent);
        if (!(fileName.contains("/test/") || fileName.contains("/testIntegration/") || this.isExcludedPath(_SECURE_XML_EXCLUDES, absolutePath))) {
            this.checkXMLSecurity(fileName, content, isRunOutsidePortalExclusion);
        }
        if (!(fileName.contains("/test/") || fileName.contains("/testIntegration/") || this.isExcludedPath(_SECURE_DESERIALIZATION_EXCLUDES, absolutePath))) {
            this.checkDeserializationSecurity(fileName, content, isRunOutsidePortalExclusion);
        }
        if (newContent.contains("org.testng.Assert")) {
            this.processMessage(fileName, "Use org.junit.Assert instead of org.testng.Assert, see LPS-55690");
        }
        if (portalSource && this.isModulesFile(absolutePath) && packagePath.startsWith("com.liferay")) {
            newContent = this.formatModulesFile(fileName, absolutePath, className, packagePath, newContent);
        }
        if ((newContent = this.checkPrincipalException(newContent)).contains(".supportsBatchUpdates()") && !fileName.endsWith("AutoBatchPreparedStatementUtil.java")) {
            this.processMessage(fileName, "Use AutoBatchPreparedStatementUtil instead of DatabaseMetaData.supportsBatchUpdates, see LPS-60473");
        }
        if (newContent.contains("Configurable.createConfigurable(") && !fileName.endsWith("ConfigurableUtil.java")) {
            this.processMessage(fileName, "Use ConfigurableUtil.createConfigurable instead of Configurable.createConfigurable, see LPS-64056");
        }
        this.checkPropertyUtils(fileName, newContent);
        if (!absolutePath.contains("poshi") && !fileName.endsWith("StringUtilTest.java")) {
            this.checkStringUtilReplace(fileName, newContent);
        }
        if (fileName.endsWith("ResourceCommand.java") && newContent.contains("ServletResponseUtil.sendFile(")) {
            this.processMessage(fileName, "Use PortletResponseUtil.sendFile instead of ServletResponseUtil.sendFile");
        }
        if (!fileName.endsWith("GetterUtilTest.java")) {
            this.checkGetterUtilGet(fileName, newContent);
        }
        if (portalSource) {
            this.checkVerifyUpgradeConnection(fileName, className, newContent);
        }
        if (!fileName.endsWith("AbstractExtender.java") && newContent.contains("org.apache.felix.utils.extender.AbstractExtender")) {
            StringBundler sb = new StringBundler(4);
            sb.append("Use com.liferay.osgi.felix.util.AbstractExtender ");
            sb.append("instead of ");
            sb.append("org.apache.felix.utils.extender.AbstractExtender, see ");
            sb.append("LPS-69494");
            this.processMessage(fileName, sb.toString());
        }
        this.checkUpgradeClass(fileName, absolutePath, className, newContent);
        newContent = this.formatAssertEquals(fileName, newContent);
        newContent = this.formatValidatorEquals(newContent);
        newContent = this.fixUnparameterizedClassType(newContent);
        newContent = this.fixMissingEmptyLineAfterSettingVariable(newContent);
        newContent = this.fixMultiLineComment(newContent);
        newContent = this.getCombinedLinesContent(newContent, this._combinedLinesPattern1);
        newContent = this.getCombinedLinesContent(newContent, this._combinedLinesPattern2);
        newContent = this.sortExceptions(newContent);
        newContent = this.formatArray(newContent);
        newContent = this.formatClassLine(newContent);
        newContent = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(newContent, fileName);
        newContent = this.fixLineStartingWithCloseParenthesis(newContent, fileName);
        matcher = this._incorrectSynchronizedPattern.matcher(newContent);
        newContent = matcher.replaceAll("$1$3 $2");
        pos = newContent.indexOf("\npublic ");
        if (pos != -1) {
            String javaClassContent = newContent.substring(pos + 1);
            int javaClassLineCount = this.getLineCount(newContent, pos + 1);
            newContent = this.formatJavaTerms(className, packagePath, file, fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, "", _CHECK_JAVA_FIELD_TYPES_EXCLUDES, _JAVATERM_SORT_EXCLUDES, _TEST_ANNOTATIONS_EXCLUDES);
        }
        matcher = this._anonymousClassPattern.matcher(newContent);
        while (matcher.find()) {
            String javaClassContent;
            if (this.getLevel(matcher.group()) != 0) continue;
            int x = matcher.start() + 1;
            int y = matcher.end();
            while (this.getLevel(javaClassContent = newContent.substring(x, y), "{", "}") != 0) {
                ++y;
            }
            int javaClassLineCount = this.getLineCount(newContent, matcher.start() + 1);
            newContent = this.formatJavaTerms("", "", file, fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, matcher.group(1), _CHECK_JAVA_FIELD_TYPES_EXCLUDES, _JAVATERM_SORT_EXCLUDES, _TEST_ANNOTATIONS_EXCLUDES);
        }
        newContent = this.formatJava(fileName, absolutePath, newContent);
        return StringUtil.replace(newContent, "\n\n\n", "\n\n");
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        Collection<String> fileNames = null;
        if (portalSource) {
            fileNames = this.getPortalJavaFiles();
            this._checkRegistryInTestClasses = GetterUtil.getBoolean(System.getProperty("source.formatter.check.registry.in.test.classes"));
        } else {
            fileNames = this.getPluginJavaFiles();
        }
        return new ArrayList<String>(fileNames);
    }

    protected String fixDataAccessConnection(String className, String content) {
        int x = content.indexOf("package ");
        int y = content.indexOf(59, x);
        if (x == -1 || y == -1) {
            return content;
        }
        String packageName = content.substring(x + 8, y);
        if (!(packageName.startsWith("com.liferay.portal.kernel.upgrade") || packageName.startsWith("com.liferay.portal.kernel.verify") || packageName.startsWith("com.liferay.portal.upgrade") || packageName.startsWith("com.liferay.portal.verify"))) {
            return content;
        }
        content = StringUtil.replace(content, "DataAccess.getConnection", "DataAccess.getUpgradeOptimizedConnection");
        return content;
    }

    protected String fixIfClause(String ifClause, String line, int delta) {
        if (StringUtil.count(ifClause, line) > 1) {
            return ifClause;
        }
        String newLine = line;
        String whitespace = "";
        int whitespaceLength = Math.abs(delta);
        while (whitespaceLength > 0) {
            if (whitespaceLength >= 4) {
                whitespace = whitespace + "\t";
                whitespaceLength -= 4;
                continue;
            }
            whitespace = whitespace + " ";
            --whitespaceLength;
        }
        if (delta > 0) {
            if (!line.contains("\t" + whitespace)) {
                newLine = StringUtil.replaceLast(newLine, "\t", "    ");
            }
            newLine = StringUtil.replaceLast(newLine, "\t" + whitespace, "\t");
        } else {
            newLine = StringUtil.replaceLast(newLine, "\t", "\t" + whitespace);
        }
        newLine = StringUtil.replaceLast(newLine, "    ", "\t");
        return StringUtil.replace(ifClause, line, newLine);
    }

    protected String fixIncorrectEmptyLineBeforeCloseCurlyBrace(String content, String fileName) {
        Matcher matcher1 = this._incorrectCloseCurlyBracePattern1.matcher(content);
        while (matcher1.find()) {
            String lastLine = StringUtil.trimLeading(matcher1.group(1));
            if (lastLine.startsWith("// ")) continue;
            String tabs = matcher1.group(2);
            int tabCount = tabs.length();
            int pos = matcher1.start();
            while (content.charAt((pos = content.lastIndexOf("\n" + tabs, pos - 1)) + tabCount + 1) == '\t') {
            }
            String codeBlock = content.substring(pos + 1, matcher1.end());
            String firstLine = codeBlock.substring(0, codeBlock.indexOf(10) + 1);
            Matcher matcher2 = this._incorrectCloseCurlyBracePattern2.matcher(firstLine);
            if (matcher2.find()) continue;
            return StringUtil.replaceFirst(content, "\n\n" + tabs + "}\n", "\n" + tabs + "}\n", pos);
        }
        return content;
    }

    protected String fixIncorrectLineBreaks(String content, String fileName) {
        Matcher matcher;
        while (true) {
            if ((matcher = this._incorrectLineBreakPattern1.matcher(content)).find()) {
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start());
                continue;
            }
            matcher = this._incorrectLineBreakPattern2.matcher(content);
            if (matcher.find()) {
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start());
                continue;
            }
            matcher = this._incorrectLineBreakPattern4.matcher(content);
            while (matcher.find()) {
                String matchingLine = matcher.group(2);
                if (matchingLine.startsWith("//") || matchingLine.startsWith("*")) continue;
                content = StringUtil.replaceFirst(content, matcher.group(3), "\n" + matcher.group(1) + "}\n", matcher.start(3) - 1);
                break;
            }
            matcher = this._incorrectLineBreakPattern5.matcher(content);
            while (matcher.find()) {
                String match;
                String tabs = matcher.group(2);
                Pattern pattern = Pattern.compile("\n" + tabs + "([^\t]{2})(?!.*\n" + tabs + "[^\t])", 32);
                Matcher matcher2 = pattern.matcher(content.substring(0, matcher.start(2)));
                if (!matcher2.find() || (match = matcher2.group(1)).equals(").")) continue;
                content = StringUtil.replaceFirst(content, "\n" + matcher.group(2), "", matcher.end(1));
                break;
            }
            if ((matcher = this._incorrectLineBreakPattern6.matcher(content)).find()) {
                content = StringUtil.replaceFirst(content, "{", "{\n" + matcher.group(1) + "\t", matcher.start());
            }
            matcher = this._incorrectLineBreakPattern7.matcher(content);
            while (matcher.find()) {
                String singleLine;
                if (content.charAt(matcher.end()) != '\n' || this.getLineLength(singleLine = matcher.group(1) + StringUtil.trimLeading(matcher.group(2)) + matcher.group(3)) > this._maxLineLength) continue;
                content = StringUtil.replace(content, matcher.group(), "\n" + singleLine);
                break;
            }
            if (!(matcher = this._redundantCommaPattern.matcher(content)).find()) break;
            content = StringUtil.replaceFirst(content, ",", "", matcher.start());
        }
        matcher = this._incorrectLineBreakPattern3.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group()) != 0) continue;
            int lineCount = this.getLineCount(content, matcher.start());
            this.processMessage(fileName, "There should be a line break before '" + matcher.group(1) + "'", lineCount);
        }
        return content;
    }

    protected String fixLineStartingWithCloseParenthesis(String content, String fileName) {
        Matcher matcher = this._lineStartingWithOpenParenthesisPattern.matcher(content);
        while (matcher.find()) {
            String line;
            String tabs = matcher.group(2);
            int lineCount = this.getLineCount(content, matcher.start(2));
            String lastCharacterPreviousLine = matcher.group(1);
            if (lastCharacterPreviousLine.equals("(")) {
                this.processMessage(fileName, "Line should not start with ')'", this.getLineCount(content, matcher.start(1)));
                return content;
            }
            while (this.getLeadingTabCount(line = this.getLine(content, --lineCount)) != tabs.length()) {
            }
            String trimmedLine = StringUtil.trimLeading(line);
            if (trimmedLine.startsWith(").") || trimmedLine.startsWith("@")) continue;
            return StringUtil.replaceFirst(content, "\n" + tabs, "", matcher.start());
        }
        return content;
    }

    protected String fixMissingEmptyLineAfterSettingVariable(String content) {
        Matcher matcher = this._setVariablePattern.matcher(content);
        while (matcher.find()) {
            int z;
            int y;
            if (content.charAt(matcher.end()) == '\n') continue;
            int x = content.indexOf(";\n", matcher.end());
            if (x == -1) {
                return content;
            }
            String nextCommand = content.substring(matcher.end() - 1, x + 1);
            if (nextCommand.contains("{\n")) continue;
            String variableName = matcher.group(1);
            Pattern pattern2 = Pattern.compile("\\W(" + variableName + ")\\.");
            Matcher matcher2 = pattern2.matcher(nextCommand);
            if (!matcher2.find() || ToolsUtil.isInsideQuotes(nextCommand, x = matcher2.start(1)) || (y = content.lastIndexOf("\ttry (", x += matcher.end())) != -1 && (z = content.indexOf(") {\n", y)) > x) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(2));
        }
        return content;
    }

    protected String fixMissingEmptyLines(String content) {
        Matcher matcher = this._missingEmptyLinePattern1.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group()) != 0) continue;
            content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = this._missingEmptyLinePattern2.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            if (!match.contains("(")) continue;
            String whitespace = matcher.group(1);
            int x = content.indexOf(whitespace + "}" + "\n", matcher.end());
            int y = content.indexOf(whitespace + "}" + "\n\n", matcher.end());
            if (x == -1 || x == y) continue;
            content = StringUtil.replaceFirst(content, "\n", "\n\n", x + 1);
        }
        return content;
    }

    protected String fixMultiLineComment(String content) {
        Matcher matcher = this._incorrectMultiLineCommentPattern.matcher(content);
        return matcher.replaceAll("$1$2$3");
    }

    protected String fixRedundantEmptyLines(String content) {
        Matcher matcher = this._redundantEmptyLines1.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "", matcher.start());
        }
        matcher = this._redundantEmptyLines2.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "", matcher.end() - 1);
        }
        return content;
    }

    protected String fixSystemExceptions(String content) {
        if (!content.contains("SystemException")) {
            return content;
        }
        Matcher matcher = this._throwsSystemExceptionPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String replacement = null;
        String afterException = matcher.group(3);
        String beforeException = matcher.group(2);
        if (Validator.isNull(beforeException) && Validator.isNull(afterException)) {
            replacement = matcher.group(4);
            String beforeThrows = matcher.group(1);
            if (Validator.isNotNull(StringUtil.trim(beforeThrows))) {
                replacement = beforeThrows + replacement;
            }
        } else {
            replacement = Validator.isNull(beforeException) ? StringUtil.replaceFirst(match, "SystemException, ", "") : StringUtil.replaceFirst(match, ", SystemException", "");
        }
        if (match.equals(replacement)) {
            return content;
        }
        return this.fixSystemExceptions(StringUtil.replaceFirst(content, match, replacement));
    }

    protected String formatAnnotations(String fileName, String javaTermName, String content, String indent, boolean sortAnnotations) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));
        String line = null;
        String annotation = "";
        String previousAnnotation = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.equals(indent + "}")) {
                return content;
            }
            int tabCount = StringUtil.count(line, '\t');
            if (tabCount < indent.length() && Validator.isNull(annotation)) continue;
            if (tabCount < indent.length() || tabCount == indent.length() && !line.startsWith(indent + ")")) {
                if (Validator.isNotNull(annotation) && annotation.contains("(")) {
                    String match;
                    Matcher matcher = _annotationPattern.matcher(annotation);
                    if (matcher.find() && this.getLevel(match = matcher.group()) == 0 && !match.endsWith("\n)\n") && !match.endsWith("\t)\n")) {
                        String tabs = matcher.group(1);
                        String replacement = StringUtil.replaceLast(match, ")", "\n" + tabs + ")");
                        return StringUtil.replace(content, match, replacement);
                    }
                    String newContent = this.checkAnnotationParameterProperties(content, annotation);
                    newContent = this.checkAnnotationMetaTypeProperties(newContent, annotation);
                    if (!(newContent = this.checkAnnotationLineBreaks(newContent, annotation)).equals(content)) {
                        return this.formatAnnotations(fileName, javaTermName, newContent, indent, sortAnnotations);
                    }
                    String newAnnotation = this.formatAnnotations(fileName, javaTermName, annotation, indent + "\t\t", false);
                    if (!newAnnotation.equals(annotation)) {
                        return StringUtil.replace(content, annotation, newAnnotation);
                    }
                }
                if (sortAnnotations && Validator.isNotNull(previousAnnotation) && previousAnnotation.compareToIgnoreCase(annotation) > 0) {
                    content = StringUtil.replaceFirst(content, previousAnnotation, annotation);
                    content = StringUtil.replaceLast(content, annotation, previousAnnotation);
                    return this.formatAnnotations(fileName, javaTermName, content, indent, sortAnnotations);
                }
                if (line.startsWith(indent + "@")) {
                    if (Validator.isNotNull(annotation)) {
                        previousAnnotation = annotation;
                    }
                    annotation = line + "\n";
                    continue;
                }
                annotation = "";
                previousAnnotation = "";
                continue;
            }
            if (Validator.isNull(annotation)) {
                return content;
            }
            annotation = annotation + line + "\n";
        }
        return content;
    }

    protected String formatArray(String content) {
        Matcher matcher = this._arrayPattern.matcher(content);
        while (matcher.find()) {
            String newLine = matcher.group(3) + matcher.group(2) + matcher.group(4) + matcher.group(5);
            if (this.getLineLength(newLine) > this._maxLineLength) continue;
            return StringUtil.replace(content, matcher.group(), matcher.group(1) + "\n" + newLine + "\n");
        }
        return content;
    }

    protected String formatAssertEquals(String fileName, String content) {
        if (!fileName.endsWith("Test.java")) {
            return content;
        }
        Matcher matcher = this._assertEqualsPattern.matcher(content);
        while (matcher.find()) {
            String parameters = StringUtil.trim(matcher.group(1));
            List<String> parametersList = this.splitParameters(parameters);
            if (parametersList.size() != 2) continue;
            String actualParameter = parametersList.get(1);
            String strippedQuotesActualParameter = this.stripQuotes(actualParameter);
            if (!actualParameter.startsWith("expected") && !Validator.isDigit(actualParameter) && Validator.isNotNull(strippedQuotesActualParameter)) continue;
            String assertEquals = matcher.group();
            String expectedParameter = parametersList.get(0);
            String newAssertEquals = StringUtil.replaceFirst(assertEquals, expectedParameter, actualParameter, assertEquals.indexOf(40));
            newAssertEquals = StringUtil.replaceLast(newAssertEquals, actualParameter, expectedParameter);
            return StringUtil.replace(content, assertEquals, newAssertEquals);
        }
        return content;
    }

    protected String formatClassLine(String content) {
        Matcher matcher = this._classPattern.matcher(content);
        while (matcher.find()) {
            String firstTrailingNonWhitespace = matcher.group(9);
            String match = matcher.group(1);
            String trailingWhitespace = matcher.group(8);
            if (!trailingWhitespace.contains("\n") && !firstTrailingNonWhitespace.equals("}")) {
                return StringUtil.replace(content, match, match + "\n");
            }
            String formattedClassLine = this.getFormattedClassLine(matcher.group(2), match);
            if (formattedClassLine == null) continue;
            content = StringUtil.replace(content, match, formattedClassLine);
        }
        return content;
    }

    protected String formatDeprecatedJavadoc(String fileName, String absolutePath, String line) throws Exception {
        Matcher matcher = this._deprecatedPattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        ComparableVersion mainReleaseComparableVersion = this.getMainReleaseComparableVersion(fileName, absolutePath, true);
        if (mainReleaseComparableVersion == null) {
            return line;
        }
        if (matcher.group(2) == null) {
            return StringUtil.insert(line, " As of " + mainReleaseComparableVersion.toString(), matcher.end(1));
        }
        String version = matcher.group(3);
        ComparableVersion comparableVersion = new ComparableVersion(version);
        if (comparableVersion.compareTo(mainReleaseComparableVersion) > 0) {
            return StringUtil.replaceFirst(line, version, mainReleaseComparableVersion.toString());
        }
        if (StringUtil.count(version, '.') == 1) {
            return StringUtil.insert(line, ".0", matcher.end(3));
        }
        String deprecatedInfo = matcher.group(4);
        if (deprecatedInfo != null && !deprecatedInfo.startsWith(",")) {
            return StringUtil.insert(line, ",", matcher.end(3));
        }
        return line;
    }

    protected String formatDuplicateReferenceMethods(String fileName, String content, String className, String packagePath) throws Exception {
        String moduleSuperClassContent = this.getModuleSuperClassContent(content, className, packagePath);
        if (Validator.isNull(moduleSuperClassContent) || !moduleSuperClassContent.contains("@Component") || !moduleSuperClassContent.contains("@Reference")) {
            this.setBNDInheritRequiredValue(fileName, false);
            return content;
        }
        boolean bndInheritRequired = false;
        Matcher matcher = this._referenceMethodPattern.matcher(moduleSuperClassContent);
        while (matcher.find()) {
            String referenceMethod = matcher.group();
            int pos = content.indexOf(referenceMethod);
            if (pos != -1) {
                String variableName;
                String referenceMethodContent = matcher.group(6);
                Matcher referenceMethodContentMatcher = this._referenceMethodContentPattern.matcher(referenceMethodContent);
                if (referenceMethodContentMatcher.find() && StringUtil.count(content, variableName = referenceMethodContentMatcher.group(1)) > 1) continue;
                int x = content.lastIndexOf("\n\n", pos);
                int y = pos + referenceMethod.length();
                String entireMethod = content.substring(x + 1, y);
                content = StringUtil.replace(content, entireMethod, "");
                bndInheritRequired = true;
                continue;
            }
            String referenceMethodModifierAndName = matcher.group(2);
            Pattern duplicateReferenceMethodPattern = Pattern.compile(referenceMethodModifierAndName + "\\(\\s*([ ,<>\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)\\s*?\n\t\\}\n");
            Matcher duplicateReferenceMethodMatcher = duplicateReferenceMethodPattern.matcher(content);
            if (!duplicateReferenceMethodMatcher.find()) {
                bndInheritRequired = true;
                continue;
            }
            String methodContent = duplicateReferenceMethodMatcher.group(2);
            String referenceMethodName = matcher.group(4);
            if (!methodContent.startsWith("super." + referenceMethodName)) continue;
            int x = content.lastIndexOf("\n\n", duplicateReferenceMethodMatcher.start());
            int y = duplicateReferenceMethodMatcher.end();
            String entireMethod = content.substring(x + 1, y);
            content = StringUtil.replace(content, entireMethod, "");
            bndInheritRequired = true;
        }
        this.setBNDInheritRequiredValue(fileName, bndInheritRequired);
        return content;
    }

    protected String formatExceptions(String content, File file, String packagePath, String fileName) throws IOException {
        Matcher matcher = this._catchExceptionPattern.matcher(content);
        int skipVariableNameCheckEndPos = -1;
        while (matcher.find()) {
            String exceptionClassName = matcher.group(2);
            String exceptionVariableName = matcher.group(3);
            String tabs = matcher.group(1);
            String expectedExceptionVariableName = "e";
            if (!exceptionClassName.contains(" |")) {
                Matcher lowerCaseNumberOrPeriodMatcher = this._lowerCaseNumberOrPeriodPattern.matcher(exceptionClassName);
                expectedExceptionVariableName = StringUtil.toLowerCase(lowerCaseNumberOrPeriodMatcher.replaceAll(""));
            }
            Pattern exceptionVariablePattern = Pattern.compile("(\\W)" + exceptionVariableName + "(\\W)");
            int pos = content.indexOf("\n" + tabs + "}", matcher.end() - 1);
            String insideCatchCode = content.substring(matcher.end(), pos + 1);
            if (insideCatchCode.contains("catch (" + exceptionClassName)) {
                skipVariableNameCheckEndPos = pos;
            }
            if (skipVariableNameCheckEndPos >= matcher.start() || expectedExceptionVariableName.equals(exceptionVariableName)) continue;
            String catchExceptionCodeBlock = content.substring(matcher.start(), pos + 1);
            Matcher exceptionVariableMatcher = exceptionVariablePattern.matcher(catchExceptionCodeBlock);
            String catchExceptionReplacement = exceptionVariableMatcher.replaceAll("$1" + expectedExceptionVariableName + "$2");
            return StringUtil.replaceFirst(content, catchExceptionCodeBlock, catchExceptionReplacement, matcher.start() - 1);
        }
        return content;
    }

    protected String formatIfClause(String ifClause) throws IOException {
        String strippedQuotesIfClause = this.stripQuotes(ifClause);
        if (strippedQuotesIfClause.contains("!(") || strippedQuotesIfClause.contains("//")) {
            return ifClause;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(ifClause));
        String line = null;
        String previousLine = null;
        int previousLineLength = 0;
        int previousLineLeadingWhitespace = 0;
        int previousLineLevel = 0;
        boolean previousLineIsStartCriteria = true;
        int baseLeadingWhitespace = 0;
        int insideMethodCallExpectedWhitespace = 0;
        int level = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String originalLine = line;
            String trimmedLine = StringUtil.trimLeading(line);
            int x = this.getIncorrectLineBreakPos(line, previousLine);
            if (x != -1) {
                String leadingWhitespace = line.substring(0, line.indexOf(trimmedLine));
                return StringUtil.replace(ifClause, line, line.substring(0, x) + "\n" + leadingWhitespace + line.substring(x + 1));
            }
            if (previousLineLength > 0 && previousLineIsStartCriteria && previousLineLevel >= 0 && previousLine.matches(".*[|&^]")) {
                Matcher matcher = this._ifStatementCriteriaPattern.matcher(trimmedLine);
                while (matcher.find()) {
                    String linePart;
                    int linePartLevel;
                    if (ToolsUtil.isInsideQuotes(trimmedLine, matcher.end()) || (linePartLevel = this.getLevel(linePart = trimmedLine.substring(0, matcher.end()))) > 0 || previousLineLength + linePart.length() >= this._maxLineLength) continue;
                    if (linePart.equals(trimmedLine)) {
                        return StringUtil.replace(ifClause, previousLine + "\n" + originalLine, previousLine + " " + trimmedLine);
                    }
                    String newPreviousLine = previousLine + " " + linePart;
                    String newLine = StringUtil.replaceFirst(originalLine, linePart, "");
                    return StringUtil.replace(ifClause, previousLine + "\n" + originalLine, newPreviousLine + "\n" + newLine);
                }
            }
            line = StringUtil.replace(line, "\t", "    ");
            int leadingWhitespace = line.length() - trimmedLine.length();
            if (Validator.isNull(previousLine)) {
                baseLeadingWhitespace = line.indexOf(40) + 1;
            } else if (previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^")) {
                int expectedLeadingWhitespace = baseLeadingWhitespace + level;
                if (leadingWhitespace != expectedLeadingWhitespace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhitespace - expectedLeadingWhitespace);
                }
            } else {
                int expectedLeadingWhitespace = 0;
                if (previousLine.contains("\telse if (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 3;
                } else if (previousLine.contains("\tif (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 4;
                } else if (previousLine.contains("\twhile (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 5;
                }
                if (previousLine.endsWith(",") && insideMethodCallExpectedWhitespace > 0) {
                    if (previousLineLevel < 0) {
                        insideMethodCallExpectedWhitespace -= 4;
                    }
                    expectedLeadingWhitespace = insideMethodCallExpectedWhitespace;
                } else {
                    if (expectedLeadingWhitespace == 0) {
                        expectedLeadingWhitespace = previousLineLeadingWhitespace + 4;
                    }
                    if (previousLine.endsWith("(")) {
                        insideMethodCallExpectedWhitespace = expectedLeadingWhitespace;
                    }
                }
                if (leadingWhitespace != expectedLeadingWhitespace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhitespace - expectedLeadingWhitespace);
                }
            }
            if (line.endsWith(") {")) {
                return ifClause;
            }
            int lineLevel = this.getLevel(trimmedLine);
            level += lineLevel;
            if (Validator.isNotNull(previousLine)) {
                previousLineIsStartCriteria = previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^");
            }
            previousLine = originalLine;
            previousLineLength = line.length();
            previousLineLevel = lineLevel;
            previousLineLeadingWhitespace = leadingWhitespace;
        }
        return ifClause;
    }

    protected String formatIfClause(String ifClause, String fileName, int lineCount) throws IOException {
        String ifClauseSingleLine = StringUtil.replace(ifClause, new String[]{"\t ", "\t", "(\n", "\n"}, new String[]{"\t", "", "(", " "});
        this.checkIfClauseParentheses(ifClauseSingleLine, fileName, lineCount);
        return this.formatIfClause(ifClause);
    }

    protected String formatJava(String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineCount = 0;
            String ifClause = "";
            String packageName = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String indent;
                String importPackageName;
                int pos;
                ++lineCount;
                if (line.startsWith("package ")) {
                    packageName = line.substring(8, line.length() - 1);
                }
                if (line.startsWith("import ") && (pos = line.lastIndexOf(46)) != -1 && (importPackageName = line.substring(7, pos)).equals(packageName)) continue;
                String trimmedLine = StringUtil.trimLeading(line);
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*")) {
                    if (!(!line.contains("\t ") || previousLine.matches(".*[&|^]") || previousLine.contains("\t((") || previousLine.contains("\t<") || previousLine.contains("\t ") || previousLine.contains("\tfor (") || previousLine.contains("\timplements ") || previousLine.contains("\tthrows "))) {
                        line = StringUtil.replace(line, "\t ", "\t");
                    }
                    line = this.formatIncorrectSyntax(line, ",}", "}", false);
                    line = this.formatWhitespace(line, trimmedLine, true);
                }
                if (!this.isExcludedPath(_HIBERNATE_SQL_QUERY_EXCLUDES, absolutePath) && line.contains("= session.createSQLQuery(") && content.contains("com.liferay.portal.kernel.dao.orm.Session")) {
                    line = StringUtil.replace(line, "createSQLQuery", "createSynchronizedSQLQuery");
                }
                line = this.replacePrimitiveWrapperInstantiation(line);
                if (trimmedLine.startsWith("throw new IOException(") && line.contains("e.getMessage()")) {
                    line = StringUtil.replace(line, ".getMessage()", "");
                }
                if (trimmedLine.contains("StopWatch stopWatch = null;")) {
                    this.processMessage(fileName, "Do not set stopwatch to null, see LPS-45492", lineCount);
                }
                this.checkEmptyCollection(trimmedLine, fileName, lineCount);
                line = this.formatEmptyArray(line);
                this.checkResourceUtil(line, fileName, absolutePath, lineCount);
                if (this._addMissingDeprecationReleaseVersion) {
                    line = this.formatDeprecatedJavadoc(fileName, absolutePath, line);
                }
                if (trimmedLine.startsWith("* @see ") && StringUtil.count(trimmedLine, '@') > 1) {
                    this.processMessage(fileName, "Do not use @see with another annotation", lineCount);
                }
                this.checkInefficientStringMethods(line, fileName, absolutePath, lineCount, true);
                if (trimmedLine.startsWith("=")) {
                    this.processMessage(fileName, "Line should not start with '='", lineCount);
                }
                if (line.contains("ActionForm form")) {
                    this.processMessage(fileName, "Rename 'form' to 'actionForm'", lineCount);
                }
                if (line.contains("ActionMapping mapping")) {
                    this.processMessage(fileName, "Rename 'mapping' to 'ActionMapping'", lineCount);
                }
                if (!trimmedLine.equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                    line = StringUtil.replaceLast(line, "{", " {");
                }
                int lineLeadingTabCount = this.getLeadingTabCount(line);
                int previousLineLeadingTabCount = this.getLeadingTabCount(previousLine);
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*")) {
                    int x;
                    String strippedQuotesLine = this.stripQuotes(trimmedLine);
                    indent = "";
                    if (!trimmedLine.startsWith("}") && strippedQuotesLine.contains("}") && this.getLevel(strippedQuotesLine, "{", "}") < 0 && lineLeadingTabCount > 0) {
                        for (int i = 0; i < lineLeadingTabCount - 1; ++i) {
                            indent = indent + "\t";
                        }
                        x = line.lastIndexOf(125);
                        String string = StringUtil.replace(content, "\n" + line + "\n", "\n" + line.substring(0, x) + "\n" + indent + line.substring(x) + "\n");
                        return string;
                    }
                    if (Validator.isNull(ifClause) && !previousLine.contains("\tthrows ") && !previousLine.contains(" throws ") && previousLineLeadingTabCount == lineLeadingTabCount - 1) {
                        x = -1;
                        while ((x = previousLine.indexOf(", ", x + 1)) != -1) {
                            if (ToolsUtil.isInsideQuotes(previousLine, x)) continue;
                            String linePart = previousLine.substring(0, x);
                            if (this.getLevel(linePart = this.stripQuotes(linePart), "(", ")") != 0 || this.getLevel(linePart, "<", ">") != 0) continue;
                            linePart = previousLine.substring(x);
                            if (this.getLevel(linePart = this.stripQuotes(linePart, '\"'), "(", ")") != 0 || this.getLevel(linePart, "<", ">") != 0) continue;
                            if (Validator.isNull(indent)) {
                                for (int i = 0; i < lineLeadingTabCount - 1; ++i) {
                                    indent = indent + "\t";
                                }
                            }
                            String string = StringUtil.replace(content, "\n" + previousLine + "\n", "\n" + previousLine.substring(0, x + 1) + "\n" + indent + previousLine.substring(x + 2) + "\n");
                            return string;
                        }
                    }
                    if (trimmedLine.startsWith(".")) {
                        this.processMessage(fileName, "Line should not start with '.'", lineCount);
                    }
                    if (previousLine.endsWith("(") && trimmedLine.startsWith(")")) {
                        this.processMessage(fileName, "Line should not start with ')'", lineCount);
                    }
                }
                if (line.contains("    ") && !line.matches("\\s*\\*.*") && !fileName.endsWith("StringPool.java")) {
                    this.processMessage(fileName, "Use tabs instead of spaces", lineCount);
                }
                if (line.contains("  {") && !line.matches("\\s*\\*.*")) {
                    this.processMessage(fileName, "{", lineCount);
                }
                if (trimmedLine.startsWith("catch (") || trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (") || Validator.isNotNull(ifClause)) {
                    ifClause = ifClause + line + "\n";
                    if (line.endsWith(") {")) {
                        String newIfClause = this.formatIfClause(ifClause, fileName, lineCount);
                        if (!ifClause.equals(newIfClause) && content.contains(ifClause)) {
                            indent = StringUtil.replace(content, ifClause, newIfClause);
                            return indent;
                        }
                        ifClause = "";
                    } else if (line.endsWith(";")) {
                        String trimmedIfClause = StringUtil.trim(ifClause);
                        if (!trimmedIfClause.startsWith("while ") && !trimmedIfClause.contains("{\t")) {
                            this.processMessage(fileName, "Incorrect if statement", lineCount);
                        }
                        ifClause = "";
                    }
                }
                int lineLength = this.getLineLength(line);
                if (!(line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_DROP = ") || fileName.endsWith("Table.java") && line.contains(" index IX_"))) {
                    if (lineLength > this._maxLineLength) {
                        if (!this.isExcludedPath(_LINE_LENGTH_EXCLUDES, absolutePath, lineCount) && !this.isAnnotationParameter(content, trimmedLine)) {
                            String truncateLongLinesContent = this.getTruncateLongLinesContent(content, line, trimmedLine, lineCount);
                            if (truncateLongLinesContent != null && !truncateLongLinesContent.equals(content)) {
                                String string = truncateLongLinesContent;
                                return string;
                            }
                            this.processMessage(fileName, "> " + this._maxLineLength, lineCount);
                        }
                    } else {
                        String combinedLinesContent;
                        this.checkIndentationAndLineBreaks(line, previousLine, fileName, lineCount);
                        if (!trimmedLine.startsWith("//") && lineLeadingTabCount - 2 == previousLineLeadingTabCount && previousLineLeadingTabCount > 0 && line.endsWith(";") && !previousLine.contains("\tfor (") && !previousLine.contains("\ttry (")) {
                            line = StringUtil.replaceFirst(line, "\t", "");
                        }
                        if ((combinedLinesContent = this.getCombinedLinesContent(content, fileName, absolutePath, line, trimmedLine, lineLength, lineCount, previousLine, lineLeadingTabCount, previousLineLeadingTabCount)) != null && !combinedLinesContent.equals(content)) {
                            String string = combinedLinesContent;
                            return string;
                        }
                    }
                }
                if (lineCount > 1) {
                    sb.append(previousLine);
                    sb.append("\n");
                    if (this.addExtraEmptyLine(previousLine, line, true)) {
                        sb.append("\n");
                    }
                }
                previousLine = line;
            }
            sb.append(previousLine);
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    protected String formatModulesFile(String fileName, String absolutePath, String className, String packagePath, String content) throws Exception {
        Matcher matcher;
        if (fileName.endsWith("Test.java")) {
            if (absolutePath.contains("/src/testIntegration/java/") || absolutePath.contains("/test/integration/")) {
                if (content.contains("@RunWith(Arquillian.class)") && content.contains("import org.powermock.")) {
                    this.processMessage(fileName, "Do not use PowerMock inside Arquillian tests, see LPS-56706");
                }
                if (!packagePath.endsWith(".test")) {
                    this.processMessage(fileName, "Module integration test must be under a test subpackage, see LPS-57722");
                }
            } else if ((absolutePath.contains("/test/unit/") || absolutePath.contains("/src/test/java/")) && packagePath.endsWith(".test")) {
                this.processMessage(fileName, "Module unit test should not be under a test subpackage, see LPS-57722");
            }
        }
        if (content.contains("ServiceProxyFactory.newServiceTrackedInstance(")) {
            this.processMessage(fileName, "Do not use ServiceProxyFactory.newServiceTrackedInstance in modules, see LPS-57358");
        }
        if (content.contains("@Component")) {
            content = this.formatOSGIComponents(fileName, absolutePath, content, className, packagePath);
        }
        if (!(absolutePath.contains("/modules/core/jaxws-osgi-bridge") || absolutePath.contains("/modules/core/portal-bootstrap") || absolutePath.contains("/modules/core/registry-") || absolutePath.contains("/modules/core/slim-runtime") || !this._checkRegistryInTestClasses && (absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) || !(matcher = this._registryImportPattern.matcher(content)).find())) {
            this.processMessage(fileName, "Do not use com.liferay.registry classes in modules, see LPS-62989");
        }
        if (!absolutePath.contains("/test/") && content.contains("@Meta.OCD") && !content.contains("@ExtendedObjectClassDefinition")) {
            this.processMessage(fileName, "Specify category using @ExtendedObjectClassDefinition, see LPS-60186");
        }
        if (content.contains("import com.liferay.util.dao.orm.CustomSQLUtil")) {
            this.processMessage(fileName, "Do not use com.liferay.util.dao.orm.CustomSQLUtil in modules, see LPS-64238");
        }
        if (content.contains("import com.liferay.util.ContentUtil")) {
            this.processMessage(fileName, "Do not use com.liferay.util.ContentUtil in modules, see LPS-64335");
        }
        this.checkInternalImports(fileName, absolutePath, content);
        return content;
    }

    protected String formatOSGIComponents(String fileName, String absolutePath, String content, String className, String packagePath) throws Exception {
        String moduleServicePackagePath = null;
        Matcher matcher = this._serviceUtilImportPattern.matcher(content);
        while (matcher.find()) {
            String serviceUtilClassPackagePath;
            String serviceUtilClassName = matcher.group(2);
            if (moduleServicePackagePath == null) {
                moduleServicePackagePath = this.getModuleServicePackagePath(fileName);
            }
            if (Validator.isNotNull(moduleServicePackagePath) && (serviceUtilClassPackagePath = matcher.group(1)).startsWith(moduleServicePackagePath)) continue;
            this.processMessage(fileName, "Use @Reference instead of calling " + serviceUtilClassName + " directly, see LPS-59076");
        }
        matcher = this._referenceMethodPattern.matcher(content);
        while (matcher.find()) {
            String methodContent;
            Matcher referenceMethodContentMatcher;
            String methodName = matcher.group(4);
            if (!methodName.startsWith("set")) continue;
            String annotationParameters = matcher.group(1);
            if (!annotationParameters.contains("unbind =") && !content.contains("un" + methodName + "(")) {
                if (Validator.isNull(annotationParameters)) {
                    return StringUtil.insert(content, "(unbind = \"-\")", matcher.start(1));
                }
                if (!annotationParameters.contains("\n")) {
                    return StringUtil.insert(content, ", unbind = \"-\"", matcher.end(1) - 1);
                }
                if (!annotationParameters.contains("\n\n")) {
                    String indent = "\t\t";
                    int x = content.lastIndexOf("\n", matcher.end(1) - 1);
                    return StringUtil.replaceFirst(content, "\n", ",\n" + indent + "unbind = \"-\"\n", x - 1);
                }
            }
            if (!(referenceMethodContentMatcher = this._referenceMethodContentPattern.matcher(methodContent = matcher.group(6))).find()) continue;
            String typeName = matcher.group(5);
            String variableName = referenceMethodContentMatcher.group(1);
            StringBundler sb = new StringBundler(5);
            sb.append("private volatile ");
            sb.append(typeName);
            sb.append("\\s+");
            sb.append(variableName);
            sb.append(";");
            Pattern privateVarPattern = Pattern.compile(sb.toString());
            Matcher privateVarMatcher = privateVarPattern.matcher(content);
            if (!privateVarMatcher.find()) continue;
            String match = privateVarMatcher.group();
            String replacement = StringUtil.replace(match, "private volatile ", "private ");
            return StringUtil.replace(content, match, replacement);
        }
        return this.formatDuplicateReferenceMethods(fileName, content, className, packagePath);
    }

    protected String formatValidatorEquals(String content) {
        Matcher matcher = validatorEqualsPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        if ((content = StringUtil.replaceFirst(content, "Validator.equals(", "Objects.equals(")).contains("import java.util.Objects;")) {
            return content;
        }
        int pos = content.indexOf("\npackage ");
        pos = content.indexOf("\n", pos + 1);
        return StringUtil.insert(content, "import java.util.Objects;\n", pos + 1);
    }

    protected String getCombinedLinesContent(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String match;
            String tabs = matcher.group(1);
            int x = matcher.start(1);
            String openChar = matcher.group(matcher.groupCount());
            int y = -1;
            if (openChar.equals("{")) {
                y = content.indexOf("\n" + tabs + "}", x);
            } else if (openChar.equals("(")) {
                y = content.indexOf("\n" + tabs + ")", x);
            }
            y = content.indexOf(10, y + 1);
            if (y < x) {
                return content;
            }
            String replacement = match = content.substring(x, y);
            while (replacement.contains("\n\t")) {
                replacement = StringUtil.replace(replacement, "\n\t", "\n");
            }
            if (this.getLineLength(replacement = StringUtil.replace(replacement, new String[]{",\n", "\n"}, new String[]{", ", ""})) > this._maxLineLength) continue;
            return this.getCombinedLinesContent(StringUtil.replace(content, match, replacement), pattern);
        }
        return content;
    }

    protected String getCombinedLinesContent(String content, String fileName, String line, String trimmedLine, int lineLength, int lineCount, String previousLine, String linePart, boolean addToPreviousLine, boolean extraSpace, int numNextLinesRemoveLeadingTab) {
        int previousLineStartPos = this.getLineStartPos(content, lineCount - 1);
        if (linePart == null) {
            String combinedLine = previousLine;
            if (extraSpace) {
                combinedLine = combinedLine + " ";
            }
            combinedLine = combinedLine + trimmedLine;
            String nextLine = this.getLine(content, lineCount + 1);
            if (nextLine == null) {
                return null;
            }
            if (numNextLinesRemoveLeadingTab > 0) {
                int nextLineStartPos = this.getLineStartPos(content, lineCount + 1);
                for (int i = 0; i < numNextLinesRemoveLeadingTab; ++i) {
                    content = StringUtil.replaceFirst(content, "\t", "", nextLineStartPos);
                    nextLineStartPos = content.indexOf(10, nextLineStartPos) + 1;
                }
            }
            return StringUtil.replaceFirst(content, previousLine + "\n" + line, combinedLine, previousLineStartPos);
        }
        String firstLine = previousLine;
        String secondLine = line;
        if (addToPreviousLine) {
            if (extraSpace) {
                firstLine = firstLine + " ";
            }
            firstLine = firstLine + linePart;
            secondLine = StringUtil.replaceFirst(line, linePart, "");
        } else if (linePart.length() + lineLength <= this._maxLineLength && (line.endsWith("{") || line.endsWith(";"))) {
            firstLine = StringUtil.replaceLast(firstLine, StringUtil.trim(linePart), "");
            secondLine = extraSpace ? StringUtil.replaceLast(line, "\t", "\t" + linePart + " ") : StringUtil.replaceLast(line, "\t", "\t" + linePart);
        } else {
            this.processMessage(fileName, "Incorrect line break", lineCount);
            return null;
        }
        firstLine = StringUtil.trimTrailing(firstLine);
        return StringUtil.replaceFirst(content, previousLine + "\n" + line, firstLine + "\n" + secondLine, previousLineStartPos);
    }

    protected String getCombinedLinesContent(String content, String fileName, String absolutePath, String line, String trimmedLine, int lineLength, int lineCount, String previousLine, int lineTabCount, int previousLineTabCount) {
        String filePart;
        char c;
        int pos;
        String nextLine;
        int nextLineTabCount;
        if (Validator.isNull(line) || Validator.isNull(previousLine) || this.isExcludedPath(_FIT_ON_SINGLE_LINE_EXCLUDES, absolutePath, lineCount)) {
            return null;
        }
        String trimmedPreviousLine = StringUtil.trimLeading(previousLine);
        String strippedQuotesLine = this.stripQuotes(line);
        String strippedQuotesPreviousLine = this.stripQuotes(previousLine);
        if (strippedQuotesLine.contains("// ") || strippedQuotesLine.contains("/*") || strippedQuotesLine.contains("*/") || strippedQuotesPreviousLine.contains("// ") || strippedQuotesPreviousLine.contains("/*") || strippedQuotesPreviousLine.contains("*/")) {
            return null;
        }
        if (!trimmedPreviousLine.equals("return") && previousLine.matches(".*\\w") && trimmedLine.startsWith("(")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, "(", true, false, 0);
        }
        if (trimmedPreviousLine.matches("((else )?if|for|try|while) \\(")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
        }
        if (previousLine.endsWith("= new")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, "new", false, true, 0);
        }
        if (trimmedLine.startsWith("+ ") || trimmedLine.startsWith("- ") || trimmedLine.startsWith("|| ") || trimmedLine.startsWith("&& ")) {
            int pos2 = trimmedLine.indexOf(32);
            String linePart = trimmedLine.substring(0, pos2);
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart, true, true, 0);
        }
        if (previousLine.endsWith("<") && !previousLine.endsWith(" <")) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, "<", false, false, 0);
        }
        int previousLineLength = this.getLineLength(previousLine);
        if (trimmedLine.length() + previousLineLength < this._maxLineLength) {
            String beforePrevousLine;
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (!(!previousLine.endsWith(">") || trimmedPreviousLine.startsWith("<") || this.getLevel(previousLine, "<", ">") != 0 || trimmedLine.startsWith("extends") || trimmedLine.startsWith("implements") || (beforePrevousLine = this.getLine(content, lineCount - 2)).endsWith("."))) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (!(!line.endsWith(";") || previousLine.endsWith(":") || previousLine.endsWith("[") || previousLine.endsWith("{") || previousLine.endsWith("(") || previousLine.endsWith(".") || !previousLine.contains("[") && previousLine.contains("]") || lineTabCount != previousLineTabCount + 1)) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (trimmedLine.startsWith("throws") && (line.endsWith("{") || line.endsWith(";")) && lineTabCount == previousLineTabCount + 1) {
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (previousLine.endsWith("=")) {
                if (line.endsWith("{")) {
                    this.processMessage(fileName, "'" + trimmedLine + "' should be added to previous line", lineCount);
                    return null;
                }
                if (previousLine.endsWith(" =") && line.endsWith("(")) {
                    int i = 0;
                    while (true) {
                        String nextLine2;
                        if (Validator.isNull(nextLine2 = this.getLine(content, lineCount + i + 1)) || nextLine2.endsWith(") {")) {
                            this.processMessage(fileName, "'" + trimmedLine + "' should be added to previous line", lineCount);
                            return null;
                        }
                        if (nextLine2.endsWith(") +")) {
                            return null;
                        }
                        if (nextLine2.endsWith(";")) {
                            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, i + 1);
                        }
                        ++i;
                    }
                }
            }
            if (trimmedPreviousLine.equals("return")) {
                int i = 0;
                while (true) {
                    String nextLine3;
                    if ((nextLine3 = this.getLine(content, lineCount + i + 1)).endsWith(";")) {
                        return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, i + 1);
                    }
                    ++i;
                }
            }
        }
        if (trimmedLine.length() + previousLineLength <= this._maxLineLength && (previousLine.endsWith(".") && !line.endsWith("(") || (previousLine.endsWith("[") || previousLine.endsWith("(")) && line.endsWith(";"))) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
        }
        if (previousLine.endsWith("=") && line.endsWith(";")) {
            String tempLine = trimmedLine;
            int pos3 = 0;
            while (true) {
                if ((pos3 = tempLine.indexOf(45)) == -1) {
                    pos3 = tempLine.indexOf(43);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf(47);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf(42);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("||");
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("&&");
                }
                if (pos3 == -1) break;
                String linePart = tempLine.substring(0, pos3);
                if (this.getLevel(linePart) == 0) {
                    return null;
                }
                tempLine = tempLine.substring(0, pos3) + tempLine.substring(pos3 + 1);
            }
            int x = trimmedLine.indexOf(40);
            if (x == 0) {
                x = trimmedLine.indexOf(40, 1);
            }
            if (x != -1) {
                char previousChar;
                int y = trimmedLine.indexOf(41, x);
                int z = trimmedLine.indexOf(34);
                if (x + 1 != y && (z == -1 || z > x) && (previousChar = trimmedLine.charAt(x - 1)) != ')' && previousChar != '(' && previousChar != ' ' && previousLineLength + 1 + x < this._maxLineLength) {
                    String linePart = trimmedLine.substring(0, x + 1);
                    if (this.getLevel(linePart, "{", "}") > 0) {
                        return null;
                    }
                    if (linePart.startsWith("(") && !linePart.contains(")")) {
                        return null;
                    }
                    return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart, true, true, 0);
                }
            }
        }
        if (previousLine.endsWith("+") && lineTabCount == previousLineTabCount + 1) {
            int x = -1;
            while ((x = trimmedLine.indexOf(" +", x + 1)) != -1 && previousLineLength + 3 + x <= this._maxLineLength) {
                String linePart;
                if (ToolsUtil.isInsideQuotes(trimmedLine, x) || this.getLevel(linePart = trimmedLine.substring(0, x + 2)) != 0) continue;
                if (trimmedLine.equals(linePart)) {
                    this.processMessage(fileName, "Incorrect line break", lineCount);
                    return null;
                }
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart + " ", true, true, 0);
            }
        }
        if (previousLine.endsWith(",") && previousLineTabCount == lineTabCount && !trimmedPreviousLine.equals("},") && (nextLineTabCount = this.getLeadingTabCount(nextLine = this.getLine(content, lineCount + 1))) != lineTabCount + 1) {
            String linePart;
            int x = -1;
            while ((x = trimmedLine.indexOf(44, x + 1)) != -1 && (ToolsUtil.isInsideQuotes(trimmedLine, x) || this.getLevel(linePart = trimmedLine.substring(0, x), "(", ")") != 0 || this.getLevel(linePart, "{", "}") != 0 || this.getLevel(linePart, "<", ">") != 0)) {
            }
            if (x != -1) {
                while (previousLineLength + 1 + x < this._maxLineLength) {
                    linePart = trimmedLine.substring(0, x + 1);
                    if (!ToolsUtil.isInsideQuotes(trimmedLine, x) && this.isValidJavaParameter(linePart)) {
                        if (trimmedLine.equals(linePart)) {
                            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
                        }
                        return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart + " ", true, true, 0);
                    }
                    String partAfterComma = trimmedLine.substring(x + 1);
                    int pos4 = partAfterComma.indexOf(44);
                    if (pos4 != -1) {
                        x = x + pos4 + 1;
                        continue;
                    }
                    break;
                }
            } else if (trimmedLine.length() + previousLineLength < this._maxLineLength) {
                if (!trimmedLine.startsWith("new ") || !line.endsWith("{")) {
                    return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
                }
                if (this.getLevel(line) != 0) {
                    return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
                }
            }
        }
        if (trimmedPreviousLine.matches("^[^<].*[\\w>]$") && previousLineTabCount == lineTabCount - 1 && this.getLevel(previousLine, "<", ">") == 0) {
            int x = trimmedLine.indexOf(" = ");
            if (x != -1 && !ToolsUtil.isInsideQuotes(trimmedLine, x) && previousLineLength + 2 + x < this._maxLineLength) {
                String linePart = trimmedLine.substring(0, x + 3);
                return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, linePart, true, true, 0);
            }
            if (trimmedLine.endsWith(" =") && trimmedLine.length() + previousLineLength < this._maxLineLength) {
                int i = 0;
                while (true) {
                    String nextLine4;
                    if ((nextLine4 = this.getLine(content, lineCount + i + 1)).endsWith(";")) {
                        return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, i + 1);
                    }
                    ++i;
                }
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        int x = -1;
        while ((x = trimmedLine.indexOf(") ", x + 1)) != -1) {
            int y;
            String linePart2;
            String linePart1 = trimmedLine.substring(0, x);
            if (ToolsUtil.isInsideQuotes(trimmedLine, x) || this.getLevel(linePart1) != 0 || !(linePart2 = trimmedLine.substring(x + 2)).matches("[!=<>\\+\\-\\*]+ .*") || previousLineLength + (y = trimmedLine.indexOf(" ", x + 2)) > this._maxLineLength) continue;
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, trimmedLine.substring(0, y), true, true, 0);
        }
        if (!(StringUtil.count(previousLine, '(') <= 1 || (pos = trimmedPreviousLine.lastIndexOf(40, trimmedPreviousLine.length() - 2)) <= 0 || (c = trimmedPreviousLine.charAt(pos - 1)) == '(' || Character.isWhitespace(c) || (filePart = trimmedPreviousLine.substring(pos + 1)).contains(")") || filePart.contains("\""))) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, filePart, false, false, 0);
        }
        if (trimmedLine.length() + previousLineLength > this._maxLineLength) {
            return null;
        }
        if (this.getLevel(trimmedLine) < 0 && (line.matches(".*[|&^]") || line.endsWith(",") || trimmedPreviousLine.startsWith("new ") && line.endsWith(") {"))) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
        }
        if ((line.endsWith("{") && !trimmedLine.startsWith("new ") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return this.getCombinedLinesContent(content, fileName, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
        }
        return null;
    }

    protected String getFormattedClassLine(String indent, String classLine) {
        ArrayList<String> lines;
        block15: {
            while (classLine.contains("\t ")) {
                classLine = StringUtil.replace(classLine, "\t ", "\t");
            }
            String classSingleLine = StringUtil.replace(classLine.substring(1), new String[]{"\t", "\n"}, new String[]{"", " "});
            classSingleLine = indent + classSingleLine;
            lines = new ArrayList<String>();
            if (this.getLineLength(classSingleLine) <= this._maxLineLength) {
                lines.add(classSingleLine);
            } else {
                int y;
                String newIndent = indent;
                String newLine = classSingleLine;
                int x = -1;
                while ((x = (y = newLine.indexOf(" extends ", x + 1)) == -1 ? newLine.indexOf(" implements ", x + 1) : y) != -1) {
                    String linePart = newLine.substring(0, x);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this._maxLineLength) continue;
                    if (lines.isEmpty()) {
                        newIndent = newIndent + "\t";
                    }
                    lines.add(linePart);
                    newLine = newIndent + newLine.substring(x + 1);
                    if (this.getLineLength(newLine) <= this._maxLineLength) {
                        lines.add(newLine);
                        break block15;
                    }
                    x = -1;
                }
                if (lines.isEmpty()) {
                    return null;
                }
                x = newLine.length();
                while (true) {
                    if ((x = newLine.lastIndexOf(", ", x - 1)) == -1) {
                        return null;
                    }
                    String linePart = newLine.substring(0, x + 1);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this._maxLineLength) continue;
                    lines.add(linePart);
                    if (linePart.contains("\textends")) {
                        newIndent = newIndent + "\t\t";
                    } else if (linePart.contains("\timplements")) {
                        newIndent = newIndent + "\t\t   ";
                    }
                    newLine = newIndent + newLine.substring(x + 2);
                    if (this.getLineLength(newLine) <= this._maxLineLength) {
                        lines.add(newLine);
                        break;
                    }
                    x = newLine.length();
                }
            }
        }
        String formattedClassLine = null;
        for (String line : lines) {
            if (formattedClassLine == null) {
                formattedClassLine = "\n" + line;
                continue;
            }
            formattedClassLine = formattedClassLine + "\n" + line;
        }
        return formattedClassLine;
    }

    protected int getIfClauseLineBreakPos(String line) {
        int y;
        int x = line.lastIndexOf(" || ", this._maxLineLength - 3);
        int z = Math.max(x, y = line.lastIndexOf(" && ", this._maxLineLength - 3));
        if (z != -1) {
            return z + 3;
        }
        if (!(line.endsWith(" ||") || line.endsWith(" &&") || line.endsWith(") {"))) {
            return -1;
        }
        x = line.indexOf("= ");
        if (x != -1) {
            return x + 1;
        }
        x = line.indexOf("> ");
        if (x != -1) {
            return x + 1;
        }
        x = line.indexOf("< ");
        if (x != -1) {
            return x + 1;
        }
        x = this._maxLineLength + 1;
        while ((x = line.lastIndexOf(", ", x - 1)) != -1) {
            String linePart = line.substring(0, x);
            if (this.getLevel(linePart) != 0) continue;
            return x + 1;
        }
        x = 0;
        while ((x = line.indexOf(40, x + 1)) != -1) {
            if (!Character.isLetterOrDigit(line.charAt(x - 1)) || line.charAt(x + 1) == ')') continue;
            return x + 1;
        }
        x = line.indexOf(46);
        if (x != -1) {
            return x + 1;
        }
        return -1;
    }

    protected int getIncorrectLineBreakPos(String line, String previousLine) {
        int x = line.length();
        while (true) {
            int z;
            int y;
            if ((x = Math.max(y = line.lastIndexOf(" || ", x - 1), z = line.lastIndexOf(" && ", x - 1))) == -1) {
                return x;
            }
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            if (Validator.isNotNull(previousLine) && (previousLine.endsWith(".") || this.getLevel(line.substring(0, x)) < 0)) {
                return x + 3;
            }
            if ((line.endsWith(" ||") || line.endsWith(" &&")) && this.getLevel(line.substring(x)) > 0) break;
        }
        return x + 3;
    }

    protected String getModuleClassContent(String fullClassName) throws Exception {
        String classContent = this._moduleFileContentsMap.get(fullClassName);
        if (classContent != null) {
            return classContent;
        }
        Map<String, String> moduleFileNamesMap = this.getModuleFileNamesMap();
        String moduleFileName = moduleFileNamesMap.get(fullClassName);
        if (moduleFileName == null) {
            this._moduleFileContentsMap.put(fullClassName, "");
            return "";
        }
        File file = new File(moduleFileName);
        classContent = FileUtil.read(file);
        if (classContent != null) {
            this._moduleFileContentsMap.put(fullClassName, classContent);
        }
        return classContent;
    }

    protected Map<String, String> getModuleFileNamesMap() throws Exception {
        if (this._moduleFileNamesMap != null) {
            return this._moduleFileNamesMap;
        }
        HashMap<String, String> moduleFileNamesMap = new HashMap<String, String>();
        List<Object> fileNames = new ArrayList();
        String moduleRootDirLocation = "modules/";
        for (int i = 0; i < 6; ++i) {
            File file = new File(this.sourceFormatterArgs.getBaseDirName() + moduleRootDirLocation);
            if (file.exists()) {
                fileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName() + moduleRootDirLocation, null, new String[0], this.getIncludes());
                break;
            }
            moduleRootDirLocation = "../" + moduleRootDirLocation;
        }
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            String className = StringUtil.replace(fileName, '/', '.');
            int pos = className.lastIndexOf(".com.liferay.");
            className = className.substring(pos + 1, fileName.length() - 5);
            moduleFileNamesMap.put(className, fileName);
        }
        this._moduleFileNamesMap = moduleFileNamesMap;
        return this._moduleFileNamesMap;
    }

    protected String getModuleServicePackagePath(String fileName) {
        int pos;
        String serviceDirLocation = fileName;
        while (true) {
            if ((pos = serviceDirLocation.lastIndexOf("/")) == -1) {
                return "";
            }
            File file = new File((serviceDirLocation = serviceDirLocation.substring(0, pos + 1)) + "service");
            if (file.exists()) break;
            file = new File(serviceDirLocation + "liferay");
            if (file.exists()) {
                return "";
            }
            serviceDirLocation = StringUtil.replaceLast(serviceDirLocation, "/", "");
        }
        serviceDirLocation = serviceDirLocation + "service";
        serviceDirLocation = StringUtil.replace(serviceDirLocation, "/", ".");
        pos = serviceDirLocation.lastIndexOf(".com.");
        return serviceDirLocation.substring(pos + 1);
    }

    protected String getModuleSuperClassContent(String content, String className, String packagePath) throws Exception {
        Pattern pattern = Pattern.compile(" class " + className + "\\s+extends\\s+([\\w.]+) ");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String superClassName = matcher.group(1);
        if (superClassName.contains(".")) {
            if (!superClassName.startsWith("com.liferay")) {
                return null;
            }
            return this.getModuleClassContent(superClassName);
        }
        String superClassPackagePath = packagePath;
        pattern = Pattern.compile("\nimport (.+?)\\." + superClassName + ";");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            superClassPackagePath = matcher.group(1);
        }
        if (!superClassPackagePath.startsWith("com.liferay")) {
            return null;
        }
        String superClassFullClassName = superClassPackagePath + "." + superClassName;
        return this.getModuleClassContent(superClassFullClassName);
    }

    protected String[] getPluginExcludes(String pluginDirectoryName) {
        return new String[]{pluginDirectoryName + "**/model/*Clp.java", pluginDirectoryName + "**/model/impl/*BaseImpl.java", pluginDirectoryName + "**/model/impl/*Model.java", pluginDirectoryName + "**/model/impl/*ModelImpl.java", pluginDirectoryName + "**/service/**/service/*Service.java", pluginDirectoryName + "**/service/**/service/*ServiceClp.java", pluginDirectoryName + "**/service/**/service/*ServiceFactory.java", pluginDirectoryName + "**/service/**/service/*ServiceUtil.java", pluginDirectoryName + "**/service/**/service/*ServiceWrapper.java", pluginDirectoryName + "**/service/**/service/ClpSerializer.java", pluginDirectoryName + "**/service/**/service/messaging/*ClpMessageListener.java", pluginDirectoryName + "**/service/**/service/persistence/*Finder.java", pluginDirectoryName + "**/service/**/service/persistence/*Util.java", pluginDirectoryName + "**/service/base/*ServiceBaseImpl.java", pluginDirectoryName + "**/service/base/*ServiceClpInvoker.java", pluginDirectoryName + "**/service/http/*JSONSerializer.java", pluginDirectoryName + "**/service/http/*ServiceHttp.java", pluginDirectoryName + "**/service/http/*ServiceJSON.java", pluginDirectoryName + "**/service/http/*ServiceSoap.java", pluginDirectoryName + "**/tools/templates/**"};
    }

    protected Collection<String> getPluginJavaFiles() throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = this.getPluginExcludes("");
        String[] includes = new String[]{"**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected String getPortalCustomSQLContent() throws Exception {
        if (this._portalCustomSQLContent != null) {
            return this._portalCustomSQLContent;
        }
        File portalCustomSQLFile = this.getFile("portal-impl/src/custom-sql/default.xml", 7);
        String portalCustomSQLContent = FileUtil.read(portalCustomSQLFile);
        Matcher matcher = this._customSQLFilePattern.matcher(portalCustomSQLContent);
        while (matcher.find()) {
            File customSQLFile = this.getFile("portal-impl/src/" + matcher.group(1), 7);
            if (customSQLFile == null) continue;
            portalCustomSQLContent = portalCustomSQLContent + FileUtil.read(customSQLFile);
        }
        this._portalCustomSQLContent = portalCustomSQLContent;
        return this._portalCustomSQLContent;
    }

    protected Collection<String> getPortalJavaFiles() throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**/*_IW.java", "**/counter/service/**", "**/jsp/*", "**/model/impl/*Model.java", "**/model/impl/*ModelImpl.java", "**/portal/service/**", "**/portal-client/**", "**/portal-web/test/**/*Test.java", "**/test/*-generated/**"};
        for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
            excludes = ArrayUtil.append(excludes, this.getPluginExcludes("**" + directoryName));
        }
        String[] includes = this.getIncludes();
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**/portal-client/**", "**/tools/ext_tmpl/**", "**/*_IW.java", "**/test/**/*PersistenceTest.java"};
        includes = new String[]{"**/com/liferay/portal/kernel/service/ServiceContext*.java", "**/model/BaseModel.java", "**/model/impl/BaseModelImpl.java", "**/portal-test/**/portal/service/**/*.java", "**/portal-test-integration/**/portal/service/**/*.java", "**/service/Base*.java", "**/service/PersistedModelLocalService*.java", "**/service/configuration/**/*.java", "**/service/http/*HttpTest.java", "**/service/http/*SoapTest.java", "**/service/http/TunnelUtil.java", "**/service/impl/*.java", "**/service/jms/*.java", "**/service/permission/*.java", "**/service/persistence/BasePersistence.java", "**/service/persistence/BatchSession*.java", "**/service/persistence/*FinderImpl.java", "**/service/persistence/*Query.java", "**/service/persistence/impl/*.java", "**/portal-impl/test/**/*.java", "**/util-bridges/**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected List<File> getSuppressionsFiles() throws Exception {
        File suppressionsFile;
        String fileName = "checkstyle-suppressions.xml";
        ArrayList<File> suppressionsFiles = new ArrayList<File>();
        if (portalSource && (suppressionsFile = this.getFile("portal-impl/src/" + fileName, 7)) != null) {
            suppressionsFiles.add(suppressionsFile);
        }
        int maxDirLevel = 3;
        String parentDirName = this.sourceFormatterArgs.getBaseDirName();
        if (portalSource) {
            maxDirLevel = 6;
            parentDirName = parentDirName + "../";
        }
        for (int i = 0; i < maxDirLevel; ++i) {
            File suppressionsFile2 = new File(parentDirName + fileName);
            if (suppressionsFile2.exists()) {
                suppressionsFiles.add(suppressionsFile2);
            }
            parentDirName = parentDirName + "../";
        }
        if (!portalSource) {
            return suppressionsFiles;
        }
        List<String> moduleSuppressionsFileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, new String[0], new String[]{"**/modules/**/" + fileName});
        for (String moduleSuppressionsFileName : moduleSuppressionsFileNames) {
            moduleSuppressionsFileName = StringUtil.replace(moduleSuppressionsFileName, '\\', '/');
            suppressionsFiles.add(new File(moduleSuppressionsFileName));
        }
        return suppressionsFiles;
    }

    protected String getTruncateLongLinesContent(String content, String line, String trimmedLine, int lineCount) {
        String firstLine;
        String secondLine;
        String firstLine2;
        int x;
        int i;
        String indent = "";
        for (i = 0; i < this.getLeadingTabCount(line); ++i) {
            indent = indent + "\t";
        }
        if ((line.endsWith("(") || line.endsWith(";")) && (x = line.indexOf(" = ")) != -1) {
            firstLine2 = line.substring(0, x + 2);
            if (firstLine2.contains("\"")) {
                return null;
            }
            secondLine = indent + "\t" + line.substring(x + 3);
            if (line.endsWith(";")) {
                return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
            }
            if (Validator.isNotNull(this.getLine(content, lineCount + 1))) {
                return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n" + "\t");
            }
        }
        if (line.endsWith(")") || line.endsWith(",") || line.endsWith("{") || line.endsWith(";")) {
            x = 0;
            while ((x = line.indexOf(", ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x) || !this.isValidJavaParameter(line.substring(0, x))) continue;
                firstLine2 = line.substring(0, x + 1);
                secondLine = indent + line.substring(x + 2);
                return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
            }
        }
        if ((line.endsWith("{") || line.endsWith(";")) && (trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && (x = line.indexOf(" throws ")) != -1) {
            firstLine2 = line.substring(0, x);
            secondLine = indent + "\t" + line.substring(x + 1);
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
        }
        if ((line.endsWith(")") || line.endsWith("{")) && (trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && (x = line.indexOf(40)) != -1 && line.charAt(x + 1) != ')') {
            String secondLineIndent = indent + "\t";
            if (line.endsWith(")")) {
                secondLineIndent = secondLineIndent + "\t";
            }
            firstLine = line.substring(0, x + 1);
            String secondLine2 = secondLineIndent + line.substring(x + 1);
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine + "\n" + secondLine2 + "\n");
        }
        if (line.endsWith(";")) {
            x = line.indexOf(40);
            if (x != -1) {
                char c = line.charAt(x - 1);
                if (c != ' ' && c != '\t' && line.charAt(x + 1) != ')') {
                    firstLine = line.substring(0, x + 1);
                    if (firstLine.contains("\"")) {
                        return null;
                    }
                    String secondLine3 = indent + "\t" + line.substring(x + 1);
                    return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine + "\n" + secondLine3 + "\n");
                }
            } else {
                x = line.lastIndexOf(" ");
                if (x != -1 && !ToolsUtil.isInsideQuotes(line, x)) {
                    firstLine2 = line.substring(0, x);
                    secondLine = indent + "\t" + line.substring(x + 1);
                    if (this.getLineLength(secondLine) <= this._maxLineLength) {
                        return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
                    }
                }
            }
        }
        if (line.contains("\tfor (") && line.endsWith(" {") && (x = line.indexOf(" : ")) != -1) {
            firstLine2 = line.substring(0, x + 2);
            secondLine = indent + "\t" + "\t" + line.substring(x + 3);
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n\n");
        }
        i = this.getIfClauseLineBreakPos(line);
        if (i == -1) {
            return null;
        }
        firstLine2 = line.substring(0, i);
        secondLine = indent + line.substring(i);
        if (secondLine.endsWith(") {")) {
            return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n\n");
        }
        return StringUtil.replace(content, "\n" + line + "\n", "\n" + firstLine2 + "\n" + secondLine + "\n");
    }

    protected boolean hasGeneratedTag(String content) {
        return (content.contains("* @generated") || content.contains("$ANTLR")) && !content.contains("hasGeneratedTag");
    }

    protected boolean isAnnotationParameter(String content, String line) {
        int x = -1;
        while ((x = line.indexOf(", ", x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            return false;
        }
        Matcher matcher = _annotationPattern.matcher(content);
        while (matcher.find()) {
            String annotationParameters = matcher.group(3);
            if (!annotationParameters.contains(line)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidJavaParameter(String javaParameter) {
        if (javaParameter.contains(" implements ") || javaParameter.contains(" throws ")) {
            return false;
        }
        return this.getLevel(javaParameter, "(", ")") == 0 && this.getLevel(javaParameter, "<", ">") == 0 && this.getLevel(javaParameter, "{", "}") == 0;
    }

    @Override
    protected void postFormat() throws Exception {
        this.checkBndInheritAnnotationOption();
        this.processCheckStyle();
    }

    @Override
    protected void preFormat() {
        this._maxLineLength = this.sourceFormatterArgs.getMaxLineLength();
        this._addMissingDeprecationReleaseVersion = GetterUtil.getBoolean(this.getProperty("add.missing.deprecation.release.version"));
        this._allowUseServiceUtilInServiceImpl = GetterUtil.getBoolean(this.getProperty("allow.use.service.util.in.service.impl"));
    }

    protected void processCheckStyle() throws Exception {
        if (this._ungeneratedFiles.isEmpty()) {
            return;
        }
        Set<SourceFormatterMessage> sourceFormatterMessages = CheckStyleUtil.process(this._ungeneratedFiles, this.getSuppressionsFiles(), this.sourceFormatterArgs.getBaseDirName());
        for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
            this.processMessage(sourceFormatterMessage.getFileName(), sourceFormatterMessage.getMessage(), sourceFormatterMessage.getLineCount());
            this.printError(sourceFormatterMessage.getFileName(), sourceFormatterMessage.toString());
        }
    }

    protected void setBNDInheritRequiredValue(String fileName, boolean bndInheritRequired) throws Exception {
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return;
        }
        if (bndInheritRequired) {
            bndSettings.setInheritRequired(bndInheritRequired);
        }
        this.putBNDSettings(bndSettings);
    }

    protected String sortExceptions(String content) {
        Matcher matcher = this._throwsExceptionsPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String exceptions = matcher.group(1);
            exceptions = StringUtil.replace(exceptions, new String[]{"\t", "\n"}, new String[]{" ", " "});
            String previousException = "";
            for (String exception : StringUtil.split(exceptions, ", ")) {
                exception = StringUtil.trim(exception);
                if (Validator.isNotNull(previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                    String replacement = match.replaceAll("(\\W)" + exception + "(\\W)", "$1" + previousException + "$2");
                    replacement = replacement.replaceFirst("(\\W)" + previousException + "(\\W)", "$1" + exception + "$2");
                    return this.sortExceptions(StringUtil.replace(content, match, replacement));
                }
                previousException = exception;
            }
        }
        return content;
    }
}

