/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/build.gradle"};
    private final Pattern _defaultVersionPattern = Pattern.compile("name: \"(.*?)\", version: \"default\"");
    private final Pattern _dependenciesPattern = Pattern.compile("^dependencies \\{(.+?\n)\\}", 40);

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    protected void checkDefaultVersion(String fileName, String content) {
        Matcher matcher = this._defaultVersionPattern.matcher(content);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (name.equals("com.liferay.portal.impl") || name.equals("com.liferay.portal.kernel") || name.equals("com.liferay.util.bridges") || name.equals("com.liferay.util.taglib")) continue;
            this.processMessage(fileName, "Do not use 'default' version for '" + name + "'", this.getLineCount(content, matcher.start()));
        }
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        content = this.formatDependencies(absolutePath, content);
        this.checkDefaultVersion(fileName, content);
        return this.trimContent(content, false);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    protected String formatDependencies(String absolutePath, String content) {
        Matcher matcher = this._dependenciesPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String dependencies = matcher.group(1);
        TreeSet<String> uniqueDependencies = new TreeSet<String>();
        for (String dependency : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(dependency = dependency.trim())) continue;
            uniqueDependencies.add(dependency);
        }
        StringBundler sb = new StringBundler();
        String previousConfiguration = null;
        for (String dependency : uniqueDependencies) {
            int pos;
            String configuration = dependency.substring(0, pos = dependency.indexOf(" "));
            if (configuration.equals("compile") && (absolutePath.contains("/modules/apps/") || absolutePath.contains("/modules/private/apps/"))) {
                dependency = StringUtil.replaceFirst(dependency, "compile", "provided");
            }
            if (previousConfiguration == null || !previousConfiguration.equals(configuration)) {
                previousConfiguration = configuration;
                sb.append("\n");
            }
            sb.append("\t");
            sb.append(dependency);
            sb.append("\n");
        }
        return StringUtil.replace(content, dependencies, sb.toString());
    }
}

