/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SourceFormatterHelper {
    private final Properties _properties = new Properties();
    private String _propertiesContent = "";
    private File _propertiesFile;
    private final boolean _useProperties;

    public SourceFormatterHelper(boolean useProperties) {
        this._useProperties = useProperties;
    }

    public void close() throws IOException {
        if (!this._useProperties) {
            return;
        }
        String newPropertiesContent = PropertiesUtil.toString(this._properties);
        if (!this._propertiesContent.equals(newPropertiesContent)) {
            FileUtil.write(this._propertiesFile, newPropertiesContent);
        }
    }

    public void init() throws IOException {
        if (!this._useProperties) {
            return;
        }
        File basedirFile = new File("./");
        String basedirAbsolutePath = StringUtil.replace(basedirFile.getAbsolutePath(), new String[]{".", ":", "/", "\\"}, new String[]{"_", "_", "_", "_"});
        String propertiesFileName = System.getProperty("java.io.tmpdir") + "/SourceFormatter." + basedirAbsolutePath;
        this._propertiesFile = new File(propertiesFileName);
        if (this._propertiesFile.exists()) {
            this._propertiesContent = FileUtil.read(this._propertiesFile);
            PropertiesUtil.load(this._properties, this._propertiesContent);
        }
    }

    public void printError(String fileName, File file) {
        this.printError(fileName, file.toString());
    }

    public void printError(String fileName, String message) {
        if (this._useProperties) {
            String encodedFileName = StringUtil.replace(fileName, "\\", "/");
            this._properties.remove(encodedFileName);
        }
        System.out.println(message);
    }

    public List<String> scanForFiles(String baseDir, String[] excludes, String[] includes) throws Exception {
        final ArrayList<String> fileNames = new ArrayList<String>();
        final ArrayList<PathMatcher> excludeDirPathMatchers = new ArrayList<PathMatcher>();
        final ArrayList<PathMatcher> excludeFilePathMatchers = new ArrayList<PathMatcher>();
        final ArrayList<PathMatcher> includeFilePathMatchers = new ArrayList<PathMatcher>();
        FileSystem fileSystem = FileSystems.getDefault();
        for (String exclude : excludes) {
            if (exclude.endsWith("/**")) {
                exclude = exclude.substring(0, exclude.length() - 3);
                excludeDirPathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
                continue;
            }
            excludeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
        }
        for (String include : includes) {
            includeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + include));
        }
        Files.walkFileTree(Paths.get(baseDir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                if (Files.exists(dirPath.resolve("source_formatter.ignore"), new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                for (PathMatcher pathMatcher : excludeDirPathMatchers) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                for (PathMatcher pathMatcher : excludeFilePathMatchers) {
                    if (!pathMatcher.matches(filePath)) continue;
                    return FileVisitResult.CONTINUE;
                }
                for (PathMatcher pathMatcher : includeFilePathMatchers) {
                    if (!pathMatcher.matches(filePath)) continue;
                    String fileName = filePath.toString();
                    fileNames.add(fileName);
                    if (!SourceFormatterHelper.this._useProperties) {
                        return FileVisitResult.CONTINUE;
                    }
                    File file = new File(fileName);
                    String encodedFileName = StringUtil.replace(fileName, "\\", "/");
                    long timestamp = GetterUtil.getLong(SourceFormatterHelper.this._properties.getProperty(encodedFileName));
                    if (timestamp < file.lastModified()) {
                        SourceFormatterHelper.this._properties.setProperty(encodedFileName, String.valueOf(file.lastModified()));
                    }
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileNames;
    }
}

