/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public final class FullIdent {
    private final List<String> elements = new ArrayList<String>();
    private DetailAST detailAst;

    private FullIdent() {
    }

    public static FullIdent createFullIdentBelow(DetailAST ast) {
        return FullIdent.createFullIdent(ast.getFirstChild());
    }

    public static FullIdent createFullIdent(DetailAST ast) {
        FullIdent ident = new FullIdent();
        FullIdent.extractFullIdent(ident, ast);
        return ident;
    }

    private static void extractFullIdent(FullIdent full, DetailAST ast) {
        if (ast != null) {
            if (ast.getType() == 59) {
                FullIdent.extractFullIdent(full, ast.getFirstChild());
                full.append(".");
                FullIdent.extractFullIdent(full, ast.getFirstChild().getNextSibling());
            } else if (ast.getType() == 17) {
                FullIdent.extractFullIdent(full, ast.getFirstChild());
                full.append("[]");
            } else {
                full.append(ast);
            }
        }
    }

    public String getText() {
        return String.join((CharSequence)"", this.elements);
    }

    public DetailAST getDetailAst() {
        return this.detailAst;
    }

    public int getLineNo() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNo() {
        return this.detailAst.getColumnNo();
    }

    public String toString() {
        return String.join((CharSequence)"", this.elements) + "[" + this.detailAst.getLineNo() + "x" + this.detailAst.getColumnNo() + "]";
    }

    private void append(String text) {
        this.elements.add(text);
    }

    private void append(DetailAST ast) {
        this.elements.add(ast.getText());
        if (this.detailAst == null) {
            this.detailAst = ast;
        }
    }
}

