# Naming Conventions Checks

Check | File Extensions | Description
----- | --------------- | -----------
BrandNameCheck | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks the correct brand name. |
[CamelCaseNameCheck](check/camel_case_name_check.md#camelcasenamecheck) | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks variable names for correct use of `CamelCase`. |
CapsNameCheck | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks the correct caps name. |
ConstantNameCheck | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that variable names of constants follow correct naming rules. |
ExceptionVariableNameCheck | .java | Validates variable names that have type `*Exception`. |
JSONNamingCheck | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks if variable names follow naming conventions. |
[JSPFileNameCheck](check/jsp_file_name_check.md#jspfilenamecheck) | .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks if the file name of `.jsp` or `.jspf` follows the naming conventions. |
[JSPFunctionNameCheck](check/jsp_function_name_check.md#jspfunctionnamecheck) | .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Check if the names of functions in `.jsp` files follow naming conventions. |
[JSPTaglibVariableCheck](check/jsp_taglib_variable_check.md#jsptaglibvariablecheck) | .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks if variable names follow naming conventions. |
JavaClassNameCheck | .java | Checks if class names follow naming conventions. |
[JavaComponentActivateCheck](check/java_component_activate_check.md#javacomponentactivatecheck) | .java | Checks if methods with annotation `@Activate` or `@Deactivate` follow naming conventions. |
JavaConstantsFileCheck | .java | Checks if constants names follow naming conventions. |
JavaExceptionCheck | .java | Checks that variable names of exceptions in `catch` statements follow naming conventions. |
[JavaHelperUtilCheck](check/java_helper_util_check.md#javahelperutilcheck) | .java | Finds incorrect use of `*Helper` or `*Util` classes. |
[JavaTestMethodAnnotationsCheck](check/java_test_method_annotations_check.md#javatestmethodannotationscheck) | .java | Checks if methods with test annotations follow the naming conventions. |
[LocalFinalVariableNameCheck](https://checkstyle.sourceforge.io/checks/naming/localfinalvariablename.html) | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that local final variable names conform to a specified pattern. |
[LocalVariableNameCheck](https://checkstyle.sourceforge.io/checks/naming/localvariablename.html) | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that local, non-final variable names conform to a specified pattern. |
[MVCCommandNameCheck](check/mvc_command_name_check.md#mvccommandnamecheck) | .java | Checks for consistent naming for values of `mvc.command.name`. |
[MemberNameCheck](https://checkstyle.sourceforge.io/checks/naming/membername.html) | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that instance variable names conform to a specified pattern. |
[MethodNameCheck](https://checkstyle.sourceforge.io/checks/naming/methodname.html) | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that method names conform to a specified pattern. |
MethodNamingCheck | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that method names follow naming conventions. |
[PackageNameCheck](https://checkstyle.sourceforge.io/checks/naming/packagename.html) | .java | Checks that package names conform to a specified pattern. |
[ParameterNameCheck](https://checkstyle.sourceforge.io/checks/naming/parametername.html) | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that method parameter names conform to a specified pattern. |
SessionKeysCheck | .java | Checks that messages send to `SessionsErrors` or `SessionMessages` follow naming conventions. |
[StaticVariableNameCheck](https://checkstyle.sourceforge.io/checks/naming/staticvariablename.html) | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that static, non-final variable names conform to a specified pattern. |
StringBundlerNamingCheck | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks for consistent naming on variables of type 'StringBundler'. |
TestClassCheck | .java | Checks that names of test classes follow naming conventions. |
ThreadLocalVariableNameCheck | .java | Checks for consistent naming on variables of type '*ThreadLocal'. |
ThreadNameCheck | .java | Checks that names of threads follow naming conventions. |
[TypeNameCheck](https://checkstyle.sourceforge.io/checks/naming/typename.html) | .java | Checks that type names conform to a specified pattern. |
VariableNameCheck | .java, .jsp, .jspf, .jspx, .tag, .tpl, or .vm | Checks that variable names follow naming conventions. |