/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.impl.DefaultJavaExecutable;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.beans.Introspector;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaMethod
extends DefaultJavaExecutable
implements JavaMethod {
    private boolean defaultMethod;
    private JavaClass returns;
    private List<JavaTypeVariable<JavaMethod>> typeParameters = Collections.emptyList();

    public DefaultJavaMethod() {
    }

    public DefaultJavaMethod(String name) {
        this.setName(name);
    }

    public DefaultJavaMethod(JavaClass returns, String name) {
        this.returns = returns;
        this.setName(name);
    }

    @Override
    public boolean isDefault() {
        return this.defaultMethod;
    }

    public void setDefault(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    @Override
    public JavaClass getReturns() {
        return this.returns;
    }

    public void setTypeParameters(List<JavaTypeVariable<JavaMethod>> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public List<JavaTypeVariable<JavaMethod>> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeMethod(this).toString();
    }

    private String getSignature(boolean withModifiers, boolean isDeclaration) {
        StringBuilder result = new StringBuilder();
        if (withModifiers) {
            for (String modifier : this.getModifiers()) {
                if (!modifier.startsWith("p")) continue;
                result.append(modifier).append(' ');
            }
            for (String modifier : this.getModifiers()) {
                if (modifier.startsWith("p")) continue;
                result.append(modifier).append(' ');
            }
        }
        if (isDeclaration) {
            result.append(this.returns.getGenericCanonicalName());
            result.append(' ');
        }
        result.append(this.getName());
        result.append('(');
        ListIterator<JavaParameter> iter = this.getParameters().listIterator();
        while (iter.hasNext()) {
            JavaParameter parameter = iter.next();
            if (isDeclaration) {
                result.append(parameter.getType().getGenericCanonicalName());
                if (parameter.isVarArgs()) {
                    result.append("...");
                }
                result.append(' ');
            }
            result.append(parameter.getName());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        if (isDeclaration && !this.getExceptions().isEmpty()) {
            result.append(" throws ");
            Iterator<JavaClass> excIter = this.getExceptions().iterator();
            while (excIter.hasNext()) {
                result.append(excIter.next().getGenericCanonicalName());
                if (!excIter.hasNext()) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }

    @Override
    public String getDeclarationSignature(boolean withModifiers) {
        return this.getSignature(withModifiers, true);
    }

    @Override
    public String getCallSignature() {
        return this.getSignature(false, false);
    }

    public void setReturns(JavaClass returns) {
        this.returns = returns;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaMethod)) {
            return false;
        }
        JavaMethod other = (JavaMethod)obj;
        if (other.getDeclaringClass() != null ? !other.getDeclaringClass().equals(this.getDeclaringClass()) : this.getDeclaringClass() != null) {
            return false;
        }
        if (other.getName() != null ? !other.getName().equals(this.getName()) : this.getName() != null) {
            return false;
        }
        if (other.getReturnType() != null ? !other.getReturnType().equals(this.getReturns()) : this.getReturns() != null) {
            return false;
        }
        List<JavaParameter> thisParams = this.getParameters();
        List<JavaParameter> otherParams = other.getParameters();
        if (otherParams.size() != thisParams.size()) {
            return false;
        }
        for (int i = 0; i < thisParams.size(); ++i) {
            if (otherParams.get(i).equals(thisParams.get(i))) continue;
            return false;
        }
        return this.isVarArgs() == other.isVarArgs();
    }

    public int hashCode() {
        int hashCode = 7;
        if (this.getDeclaringClass() != null) {
            hashCode *= 31 + this.getDeclaringClass().hashCode();
        }
        if (this.getName() != null) {
            hashCode *= 37 + this.getName().hashCode();
        }
        hashCode *= 41 + this.getParameters().hashCode();
        if (this.returns != null) {
            hashCode *= 43 + this.returns.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean isPropertyAccessor() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().size() != 0) {
            return false;
        }
        if (this.getName().startsWith("is")) {
            return this.getName().length() > 2 && Character.isUpperCase(this.getName().charAt(2));
        }
        if (this.getName().startsWith("get")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    @Override
    public boolean isPropertyMutator() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().size() != 1) {
            return false;
        }
        if (this.getName().startsWith("set")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    @Override
    public JavaType getPropertyType() {
        if (this.isPropertyAccessor()) {
            return this.getReturns();
        }
        if (this.isPropertyMutator()) {
            return this.getParameters().get(0).getType();
        }
        return null;
    }

    @Override
    public String getPropertyName() {
        int start = -1;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            start = 3;
        } else if (this.getName().startsWith("is")) {
            start = 2;
        } else {
            return null;
        }
        return Introspector.decapitalize(this.getName().substring(start));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isSynchronized()) {
            result.append("synchronized ");
        }
        if (this.isNative()) {
            result.append("native ");
        }
        result.append(this.getReturns().getFullyQualifiedName()).append(' ');
        if (this.getDeclaringClass() != null) {
            result.append(this.getDeclaringClass().getBinaryName());
            result.append(".");
        }
        result.append(this.getName());
        result.append("(");
        for (int paramIndex = 0; paramIndex < this.getParameters().size(); ++paramIndex) {
            JavaType originalType;
            JavaTypeVariable typeVariable;
            if (paramIndex > 0) {
                result.append(",");
            }
            result.append((typeVariable = DefaultJavaType.resolve(originalType = this.getParameters().get(paramIndex).getType(), this.getTypeParameters())) == null ? originalType.getFullyQualifiedName() : typeVariable.getBounds().get(0).getFullyQualifiedName());
        }
        result.append(")");
        if (this.getExceptions().size() > 0) {
            result.append(" throws ");
            Iterator<JavaClass> excIter = this.getExceptions().iterator();
            while (excIter.hasNext()) {
                result.append(excIter.next().getFullyQualifiedName());
                if (!excIter.hasNext()) continue;
                result.append(",");
            }
        }
        return result.toString();
    }

    @Override
    public JavaType getReturnType() {
        return this.getReturnType(false);
    }

    @Override
    public JavaType getReturnType(boolean resolve) {
        return this.returns;
    }

    @Override
    public boolean signatureMatches(String name, List<JavaType> parameterTypes) {
        return this.signatureMatches(name, parameterTypes, false);
    }

    @Override
    public boolean signatureMatches(String name, List<JavaType> parameterTypes, boolean varArg) {
        if (!name.equals(this.getName())) {
            return false;
        }
        return this.signatureMatches(parameterTypes, varArg);
    }
}

