/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.ParseException;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RESTDTOSetCallCheck
extends BaseCheck {
    private static final String _MSG_USE_SET_METHOD_INSTEAD = "set.method.use.instead";
    private static final Log _log = LogFactoryUtil.getLog(RESTDTOSetCallCheck.class);
    private volatile Map<String, String> _bundleSymbolicNamesMap;
    private volatile String _rootDirName;

    public int[] getDefaultTokens() {
        return new int[]{14, 11};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (!absolutePath.contains("/modules/") && !absolutePath.contains("/workspaces/") || absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return;
        }
        if (detailAST.getType() == 14) {
            this._checkClassDeclaration(detailAST, absolutePath);
        } else if (detailAST.getType() == 11) {
            this._checkInstanceInitializer(detailAST, absolutePath);
        }
    }

    private void _checkClassDeclaration(DetailAST detailAST, String absolutePath) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(objBlockDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodName;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST == null || !(methodName = this.getMethodName(methodCallDetailAST)).startsWith("set")) continue;
            String variableName = this.getVariableName(methodCallDetailAST);
            if (variableName == null) {
                return;
            }
            String fullyQualifiedTypeName = this.getVariableTypeName(methodCallDetailAST, variableName, false, false, true);
            if (fullyQualifiedTypeName == null || !fullyQualifiedTypeName.startsWith("com.liferay.") || !fullyQualifiedTypeName.contains(".dto.v")) continue;
            this._checkSetCall(absolutePath, methodCallDetailAST, methodName, fullyQualifiedTypeName);
        }
    }

    private void _checkInstanceInitializer(DetailAST detailAST, String absolutePath) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST literalNewDetailAST = parentDetailAST;
        String fullyQualifiedTypeName = null;
        DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            fullyQualifiedTypeName = this.getFullyQualifiedTypeName(firstChildDetailAST.getText(), detailAST, false);
        } else if (firstChildDetailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            fullyQualifiedTypeName = fullIdent.getText();
        }
        if (fullyQualifiedTypeName == null || !fullyQualifiedTypeName.startsWith("com.liferay.") || !fullyQualifiedTypeName.contains(".dto.v")) {
            return;
        }
        List<DetailAST> childDetailASTList = this.getAllChildTokens(detailAST, true, 80, 27);
        for (DetailAST childDetailAST : childDetailASTList) {
            String methodName;
            parentDetailAST = this.getParentWithTokenType(childDetailAST, 11);
            if (parentDetailAST == null || (parentDetailAST = parentDetailAST.getParent()) == null || parentDetailAST.getType() != 6 || (parentDetailAST = parentDetailAST.getParent()) == null || !this.equals(parentDetailAST, literalNewDetailAST)) continue;
            if (childDetailAST.getType() == 80) {
                firstChildDetailAST = childDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() != 58) continue;
                String variableName = firstChildDetailAST.getText();
                DetailAST variableDefinitionDetailAST = this.getVariableDefinitionDetailAST(childDetailAST, variableName, false);
                if (variableDefinitionDetailAST != null) {
                    return;
                }
                String methodName2 = "set" + StringUtil.upperCaseFirstLetter(variableName);
                this._checkSetCall(absolutePath, childDetailAST, methodName2, fullyQualifiedTypeName);
                continue;
            }
            DetailAST dotDetailAST = childDetailAST.findFirstToken(59);
            if (dotDetailAST != null || !(methodName = this.getMethodName(childDetailAST)).startsWith("set")) continue;
            this._checkSetCall(absolutePath, childDetailAST, methodName, fullyQualifiedTypeName);
        }
    }

    private void _checkSetCall(String absolutePath, DetailAST detailAST, String methodName, String fullyQualifiedTypeName) {
        DetailAST elistDetailAST;
        DetailAST childDetailAST;
        File javaFile = JavaSourceUtil.getJavaFile(fullyQualifiedTypeName, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath));
        if (javaFile == null) {
            return;
        }
        JavaClass javaClass = null;
        try {
            javaClass = this._getJavaClass(absolutePath, fullyQualifiedTypeName);
        }
        catch (ParseException | IOException exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 7 || !this._hasReplaceableMethodSignature(methodName, javaClass)) {
            return;
        }
        if (detailAST.getType() == 27 && ((childDetailAST = (elistDetailAST = detailAST.findFirstToken(34)).getFirstChild()) == null || childDetailAST.getType() == 181 || childDetailAST.findFirstToken(180) != null)) {
            return;
        }
        this.log(detailAST, _MSG_USE_SET_METHOD_INSTEAD, new Object[]{methodName});
    }

    private synchronized Map<String, String> _getBundleSymbolicNamesMap(String absolutePath) {
        if (this._bundleSymbolicNamesMap == null) {
            this._bundleSymbolicNamesMap = BNDSourceUtil.getBundleSymbolicNamesMap(this._getRootDirName(absolutePath));
        }
        return this._bundleSymbolicNamesMap;
    }

    private JavaClass _getJavaClass(String absolutePath, String fullyQualifiedTypeName) throws IOException, ParseException {
        File javaFile = JavaSourceUtil.getJavaFile(fullyQualifiedTypeName, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath));
        if (javaFile == null) {
            return null;
        }
        return JavaClassParser.parseJavaClass(SourceUtil.getAbsolutePath(javaFile), FileUtil.read(javaFile));
    }

    private synchronized String _getRootDirName(String absolutePath) {
        if (this._rootDirName != null) {
            return this._rootDirName;
        }
        this._rootDirName = SourceUtil.getRootDirName(absolutePath);
        return this._rootDirName;
    }

    private boolean _hasReplaceableMethodSignature(String methodName, JavaClass javaClass) {
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            JavaParameter javaParameter;
            String parameterType;
            JavaSignature javaSignature;
            List<JavaParameter> javaParameters;
            JavaMethod javaMethod;
            if (!javaTerm.isJavaMethod() || javaTerm.isPrivate() || !StringUtil.equals(methodName, (javaMethod = (JavaMethod)javaTerm).getName()) || (javaParameters = (javaSignature = javaMethod.getSignature()).getParameters()).size() != 1 || !(parameterType = (javaParameter = javaParameters.get(0)).getParameterType()).startsWith("UnsafeSupplier")) continue;
            return true;
        }
        return false;
    }
}

