/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;

public class YMLStylingCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if ((content = content.trim()).endsWith("\n---")) {
            content = content.substring(0, content.length() - 4);
        }
        if (content.startsWith("---\n")) {
            content = content.substring(4);
        }
        content = content.replaceAll("(\\A|\n)( *)(description:) (?!\\|-)(.+)(\\Z|\n)", "$1$2$3\n    $2$4$5");
        content = content.replaceAll("(\\A|\n) *description:\n +\"\"", "");
        content = content.replaceAll("(\\A|\n)( *#)@? ?(review)(\\Z|\n)", "$1$2 @$3$4");
        return this._formatQuotes(content);
    }

    private String _fixBooleanValue(String s) {
        if (this._isBooleanFalse(s)) {
            return "false";
        }
        if (this._isBooleanTrue(s)) {
            return "true";
        }
        return s;
    }

    private String _fixQuotes(String s) {
        String unquotedValue;
        if (Validator.isNull(s) || s.length() == 1) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            if (s.length() == 2) {
                return "\"\"";
            }
            unquotedValue = s.substring(1, s.length() - 1);
            unquotedValue = StringUtil.replace(unquotedValue, "''", "'");
            unquotedValue = StringUtil.replace(unquotedValue, "\"", "\\\"");
            s = '\"' + unquotedValue + '\"';
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            if (s.length() == 2) {
                return s;
            }
            unquotedValue = s.substring(1, s.length() - 1);
            if (unquotedValue.contains("\\") || unquotedValue.matches("\\d+(\\.\\d*)?") || unquotedValue.startsWith("#") || unquotedValue.startsWith("&") || unquotedValue.startsWith("*") || unquotedValue.startsWith("[") || unquotedValue.startsWith("{") || this._isBooleanValue(unquotedValue)) {
                return s;
            }
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private String _formatQuotes(String content) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String newKey;
                ++lineNumber;
                String trimmedLine = StringUtil.trimLeading(line);
                int x = trimmedLine.indexOf(": ");
                if (x == -1) continue;
                String key = trimmedLine.substring(0, x);
                if (!key.equals(newKey = this._fixQuotes(key))) {
                    String string = StringUtil.replaceFirst(content, key, newKey, this.getLineStartPos(content, lineNumber));
                    return string;
                }
                String value = trimmedLine.substring(x + 2);
                String newValue = this._fixQuotes(value);
                if (value.equals(newValue = this._fixBooleanValue(newValue))) continue;
                String string = StringUtil.replaceFirst(content, ": " + value, ": " + newValue, this.getLineStartPos(content, lineNumber));
                return string;
            }
        }
        return content;
    }

    private boolean _isBooleanFalse(String s) {
        return StringUtil.equalsIgnoreCase(s, "false") || StringUtil.equalsIgnoreCase(s, "no") || StringUtil.equalsIgnoreCase(s, "off");
    }

    private boolean _isBooleanTrue(String s) {
        return StringUtil.equalsIgnoreCase(s, "on") || StringUtil.equalsIgnoreCase(s, "true") || StringUtil.equalsIgnoreCase(s, "yes");
    }

    private boolean _isBooleanValue(String s) {
        return this._isBooleanFalse(s) || this._isBooleanTrue(s);
    }
}

