/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.OrderByComparator;

public class UserEmailAddressComparator
extends OrderByComparator<User> {
    public static final String ORDER_BY_ASC = "emailAddress ASC";
    public static final String ORDER_BY_DESC = "emailAddress DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"emailAddress"};
    private static final UserEmailAddressComparator _INSTANCE_ASCENDING = new UserEmailAddressComparator(true);
    private static final UserEmailAddressComparator _INSTANCE_DESCENDING = new UserEmailAddressComparator(false);
    private final boolean _ascending;

    public static UserEmailAddressComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    @Override
    public int compare(User user1, User user2) {
        String emailAddress1 = user1.getEmailAddress();
        String emailAddress2 = user2.getEmailAddress();
        int value = emailAddress1.compareTo(emailAddress2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    private UserEmailAddressComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

