/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.Objects;

public class ArrayUtilCheck
extends BaseCheck {
    private static final String _MSG_USE_ARRAY_UTIL_IS_EMPTY = "array.util.is.empty.use";

    public int[] getDefaultTokens() {
        return new int[]{116};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this.isExcludedPath("run.outside.portal.excludes")) {
            return;
        }
        this._checkArrayLengthIsZero(detailAST);
    }

    private void _checkArrayEqualsNullAssertion(DetailAST detailAST, String variableName) {
        DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 76) {
            return;
        }
        DetailAST identDetailAST = detailAST.getFirstChild();
        if (identDetailAST == null || identDetailAST.getType() != 58 || !Objects.equals(identDetailAST.getText(), variableName)) {
            return;
        }
        DetailAST nextSiblingDetailAST = identDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() != 135) {
            return;
        }
        this.log(detailAST.getParent(), _MSG_USE_ARRAY_UTIL_IS_EMPTY, new Object[]{variableName});
    }

    private void _checkArrayLengthIsZero(DetailAST detailAST) {
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 59) {
            return;
        }
        List<String> names = this.getNames(firstChildDetailAST, false);
        if (names.size() != 2 || !StringUtil.equals(names.get(1), "length")) {
            return;
        }
        DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 137 || !StringUtil.equals(nextSiblingDetailAST.getText(), "0")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 110) {
            return;
        }
        DetailAST equalDetailAST = parentDetailAST.findFirstToken(116);
        if (!this.equals(equalDetailAST, detailAST)) {
            this._checkArrayEqualsNullAssertion(equalDetailAST, names.get(0));
        }
    }
}

