/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseBreakingChangesCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MarkdownBreakingChangesAmendmentsFileCheck
extends BaseBreakingChangesCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("readme/BREAKING_CHANGES_AMENDMENTS.md")) {
            return content;
        }
        this._checkBreakingChangesAmendments(fileName, absolutePath, this._splitBreakingChangesAmendments(content));
        return content;
    }

    private void _checkBreakingChangesAmendments(String fileName, String absolutePath, List<String> breakingChangesAmendments) throws IOException {
        for (String breakingChangesAmendment : breakingChangesAmendments) {
            int y;
            int x = (breakingChangesAmendment = StringUtil.trimLeading(breakingChangesAmendment)).indexOf("\n");
            if (x == -1) {
                return;
            }
            String firstLine = breakingChangesAmendment.substring(0, x);
            if (!firstLine.matches("# [0-9a-f]{40}")) {
                this.addMessage(fileName, "The first line in each amendment should be # SHA");
                continue;
            }
            x = breakingChangesAmendment.indexOf("```");
            if (x == -1 || (y = breakingChangesAmendment.lastIndexOf("```")) == -1) continue;
            String breakingChanges = breakingChangesAmendment.substring(x + 3, y);
            String message = "Incorrect breaking change content in " + firstLine + ": ";
            this.checkBreakingChanges(fileName, absolutePath, breakingChanges.split("\n----"), message, false);
        }
    }

    private List<String> _splitBreakingChangesAmendments(String content) throws IOException {
        StringBundler sb = new StringBundler();
        ArrayList<String> breakingChangesAmendments = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            boolean codeBlock = false;
            String line = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (Validator.isBlank(line)) {
                    sb.append("\n");
                    continue;
                }
                if (line.equals("----") && !codeBlock && sb.index() > 0) {
                    sb.append(line);
                    sb.append("\n");
                    breakingChangesAmendments.add(sb.toString());
                    sb.setIndex(0);
                    continue;
                }
                sb.append(line);
                sb.append("\n");
                if (!line.startsWith("```") || StringUtil.count(line, "```") != 1) continue;
                codeBlock = !codeBlock;
            }
            if (sb.index() > 0) {
                breakingChangesAmendments.add(sb.toString());
            }
        }
        return breakingChangesAmendments;
    }
}

