/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseBreakingChangesCheck;
import com.liferay.source.formatter.processor.SourceProcessor;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class BNDBreakingChangeCommitMessageCheck
extends BaseBreakingChangesCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith("/bnd.bnd") || absolutePath.contains("-test/")) {
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        String gitWorkingBranchName = sourceFormatterArgs.getGitWorkingBranchName();
        if (gitWorkingBranchName.matches("release-\\d{4}\\.q[1-4]")) {
            return content;
        }
        if (this._hasMajorVersionBump(absolutePath, sourceFormatterArgs)) {
            this.checkCommitMessages(fileName, absolutePath, sourceFormatterArgs, "the major version bumps up");
        }
        return content;
    }

    private boolean _hasMajorVersionBump(String absolutePath, SourceFormatterArgs sourceFormatterArgs) throws Exception {
        for (String currentBranchFileName : this.getCurrentBranchFileNames(sourceFormatterArgs)) {
            if (!absolutePath.endsWith(currentBranchFileName)) continue;
            DefaultArtifactVersion newArtifactVersion = null;
            DefaultArtifactVersion oldArtifactVersion = null;
            for (String line : StringUtil.splitLines(GitUtil.getCurrentBranchFileDiff(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName(), absolutePath))) {
                if (!line.contains("Bundle-Version:")) continue;
                int pos = line.indexOf(":");
                String version = StringUtil.trim(line.substring(pos + 1));
                if (line.startsWith("+")) {
                    newArtifactVersion = new DefaultArtifactVersion(version);
                    continue;
                }
                if (!line.startsWith("-")) continue;
                oldArtifactVersion = new DefaultArtifactVersion(version);
            }
            if (newArtifactVersion == null || oldArtifactVersion == null || newArtifactVersion.getMajorVersion() <= oldArtifactVersion.getMajorVersion()) continue;
            return true;
        }
        return false;
    }
}

