/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TSSpecFileStylingCheck
extends BaseFileCheck {
    private static final Pattern _descriptionPattern = Pattern.compile("\n\t*test\\(\\s*((['\"]).+\\2),\\s");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith(".spec.ts")) {
            return content;
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _descriptionPattern.matcher(content);
        while (matcher.find()) {
            String description = matcher.group(1);
            String unquotedDescription = StringUtil.unquote(description);
            String trimmedDescription = unquotedDescription.trim();
            String newDescription = null;
            newDescription = trimmedDescription.indexOf(39) == -1 ? StringUtil.quote(trimmedDescription) : StringUtil.quote(trimmedDescription, "\"");
            if (description.equals(newDescription)) continue;
            String replacement = StringUtil.replaceFirst(matcher.group(), description, newDescription);
            matcher.appendReplacement(sb, replacement);
        }
        if (sb.length() > 0) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }
}

