/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaFeatureFlagsAndTestInfoAnnotationCheck
extends BaseFileCheck {
    private static final String[] _ANNOTATION_NAMES = new String[]{"FeatureFlags", "TestInfo"};

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        for (String annotationName : _ANNOTATION_NAMES) {
            Pattern pattern = Pattern.compile("\n\t*@" + annotationName + "\\((.+?)\\)\n", 32);
            Matcher matcher = pattern.matcher(content);
            block1: while (matcher.find()) {
                String[] values;
                String annotationContent = matcher.group(1);
                String trimmedAnnotationContent = annotationContent.trim();
                if (trimmedAnnotationContent.startsWith("\"") && trimmedAnnotationContent.endsWith("\"")) {
                    values = (trimmedAnnotationContent = trimmedAnnotationContent.substring(1, trimmedAnnotationContent.length() - 1)).split(",");
                    if (values.length < 2) continue;
                    Arrays.sort(values, new NaturalOrderStringComparator());
                    StringBundler sb = new StringBundler(values.length * 4);
                    for (String value : values) {
                        sb.append("\"");
                        sb.append(value);
                        sb.append("\"");
                        sb.append(", ");
                    }
                    if (sb.index() > 0) {
                        sb.setIndex(sb.index() - 1);
                    }
                    return StringUtil.replaceFirst(content, annotationContent, "{" + sb.toString() + "}", matcher.start(1));
                }
                if (!trimmedAnnotationContent.startsWith("{") || !trimmedAnnotationContent.endsWith("}")) continue;
                trimmedAnnotationContent = trimmedAnnotationContent.substring(1, trimmedAnnotationContent.length() - 1);
                trimmedAnnotationContent = trimmedAnnotationContent.replaceAll("\n\t+", " ");
                values = (trimmedAnnotationContent = trimmedAnnotationContent.trim()).split(", ");
                if (values.length < 2) continue;
                NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
                String previousValue = null;
                for (String value : values) {
                    if (previousValue == null) {
                        previousValue = value;
                        continue;
                    }
                    if (comparator.compare(previousValue, value) > 0) {
                        this.addMessage(fileName, StringBundler.concat("Incorrect order in @", annotationName, ": ", previousValue, " should come after ", value), this.getLineNumber(content, matcher.start(1)));
                        continue block1;
                    }
                    previousValue = value;
                }
            }
        }
        return content;
    }
}

