/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.UpgradeCatchAllJavaTermOrderCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.exception.UpgradeCatchAllException;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeCatchAllCheck
extends BaseFileCheck {
    private static final String _CONSTRUCTOR_REGEX = "n?e?w? ?(:?[A-Z][a-z]*)+\\(.*\\)";
    private static final Pattern _classDeclarationPattern = Pattern.compile(StringBundler.concat("^(?:@[a-zA-Z_][a-zA-Z0-9_]*(?:\\([^)]*\\))?\\s*)*", "(?:public|private|protected)?\\s*(?:static)?\\s*class\\s+", "([a-zA-Z_][a-zA-Z0-9_]*)\\s*(?:extends\\s+[^\\s]+)?\\s*", "(?:implements\\s+[^\\s]+(?:,\\s+[^\\s]+)*)?\\s*\\{"), 8);
    private static String _issueKey;
    private static final Pattern _parameterNamePattern;
    private static boolean _testMode;
    private boolean _newMessage;

    public static String[] getExpectedMessages() throws Exception {
        ArrayList<String> expectedMessages = new ArrayList<String>();
        JSONArray jsonArray = UpgradeCatchAllCheck._getReplacementsJSONArray("replacements.json");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object[] validExtensions = JSONUtil.toStringArray(jsonObject.getJSONArray("validExtensions"));
            if (validExtensions.length > 0 && !ArrayUtil.contains(validExtensions, "java") || _issueKey != null && !Objects.equals(_issueKey, jsonObject.getString("issueKey"))) continue;
            String from = jsonObject.getString("from");
            Set<String> keys = jsonObject.keySet();
            boolean skipValidation = false;
            if (jsonObject.getBoolean("skipParametersValidation") || from.startsWith("regex:")) {
                skipValidation = true;
            }
            if ((!from.contains("(") || skipValidation) && (!keys.contains("from") || keys.contains("to"))) continue;
            expectedMessages.add(UpgradeCatchAllCheck._getMessage(jsonObject));
        }
        return ArrayUtil.toStringArray(expectedMessages);
    }

    public static void setIssueKey(String issueKey) {
        _issueKey = issueKey;
    }

    public static void setTestMode(boolean testMode) {
        _testMode = testMode;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (_testMode && fileName.endsWith(".java")) {
            UpgradeCatchAllJavaTermOrderCheck termOrderCheck = new UpgradeCatchAllJavaTermOrderCheck();
            JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
            if (!StringUtil.equals(javaClass.getContent(), termOrderCheck.doProcess(fileName, absolutePath, javaClass, content))) {
                throw new UpgradeCatchAllException(fileName + " missing javaTerms sorting");
            }
        }
        JSONArray jsonArray = UpgradeCatchAllCheck._getReplacementsJSONArray("replacements.json");
        for (int i = 0; i < jsonArray.length(); ++i) {
            String to;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (_issueKey != null && !Objects.equals(_issueKey, jsonObject.getString("issueKey")) || !this._hasValidExtension(fileName, jsonObject)) continue;
            String oldContent = content;
            this._newMessage = false;
            content = fileName.endsWith(".java") ? this._formatJava(content, fileName, jsonObject) : this._formatGeneral(content, fileName, jsonObject);
            if (!_testMode || !oldContent.equals(content) || (to = jsonObject.getString("to")).isEmpty() && this._newMessage) continue;
            throw new UpgradeCatchAllException("Unable to process pattern " + jsonObject.getString("from") + " or there is no test associated with it");
        }
        _testMode = false;
        return content;
    }

    private static List<String> _getInterpolatedNewParameterNames(List<String> parameterNames, List<String> newParameterNames, String prefix) {
        ArrayList<String> interpolatedNewParameterNames = new ArrayList<String>();
        for (String newParameterName : newParameterNames) {
            if (newParameterName.contains(prefix)) {
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                Matcher matcher = _parameterNamePattern.matcher(newParameterName);
                while (matcher.find()) {
                    int index = GetterUtil.getInteger(matcher.group(1));
                    indexes.add(index);
                }
                Iterator iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    newParameterName = StringUtil.replace(newParameterName, prefix + index + '#', parameterNames.get(index));
                }
            }
            interpolatedNewParameterNames.add(newParameterName);
        }
        return interpolatedNewParameterNames;
    }

    private static String _getMessage(JSONObject jsonObject) {
        String from;
        int index;
        StringBundler sb = new StringBundler(6);
        sb.append("See ");
        sb.append(jsonObject.getString("issueKey"));
        sb.append(", ");
        Object[] classNames = JSONUtil.toStringArray(jsonObject.getJSONArray("classNames"));
        String classNamesFormated = null;
        if (classNames.length > 0) {
            classNamesFormated = StringUtil.merge(classNames, "/");
        }
        if ((index = (from = jsonObject.getString("from")).indexOf(46)) != -1) {
            from = StringUtil.replace(from, '.', '#');
        } else if (classNamesFormated != null) {
            sb.append(classNamesFormated);
            sb.append("#");
        }
        sb.append(from);
        return sb.toString();
    }

    private static Pattern _getMethodSignaturePattern(JSONObject jsonObject) {
        String from = jsonObject.getString("from");
        if (from.startsWith("regex:")) {
            return Pattern.compile(from.replaceFirst("regex:", ""));
        }
        String methodRegex = StringUtil.replace(from, new char[]{' ', '\n', '\t', '(', ')', '.', ','}, new String[]{"\\s+", "\\s*", "\\s*", "\\(", "\\)", "\\.\\s*", "\\,\\s*"});
        methodRegex = methodRegex + ")(?:\\s+throws\\s+[A-Za-z0-9._<>\\s,]+)?";
        String methodStartRegex = "\\n\\s+(?:@[A-Za-z]+\\s+)?(?:public|private|protected|static|final|abstract|\\s+)*";
        methodRegex = from.contains("@") ? StringBundler.concat("^(", methodStartRegex, methodRegex) : StringBundler.concat(Character.valueOf('^'), methodStartRegex, Character.valueOf('('), methodRegex);
        return Pattern.compile(methodRegex, 8);
    }

    private static Pattern _getPattern(JSONObject jsonObject) {
        String[] classNames;
        String from = jsonObject.getString("from");
        String regex = StringBundler.concat("\\b", from, "\\b");
        if (from.startsWith("regex:")) {
            return Pattern.compile(from.replaceFirst("regex:", ""));
        }
        if (regex.contains("/")) {
            return Pattern.compile(StringUtil.replace(regex, '/', "\\/"));
        }
        if (regex.contains("(")) {
            regex = StringUtil.replace(regex, '(', "\\b\\(");
            if (jsonObject.getBoolean("skipParametersValidation") && !from.matches(_CONSTRUCTOR_REGEX)) {
                regex = StringUtil.replace(regex, ')', "\\)");
                regex = StringUtil.removeSubstring(regex, "\\b");
            } else {
                regex = regex.substring(0, regex.indexOf(40) + 1);
            }
        } else if (regex.endsWith(">\\b")) {
            regex = StringUtil.removeLast(regex, "\\b");
            regex = StringUtil.replaceFirst(regex, '<', "\\s*<[?\\s\\w]*");
            regex = StringUtil.replace(regex, ", ", ",[?\\s\\w]*");
        } else {
            regex = regex + "[,;> (){]";
        }
        if (regex.contains(".")) {
            return Pattern.compile(StringUtil.replace(regex, '.', "\\.\\s*"));
        }
        if ((Character.isUpperCase(from.charAt(0)) || StringUtil.startsWith(from, "new")) && (classNames = JSONUtil.toStringArray(jsonObject.getJSONArray("classNames"))).length == 0) {
            return Pattern.compile(regex);
        }
        return Pattern.compile("\\w+\\.[\\w\\(\\)\\s\\.]*" + regex);
    }

    private static JSONArray _getReplacementsJSONArray(String fileName) throws Exception {
        ClassLoader classLoader = UpgradeCatchAllCheck.class.getClassLoader();
        return new JSONArrayImpl(StringUtil.read(classLoader.getResourceAsStream("dependencies/" + fileName)));
    }

    private String _addNewReference(String content, String newReference) {
        if (!newReference.equals("")) {
            content = JavaSourceUtil.addImports(content, "org.osgi.service.component.annotations.Reference");
            return StringUtil.replaceLast(content, '}', "\t@Reference\n\tprivate " + newReference + ";\n\n}");
        }
        return content;
    }

    private String _addOrReplaceMethodParameters(List<String> methodParameterNames, String newMethodCall, List<String> newMethodParameterNames) {
        return this._addOrReplaceParameters(")", newMethodCall, newMethodParameterNames, methodParameterNames, "param#");
    }

    private String _addOrReplaceParameters(String lastCharacter, String newMethodCall, List<String> newParameterNames, List<String> parameterNames, String prefix) {
        StringBundler sb = new StringBundler(2 + newParameterNames.size());
        sb.append(newMethodCall);
        sb.append(StringUtil.merge(UpgradeCatchAllCheck._getInterpolatedNewParameterNames(parameterNames, newParameterNames, prefix), ", "));
        sb.append(lastCharacter);
        return sb.toString();
    }

    private String _addOrReplaceTypeParameters(String newMethodCall, List<String> newTypeParameterNames, List<String> typeParameterNames) {
        return this._addOrReplaceParameters(">", newMethodCall, newTypeParameterNames, typeParameterNames, "typeParam#");
    }

    private String _addReplacementDependencies(String fileName, JSONObject jsonObject, String newContent) {
        String[] newImports = JSONUtil.toStringArray(jsonObject.getJSONArray("newImports"));
        if (fileName.endsWith(".java")) {
            newContent = JavaSourceUtil.addImports(newContent, newImports);
            return this._addNewReference(newContent, jsonObject.getString("newReference"));
        }
        if (fileName.endsWith(".jsp")) {
            newContent = BaseUpgradeCheck.addNewImportsJSPHeader(newContent, newImports);
        }
        return newContent;
    }

    private int _findMatchingClosingBrace(String content, int index) {
        int count = 0;
        for (int i = index; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '{') {
                ++count;
            } else if (c == '}') {
                --count;
            }
            if (count != 0) continue;
            return i;
        }
        return -1;
    }

    private String _formatCalls(String content, String fileName, JavaClass javaClass, JSONObject jsonObject) throws Exception {
        Pattern pattern;
        Matcher matcher;
        Set<String> keys;
        String newContent = content;
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            String javaContent = null;
            if (childJavaTerm.isJavaMethod()) {
                JavaMethod javaMethod = (JavaMethod)childJavaTerm;
                javaContent = javaMethod.getContent();
            } else if (childJavaTerm.isJavaVariable()) {
                JavaVariable javaVariable = (JavaVariable)childJavaTerm;
                javaContent = javaVariable.getContent();
            }
            if (javaContent == null) continue;
            int index = newContent.indexOf(javaContent);
            Pattern pattern2 = UpgradeCatchAllCheck._getPattern(jsonObject);
            Matcher matcher2 = pattern2.matcher(javaContent);
            while (matcher2.find()) {
                String methodCall = matcher2.group();
                String[] classNames = JSONUtil.toStringArray(jsonObject.getJSONArray("classNames"));
                if (classNames.length > 0 && !this._hasValidClassName(classNames, javaContent, content, fileName, methodCall)) continue;
                String from = jsonObject.getString("from");
                String to = jsonObject.getString("to");
                if (from.startsWith("regex:")) {
                    if (classNames.length > 0) {
                        newContent = StringUtil.replaceFirst(newContent, methodCall, methodCall.replaceFirst(pattern2.toString(), to), index + matcher2.start());
                        continue;
                    }
                    newContent = newContent.replaceAll(pattern2.toString(), to);
                    continue;
                }
                if (from.contains("(")) {
                    newContent = this._formatMethodCall(fileName, from, javaContent, jsonObject, matcher2, newContent, to);
                    continue;
                }
                if (from.contains("<")) {
                    newContent = this._formatTypeParameters(methodCall, newContent, to);
                    continue;
                }
                newContent = StringUtil.replaceFirst(newContent, methodCall, StringUtil.replace(methodCall, from, to), matcher2.start());
            }
        }
        if (!content.equals(newContent)) {
            newContent = this._addReplacementDependencies(fileName, jsonObject, newContent);
        } else if (!this._newMessage && !(keys = jsonObject.keySet()).contains("to") && (matcher = (pattern = UpgradeCatchAllCheck._getPattern(jsonObject)).matcher(content)).find()) {
            this.addMessage(fileName, UpgradeCatchAllCheck._getMessage(jsonObject));
            this._newMessage = true;
        }
        return newContent;
    }

    private String _formatGeneral(String content, String fileName, JSONObject jsonObject) {
        String newContent = content;
        Pattern pattern = UpgradeCatchAllCheck._getPattern(jsonObject);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String methodCall = matcher.group();
            String from = jsonObject.getString("from");
            String to = jsonObject.getString("to");
            if (from.startsWith("regex:")) {
                newContent = newContent.replaceAll(pattern.toString(), to);
                continue;
            }
            if (from.contains("(")) {
                newContent = this._formatMethodCall(fileName, from, newContent, jsonObject, matcher, newContent, to);
                continue;
            }
            Set<String> keys = jsonObject.keySet();
            if (!keys.contains("to")) {
                this.addMessage(fileName, UpgradeCatchAllCheck._getMessage(jsonObject));
                this._newMessage = true;
                continue;
            }
            newContent = StringUtil.replaceFirst(newContent, methodCall, StringUtil.replace(methodCall, from, to), matcher.start());
        }
        if (!content.equals(newContent)) {
            newContent = this._addReplacementDependencies(fileName, jsonObject, newContent);
        }
        return newContent;
    }

    private String _formatJava(String content, String fileName, JSONObject jsonObject) throws Exception {
        JSONArray jsonArray;
        String newContent = content;
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        if (!jsonObject.getBoolean("classStructurePattern")) {
            return this._formatCalls(content, fileName, javaClass, jsonObject);
        }
        Object[] classNames = JSONUtil.toStringArray(jsonObject.getJSONArray("classNames"));
        if (ArrayUtil.isEmpty(classNames)) {
            return newContent;
        }
        for (Object className : classNames) {
            List<String> implementedClassNames = javaClass.getImplementedClassNames();
            List<String> extendedClassNames = javaClass.getExtendedClassNames();
            if (extendedClassNames.contains(className) || implementedClassNames.contains(className)) continue;
            return newContent;
        }
        Object[] newMethods = JSONUtil.toStringArray(jsonObject.getJSONArray("newMethods"));
        if (ArrayUtil.isNotEmpty(newMethods)) {
            for (Object newMethod : newMethods) {
                newContent = this._insertMethodAlphabetically(newContent, (String)newMethod);
            }
        }
        if (JSONUtil.isEmpty(jsonArray = jsonObject.getJSONArray("methodsToFormat"))) {
            return newContent;
        }
        for (Object method : jsonArray) {
            JSONObject methodJSONObject = (JSONObject)method;
            newContent = this._formatMethodSignature(newContent, methodJSONObject);
        }
        return newContent;
    }

    private String _formatMethodCall(String fileName, String from, String javaMethodContent, JSONObject jsonObject, Matcher matcher, String newContent, String to) {
        String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
        List<String> parameterNames = JavaSourceUtil.getParameterNames(methodCall);
        if (!this._hasValidMethodCall(fileName, from, javaMethodContent, jsonObject, newContent, parameterNames)) {
            return newContent;
        }
        if (to.isEmpty()) {
            String newJavaMethodContent = StringUtil.removeFirst(javaMethodContent, methodCall);
            String line = this.getLine(newJavaMethodContent, this.getLineNumber(newJavaMethodContent, matcher.start()));
            return StringUtil.replaceFirst(newContent, javaMethodContent, StringUtil.removeFirst(newJavaMethodContent, line + '\n'));
        }
        return this._formatParameters(methodCall, newContent, parameterNames, to);
    }

    private String _formatMethodSignature(String content, JSONObject jsonObject) {
        String from = jsonObject.getString("from");
        String to = jsonObject.getString("to");
        Pattern pattern = UpgradeCatchAllCheck._getMethodSignaturePattern(jsonObject);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (from.startsWith("regex:")) {
                return content.replaceAll(pattern.toString(), to);
            }
            String methodSignature = matcher.group(1);
            if (methodSignature.startsWith("\n\t") || methodSignature.startsWith("\n ")) {
                to = "\n\t" + to;
            }
            content = StringUtil.replace(content, matcher.group(1), to);
        }
        return content;
    }

    private String _formatParameters(String methodCall, String newContent, List<String> parameterNames, String to) {
        String newMethodCall = to.substring(0, to.indexOf(40) + 1);
        if (!(newMethodCall.contains(".") || Character.isUpperCase(newMethodCall.charAt(0)) || newMethodCall.contains(" "))) {
            newMethodCall = StringBundler.concat(this.getVariableName(methodCall), Character.valueOf('.'), newMethodCall);
        }
        newMethodCall = this._addOrReplaceMethodParameters(parameterNames, newMethodCall, JavaSourceUtil.getParameterList(to));
        String removedFirstMethodCall = StringUtil.removeSubstring(to, JavaSourceUtil.getMethodCall(to, 0));
        newMethodCall = newMethodCall + removedFirstMethodCall;
        return StringUtil.replaceFirst(newContent, methodCall, newMethodCall);
    }

    private String _formatTypeParameters(String methodCall, String newContent, String to) {
        String newMethodCall = methodCall.substring(0, methodCall.indexOf(60) + 1);
        String newTypeParameterName = to.substring(to.indexOf(60) + 1, to.lastIndexOf(62));
        List<String> newTypeParameterNames = Arrays.asList(newTypeParameterName.split(", "));
        String typeParameterName = methodCall.substring(methodCall.indexOf(60) + 1, methodCall.lastIndexOf(62));
        List<String> typeParameterNames = Arrays.asList(typeParameterName.split(", "));
        newMethodCall = this._addOrReplaceTypeParameters(newMethodCall, newTypeParameterNames, typeParameterNames);
        return StringUtil.replace(newContent, methodCall, newMethodCall);
    }

    private boolean _hasValidClassName(String[] classNames, String content, String fileContent, String fileName, String methodCall) throws Exception {
        String variableName = this.getVariableName(methodCall);
        for (String className : classNames) {
            if (Character.isUpperCase(variableName.charAt(0)) && StringUtil.equals(variableName, className)) {
                return true;
            }
            if (Character.isUpperCase(variableName.charAt(0)) || !this.hasClassOrVariableName(className, content, fileContent, fileName, methodCall)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasValidExtension(String fileName, JSONObject jsonObject) {
        String[] validExtensions = JSONUtil.toStringArray(jsonObject.getJSONArray("validExtensions"));
        if (validExtensions.length == 0) {
            validExtensions = new String[]{"java"};
        }
        for (String validExtension : validExtensions) {
            if (!fileName.endsWith('.' + validExtension)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasValidMethodCall(String fileName, String from, String javaMethodContent, JSONObject jsonObject, String newContent, List<String> parameterNames) {
        List<String> fromParameters = JavaSourceUtil.getParameterNames(from);
        boolean skipParametersValidation = jsonObject.getBoolean("skipParametersValidation");
        if (!skipParametersValidation) {
            fromParameters = JavaSourceUtil.getParameterTypes(from);
        }
        if (parameterNames.size() != fromParameters.size()) {
            return false;
        }
        if (skipParametersValidation) {
            return true;
        }
        boolean sendMessage = false;
        Set<String> keys = jsonObject.keySet();
        if (!keys.contains("to")) {
            sendMessage = true;
        } else if (fileName.endsWith(".java")) {
            for (int i = 0; i < fromParameters.size(); ++i) {
                String parameterName = parameterNames.get(i);
                String variableTypeName = this.getVariableTypeName(javaMethodContent, null, newContent, fileName, parameterName.trim(), true, false);
                if (variableTypeName == null) {
                    sendMessage = true;
                    continue;
                }
                if (StringUtil.equals(fromParameters.get(i), variableTypeName)) continue;
                return false;
            }
        }
        if (sendMessage) {
            this.addMessage(fileName, UpgradeCatchAllCheck._getMessage(jsonObject));
            this._newMessage = true;
            return false;
        }
        return true;
    }

    private String _insertMethodAlphabetically(String fileContent, String newMethod) throws Exception {
        int endIndex = -1;
        int startIndex = -1;
        Matcher matcher = _classDeclarationPattern.matcher(fileContent);
        if (matcher.find()) {
            startIndex = matcher.end() + 1;
            endIndex = this._findMatchingClosingBrace(fileContent, startIndex - 2);
            if (endIndex == -1) {
                throw new UpgradeCatchAllException("Unable to find matching closing brace for the class");
            }
        } else {
            throw new UpgradeCatchAllException("Unable to find class declaration in the file content");
        }
        String classBody = fileContent.substring(startIndex, endIndex);
        Pattern pattern = Pattern.compile(StringBundler.concat("^\\n\\t\\s*(?:(?:@[a-zA-Z_][a-zA-Z0-9_]*(?:\\([^)]*\\))?\\s*", "\\n\\s*)*(?:@[a-zA-Z_][a-zA-Z0-9_]*(?:\\([^)]*\\))?\\s*)?)?", "(?:public|private|protected|static|final|synchronized|", "abstract|native)\\s+[^\\s]+\\s+([a-zA-Z_][a-zA-Z0-9_]*", "\\s*\\([^)]*\\))\\s*(?:throws\\s+", "[^\\s]+(?:,\\s+[^\\s]+)*)?\\s*\\{"), 8);
        ArrayList<String> methodNames = new ArrayList<String>();
        ArrayList<String> existingMethods = new ArrayList<String>();
        Matcher bodyMatcher = pattern.matcher(classBody);
        while (bodyMatcher.find()) {
            String methodName = bodyMatcher.group(1);
            methodName = StringUtil.removeChar(methodName, '\n');
            int methodIndex = bodyMatcher.start();
            int methodEndIndex = this._findMatchingClosingBrace(classBody, bodyMatcher.end() - 1);
            if (methodEndIndex == -1) continue;
            existingMethods.add(classBody.substring(methodIndex, methodEndIndex + 1));
            methodNames.add(methodName);
        }
        newMethod = "\n\t" + newMethod;
        Matcher newMethodMatcher = pattern.matcher(newMethod);
        if (!newMethodMatcher.find()) {
            throw new UpgradeCatchAllException("Unable to extract the name of the method to be inserted");
        }
        String newMethodName = newMethodMatcher.group(1);
        if (methodNames.contains(newMethodName = StringUtil.removeChar(newMethodName, '\n'))) {
            return fileContent;
        }
        methodNames.add(newMethodName);
        Collections.sort(methodNames);
        StringBuilder newClassBodySB = new StringBuilder();
        if (existingMethods.isEmpty()) {
            newClassBodySB.append(newMethod);
        } else {
            int insertIndex = methodNames.indexOf(newMethodName);
            if (insertIndex == 0) {
                newClassBodySB.append(newMethod);
                for (String existingMethod : existingMethods) {
                    newClassBodySB.append("\n");
                    newClassBodySB.append(existingMethod);
                }
            } else if (insertIndex == existingMethods.size()) {
                for (String existingMethod : existingMethods) {
                    newClassBodySB.append(existingMethod);
                    newClassBodySB.append("\n");
                }
                newClassBodySB.append(newMethod);
            } else {
                int i;
                for (i = 0; i < insertIndex; ++i) {
                    newClassBodySB.append((String)existingMethods.get(i));
                    newClassBodySB.append("\n");
                }
                newClassBodySB.append(newMethod);
                newClassBodySB.append("\n");
                for (i = insertIndex; i < existingMethods.size(); ++i) {
                    newClassBodySB.append((String)existingMethods.get(i));
                    newClassBodySB.append("\n");
                }
            }
        }
        StringBuilder newFileContentSB = new StringBuilder();
        String tempFileContent = fileContent.substring(0, endIndex);
        for (String existingMethod : existingMethods) {
            tempFileContent = StringUtil.removeSubstring(tempFileContent, "\n" + existingMethod);
        }
        newFileContentSB.append(tempFileContent.trim());
        newFileContentSB.append("\n");
        newFileContentSB.append((CharSequence)newClassBodySB);
        newFileContentSB.append("\n\n");
        newFileContentSB.append(fileContent.substring(endIndex));
        return newFileContentSB.toString();
    }

    static {
        _parameterNamePattern = Pattern.compile("\\w+#(\\d+)#");
    }
}

