/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDeserializationSecurityCheck
extends BaseFileCheck {
    private static final Pattern[] _javaSerializationVulnerabilityPatterns = new Pattern[]{Pattern.compile(".*(new [a-z\\.\\s]*ObjectInputStream).*", 32), Pattern.compile(".*(extends [a-z\\.\\s]*ObjectInputStream).*", 32)};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return content;
        }
        this._checkDeserializationSecurity(fileName, content, absolutePath);
        return content;
    }

    private void _checkDeserializationSecurity(String fileName, String content, String absolutePath) {
        for (Pattern vulnerabilityPattern : _javaSerializationVulnerabilityPatterns) {
            Matcher matcher = vulnerabilityPattern.matcher(content);
            if (!matcher.matches()) continue;
            StringBundler sb = new StringBundler(3);
            if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
                sb.append("Possible Java Serialization Remote Code Execution ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use ProtectedObjectInputStream instead of ");
            }
            sb.append(matcher.group(1));
            this.addMessage(fileName, sb.toString());
        }
    }
}

