/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

public class YieldHandler
extends AbstractExpressionHandler {
    public YieldHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "yield", ast, parent);
    }

    @Override
    public void checkIndentation() {
        this.checkYield();
        DetailAST expression = this.getMainAst().getFirstChild();
        if (!TokenUtil.areOnSameLine(this.getMainAst(), expression)) {
            this.checkExpressionSubtree(expression, this.getIndent(), false, false);
        }
    }

    private void checkYield() {
        DetailAST yieldKey = this.getMainAst();
        int columnNo = this.expandedTabsColumnNo(yieldKey);
        if (this.isOnStartOfLine(yieldKey) && !this.getIndent().isAcceptable(columnNo)) {
            this.logError(yieldKey, "", columnNo);
        }
    }
}

