/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaStaticBlock;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseJavaTerm
implements JavaTerm {
    private final String _accessModifier;
    private final String _content;
    private final boolean _isAbstract;
    private final boolean _isFinal;
    private final boolean _isStatic;
    private final int _lineNumber;
    private final String _name;
    private JavaClass _parentJavaClass;

    public BaseJavaTerm(String accessModifier, String content, boolean isAbstract, boolean isFinal, boolean isStatic, int lineNumber, String name) {
        this._accessModifier = accessModifier;
        this._content = content;
        this._isAbstract = isAbstract;
        this._isFinal = isFinal;
        this._isStatic = isStatic;
        this._lineNumber = lineNumber;
        this._name = name;
    }

    @Override
    public String getAccessModifier() {
        return this._accessModifier;
    }

    @Override
    public String getContent() {
        return this._content;
    }

    @Override
    public List<String> getImportNames() {
        JavaClass parentJavaClass = this._parentJavaClass;
        while (parentJavaClass.getParentJavaClass() != null) {
            parentJavaClass = parentJavaClass.getParentJavaClass();
        }
        return parentJavaClass.getImportNames();
    }

    @Override
    public int getLineNumber() {
        return this._lineNumber;
    }

    @Override
    public int getLineNumber(int pos) {
        return this._lineNumber + SourceUtil.getLineNumber(this._content, pos) - 1;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getPackageName() {
        JavaClass parentJavaClass = this._parentJavaClass;
        while (parentJavaClass.getParentJavaClass() != null) {
            parentJavaClass = parentJavaClass.getParentJavaClass();
        }
        return parentJavaClass.getPackageName();
    }

    @Override
    public JavaClass getParentJavaClass() {
        return this._parentJavaClass;
    }

    @Override
    public JavaSignature getSignature() {
        return null;
    }

    @Override
    public boolean hasAnnotation() {
        Pattern pattern = Pattern.compile(StringBundler.concat("(\\A|\n)", SourceUtil.getIndent(this._content), "@"));
        Matcher matcher = pattern.matcher(this._content);
        return matcher.find();
    }

    @Override
    public boolean hasAnnotation(String ... annotations) {
        for (String annotation : annotations) {
            Pattern pattern = Pattern.compile(StringBundler.concat("(\\A|\n)", SourceUtil.getIndent(this._content), "@", annotation, "(\\(|\n)"));
            Matcher matcher = pattern.matcher(this._content);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this._accessModifier, "default");
    }

    @Override
    public boolean isFinal() {
        return this._isFinal;
    }

    @Override
    public boolean isJavaClass() {
        return this instanceof JavaClass;
    }

    @Override
    public boolean isJavaConstructor() {
        return this instanceof JavaConstructor;
    }

    @Override
    public boolean isJavaMethod() {
        return this instanceof JavaMethod;
    }

    @Override
    public boolean isJavaStaticBlock() {
        return this instanceof JavaStaticBlock;
    }

    @Override
    public boolean isJavaVariable() {
        return this instanceof JavaVariable;
    }

    @Override
    public boolean isPrivate() {
        return Objects.equals(this._accessModifier, "private");
    }

    @Override
    public boolean isProtected() {
        return Objects.equals(this._accessModifier, "protected");
    }

    @Override
    public boolean isPublic() {
        return Objects.equals(this._accessModifier, "public");
    }

    @Override
    public boolean isStatic() {
        return this._isStatic;
    }

    @Override
    public void setParentJavaClass(JavaClass javaClass) {
        this._parentJavaClass = javaClass;
    }
}

