/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.io.Serializable;
import java.util.Comparator;

public class NaturalOrderStringComparator
implements Comparator<String>,
Serializable {
    private final boolean _ascending;
    private final boolean _caseSensitive;

    public NaturalOrderStringComparator() {
        this(true, false);
    }

    public NaturalOrderStringComparator(boolean ascending, boolean caseSensitive) {
        this._ascending = ascending;
        this._caseSensitive = caseSensitive;
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        int value = 0;
        int i1 = 0;
        int i2 = 0;
        int length1 = s1.length();
        int length2 = s2.length();
        while (i1 < length1 && i2 < length2) {
            char c2UpperCase;
            boolean digitOrLetter2;
            boolean digitOrLetter1;
            char c1 = s1.charAt(i1);
            char c2 = s2.charAt(i2);
            if (Validator.isDigit(c1) && Validator.isDigit(c2)) {
                int leadingNumber2;
                String leadingDigitsAsString1 = StringUtil.extractLeadingDigits(s1.substring(i1));
                String leadingDigitsAsString2 = StringUtil.extractLeadingDigits(s2.substring(i2));
                int leadingNumber1 = GetterUtil.getInteger(leadingDigitsAsString1);
                if (leadingNumber1 != (leadingNumber2 = GetterUtil.getInteger(leadingDigitsAsString2))) {
                    value = leadingNumber1 - leadingNumber2;
                    break;
                }
                i1 += leadingDigitsAsString1.length();
                i2 += leadingDigitsAsString2.length();
                continue;
            }
            if (this.isCheckSpecialCharacters() && Validator.isAscii(c1) && Validator.isAscii(c2) && (digitOrLetter1 = this._isDigitOrLetter(c1)) ^ (digitOrLetter2 = this._isDigitOrLetter(c2))) {
                if (digitOrLetter1) {
                    value = 1;
                    break;
                }
                value = -1;
                break;
            }
            if (c1 == c2) {
                ++i1;
                ++i2;
                continue;
            }
            if (this._caseSensitive) {
                value = c1 - c2;
                break;
            }
            char c1UpperCase = Character.toUpperCase(c1);
            if (c1UpperCase == (c2UpperCase = Character.toUpperCase(c2))) {
                ++i1;
                ++i2;
                continue;
            }
            value = c1UpperCase - c2UpperCase;
            break;
        }
        if (value == 0 && length1 != length2) {
            value = length1 == i1 && length2 == i2 ? length2 - length1 : length1 - length2;
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    protected boolean isCheckSpecialCharacters() {
        return true;
    }

    private boolean _isDigitOrLetter(char c) {
        return Validator.isChar(c) || Validator.isDigit(c);
    }
}

