/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseStringConcatenationCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class AppendCheck
extends BaseStringConcatenationCheck {
    private static final String _MSG_INCORRECT_LINE_BREAK = "line.break.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, "append");
        for (int i = 0; i < methodCallDetailASTList.size(); ++i) {
            DetailAST previousMethodCallFirstParameterDetailAST;
            DetailAST previousMethodCallFirstParameterExprDetailAST;
            DetailAST previousMethodCallDetailAST;
            DetailAST methodCallFirstParameterExprDetailAST;
            String variableName;
            DetailAST methodCallDetailAST = methodCallDetailASTList.get(i);
            String variableTypeName = this.getVariableTypeName(methodCallDetailAST, variableName = this.getVariableName(methodCallDetailAST), false);
            if (!variableTypeName.equals("StringBundler") || (methodCallFirstParameterExprDetailAST = this.getFirstParameterExprDetailAST(methodCallDetailAST)) == null) continue;
            DetailAST methodCallFirstParameterDetailAST = methodCallFirstParameterExprDetailAST.getFirstChild();
            this._checkPlusOperator(methodCallFirstParameterDetailAST);
            if (methodCallFirstParameterDetailAST.getType() != 139 || this._containsMethodCall(detailAST, variableName, "setIndex", "setStringAt")) continue;
            if (i < methodCallDetailASTList.size() - 1) {
                DetailAST nextMethodCallDetailAST = methodCallDetailASTList.get(i + 1);
                if (!variableName.equals(this.getVariableName(nextMethodCallDetailAST)) || this.getEndLineNumber(methodCallDetailAST) != this.getStartLineNumber(nextMethodCallDetailAST) - 1) continue;
                DetailAST nextMethodCallFirstParameterExprDetailAST = this.getFirstParameterExprDetailAST(nextMethodCallDetailAST);
                if (nextMethodCallFirstParameterExprDetailAST != null) {
                    DetailAST nextMethodCallFirstParameterDetailAST = nextMethodCallFirstParameterExprDetailAST.getFirstChild();
                    if (nextMethodCallFirstParameterDetailAST.getType() == 139) {
                        this._checkLiteralStrings(methodCallDetailAST, nextMethodCallDetailAST, methodCallFirstParameterDetailAST.getText(), nextMethodCallFirstParameterDetailAST.getText());
                    } else {
                        this.checkCombineOperand(methodCallFirstParameterDetailAST, nextMethodCallFirstParameterDetailAST);
                    }
                }
            }
            if (i == 0 || !variableName.equals(this.getVariableName(previousMethodCallDetailAST = methodCallDetailASTList.get(i - 1))) || this.getEndLineNumber(previousMethodCallDetailAST) != this.getStartLineNumber(methodCallDetailAST) - 1 || (previousMethodCallFirstParameterExprDetailAST = this.getFirstParameterExprDetailAST(previousMethodCallDetailAST)) == null || (previousMethodCallFirstParameterDetailAST = previousMethodCallFirstParameterExprDetailAST.getFirstChild()).getType() == 139) continue;
            this.checkCombineOperand(methodCallFirstParameterDetailAST, previousMethodCallFirstParameterDetailAST);
        }
    }

    private void _checkLiteralStrings(DetailAST methodCallDetailAST, DetailAST nextMethodCallDetailAST, String literalStringValue, String nextLiteralStringValue) {
        if ((literalStringValue = literalStringValue.substring(1, literalStringValue.length() - 1)).endsWith("\\n")) {
            return;
        }
        nextLiteralStringValue = nextLiteralStringValue.substring(1, nextLiteralStringValue.length() - 1);
        this.checkLiteralStringStartAndEndCharacter(literalStringValue, nextLiteralStringValue, methodCallDetailAST.getLineNo());
        if (this._hasIncorrectLineBreaks(methodCallDetailAST) | this._hasIncorrectLineBreaks(nextMethodCallDetailAST) || literalStringValue.startsWith("<") || literalStringValue.endsWith(">") || nextLiteralStringValue.startsWith("<") || nextLiteralStringValue.endsWith(">")) {
            return;
        }
        String line = this.getLine(methodCallDetailAST.getLineNo() - 1);
        int lineLength = CommonUtil.lengthExpandedTabs((String)line, (int)line.length(), (int)this.getTabWidth());
        if (lineLength + nextLiteralStringValue.length() <= this.getMaxLineLength()) {
            this.log(nextMethodCallDetailAST, "literal.string.combine", new Object[]{literalStringValue, nextLiteralStringValue});
        } else {
            int pos = this.getStringBreakPos(literalStringValue, nextLiteralStringValue, this.getMaxLineLength() - lineLength);
            if (pos != -1) {
                this.log(nextMethodCallDetailAST, "literal.string.move", new Object[]{nextLiteralStringValue.substring(0, pos + 1), "previous"});
            }
        }
        this.checkLiteralStringBreaks(nextMethodCallDetailAST, line, this.getLine(methodCallDetailAST.getLineNo()), literalStringValue, nextLiteralStringValue);
    }

    private void _checkPlusOperator(DetailAST parameterDetailAST) {
        if (parameterDetailAST.getType() != 125) {
            return;
        }
        List<DetailAST> literalStringDetailASTList = this.getAllChildTokens(parameterDetailAST, true, 139);
        if (!literalStringDetailASTList.isEmpty()) {
            this.log(parameterDetailAST, "plus.incorrect", new Object[0]);
        }
    }

    private boolean _containsMethodCall(DetailAST detailAST, String variableName, String ... methodNames) {
        for (String methodName : methodNames) {
            List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, variableName, methodName);
            if (methodCallDetailASTList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean _hasIncorrectLineBreaks(DetailAST methodCallDetailAST) {
        if (this.getStartLineNumber(methodCallDetailAST) != this.getEndLineNumber(methodCallDetailAST)) {
            this.log(methodCallDetailAST, _MSG_INCORRECT_LINE_BREAK, new Object[0]);
            return true;
        }
        return false;
    }
}

