/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.comparator.JavaTermComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class JavaTermOrderCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws DocumentException, IOException {
        Document customSQLDocument;
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.contains("@Meta.OCD")) {
            return javaTermContent;
        }
        String className = javaTerm.getName();
        String customSQLContent = null;
        if (absolutePath.contains("/persistence/") && className.endsWith("FinderImpl") && (customSQLDocument = this.getCustomSQLDocument(fileName, absolutePath, this.getPortalCustomSQLDocument(absolutePath))) != null && customSQLDocument.hasContent()) {
            customSQLContent = customSQLDocument.asXML();
        }
        return this._sortJavaTerms(fileName, absolutePath, (JavaClass)javaTerm, customSQLContent);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _sortJavaTerms(JavaClass javaClass, List<JavaTerm> javaTerms, JavaTermComparator javaTermComparator) {
        String content = javaClass.getContent();
        ArrayList<JavaTerm> sortedJavaTerms = new ArrayList<JavaTerm>(javaTerms);
        Collections.sort(sortedJavaTerms, javaTermComparator);
        for (int i = javaTerms.size() - 1; i >= 0; --i) {
            JavaTerm javaTerm1 = javaTerms.get(i);
            JavaTerm javaTerm2 = (JavaTerm)sortedJavaTerms.get(i);
            if (Objects.equals(javaTerm1.getContent(), javaTerm2.getContent())) continue;
            content = StringUtil.replaceFirst(content, javaTerm1.getContent(), javaTerm2.getContent(), SourceUtil.getLineStartPos(content, javaTerm1.getLineNumber() - javaClass.getLineNumber()));
        }
        return content;
    }

    private String _sortJavaTerms(String fileName, String absolutePath, JavaClass javaClass, String customSQLContent) {
        ArrayList<JavaTerm> childJavaTerms = new ArrayList<JavaTerm>(javaClass.getChildJavaTerms());
        Iterator iterator = childJavaTerms.iterator();
        while (iterator.hasNext()) {
            JavaTerm javaTerm = (JavaTerm)iterator.next();
            if (!javaTerm.isJavaStaticBlock() && !javaTerm.isDefault()) continue;
            iterator.remove();
        }
        if (childJavaTerms.size() < 2) {
            return javaClass.getContent();
        }
        JavaTermComparator javaTermComparator = new JavaTermComparator(customSQLContent);
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : childJavaTerms) {
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            int compare = javaTermComparator.compare(previousJavaTerm, javaTerm);
            if (compare == 0) {
                this.addMessage(fileName, "Duplicate " + javaTerm.getName());
                return javaClass.getContent();
            }
            if (!this.isExcludedPath("javaterm.sort.excludes", absolutePath, previousJavaTerm.getName()) && !this.isExcludedPath("javaterm.sort.excludes", absolutePath, javaTerm.getName()) && compare > 0) {
                return this._sortJavaTerms(javaClass, childJavaTerms, javaTermComparator);
            }
            previousJavaTerm = javaTerm;
        }
        return javaClass.getContent();
    }
}

