/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesSourceFormatterContentCheck
extends BaseFileCheck {
    private static final String[][] _CONVERTED_KEYS = new String[][]{{"blob/master/portal-impl/src/source-formatter.properties", "blob/master/source-formatter.properties"}};
    private static final Pattern _gitLiferayPortalBranchPattern = Pattern.compile("\\sgit\\.liferay\\.portal\\.branch=(\\\\\\s+)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/source-formatter.properties")) {
            content = this._checkConvertedKeys(content);
            content = this._checkGitLiferayPortalBranch(content);
        }
        return content;
    }

    private String _checkConvertedKeys(String content) {
        for (String[] array : _CONVERTED_KEYS) {
            content = StringUtil.replace(content, array[0], array[1]);
        }
        return content;
    }

    private String _checkGitLiferayPortalBranch(String content) {
        Matcher matcher = _gitLiferayPortalBranchPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
        }
        return content;
    }
}

