/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;

public class JavaModuleTestCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String content = javaTerm.getContent();
        if (!fileName.contains("/test/") && !fileName.contains("/testIntegration/")) {
            return content;
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.getParentJavaClass() != null || javaClass.isAnonymous()) {
            return content;
        }
        String className = javaClass.getName();
        this._checkTestClassName(fileName, javaClass, className);
        String packageName = javaClass.getPackageName();
        if (className.endsWith("Test") && packageName.startsWith("com.liferay")) {
            this._checkTestPackage(fileName, absolutePath, content, packageName);
        }
        return content;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkTestClassName(String fileName, JavaClass javaClass, String className) {
        if (className.endsWith("Test")) {
            if (javaClass.isAbstract()) {
                this.addMessage(fileName, "Class name ending with \"Test\" should not be abstract");
            } else if (javaClass.isInterface()) {
                this.addMessage(fileName, "Interface name should not end with \"Test\"");
            }
        }
        if (!this._hasTestMethod(javaClass)) {
            if (className.endsWith("Test")) {
                for (String extendedClassNames : javaClass.getExtendedClassNames()) {
                    if (!extendedClassNames.endsWith("Test") && !extendedClassNames.endsWith("TestCase")) continue;
                    return;
                }
                this.addMessage(fileName, StringBundler.concat("\"", className, "\" is not a real test class and therefore should not ", "end with \"Test\""));
            }
            return;
        }
        if (javaClass.isAbstract()) {
            if (!className.matches("Base.*TestCase")) {
                this.addMessage(fileName, "Abstract class name should match \"Base.*TestCase\"");
            }
        } else if (!className.endsWith("Test")) {
            this.addMessage(fileName, "Test class should end with \"Test\"");
        }
    }

    private void _checkTestPackage(String fileName, String absolutePath, String content, String packageName) {
        if (absolutePath.contains("/src/testIntegration/java/") || absolutePath.contains("/test/integration/")) {
            if (content.contains("@RunWith(Arquillian.class)") && content.contains("import org.powermock.")) {
                this.addMessage(fileName, "Do not use PowerMock inside Arquillian tests");
            }
            if (!packageName.endsWith(".test")) {
                this.addMessage(fileName, "Module integration test must be under a test subpackage");
            }
        } else if ((absolutePath.contains("/test/unit/") || absolutePath.contains("/src/test/java/")) && packageName.endsWith(".test")) {
            this.addMessage(fileName, "Module unit test should not be under a test subpackage");
        }
    }

    private boolean _hasTestMethod(JavaClass javaClass) {
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            if ((!(javaTerm instanceof JavaMethod) || !javaTerm.hasAnnotation("After", "AfterClass", "Before", "BeforeClass", "Test")) && (!(javaTerm instanceof JavaClass) || !this._hasTestMethod((JavaClass)javaTerm))) continue;
            return true;
        }
        return false;
    }
}

