/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaBasePanelAppExtendedClassesCheck
extends BaseUpgradeCheck {
    private static final Pattern _setPortletPattern = Pattern.compile("(?:@Override\\s*|)(@Reference\\(\\s*.+\\s*\\)+\")[\\s+\\S+]+setPortlet[\\s+\\S+]+;");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (!extendedClassNames.contains("BasePanelApp")) {
            return content;
        }
        Matcher matcher = _setPortletPattern.matcher(content);
        if (matcher.find()) {
            content = StringUtil.replace(content, matcher.group(), StringBundler.concat(matcher.group(1), "\n\t)\n\tprivate Portlet _portlet;\n\n\t@Override\n\t", "public Portlet getPortlet() {\n\t\treturn _portlet;"));
        }
        return content;
    }
}

