/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseUpgradeCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaDisplayPageInfoItemCapabilityCheck
extends BaseUpgradeCheck {
    private static final Pattern _pattern = Pattern.compile("@Reference\\s*private DisplayPageInfoItemCapability (\\w+);");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        Matcher matcher = _pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String annotationContent = this.joinLines("@Reference(", String.format("\t\ttarget = \"(info.item.capability.key=\" + DisplayPageInfoItemCapability.KEY + \")\"", new Object[0]), "\t)", "\tprivate InfoItemCapability " + matcher.group(1) + ";");
        return matcher.replaceAll(annotationContent);
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.info.item.capability.InfoItemCapability"};
    }
}

