/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class SingleSpaceSeparatorCheck
extends AbstractCheck {
    public static final String MSG_KEY = "single.space.separator";
    private boolean validateComments;

    public void setValidateComments(boolean validateComments) {
        this.validateComments = validateComments;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return this.validateComments;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        if (rootAST != null) {
            this.visitEachToken(rootAST);
        }
    }

    private void visitEachToken(DetailAST node) {
        DetailAST currentNode = node;
        DetailAST parent = node.getParent();
        do {
            int columnNo = currentNode.getColumnNo() - 1;
            int minSecondWhitespaceColumnNo = 2;
            if (columnNo >= 2 && !this.isTextSeparatedCorrectlyFromPrevious(this.getLine(currentNode.getLineNo() - 1), columnNo)) {
                this.log(currentNode, MSG_KEY, new Object[0]);
            }
            if (currentNode.hasChildren()) {
                currentNode = currentNode.getFirstChild();
                continue;
            }
            while (currentNode.getNextSibling() == null && currentNode.getParent() != parent) {
                currentNode = currentNode.getParent();
            }
            currentNode = currentNode.getNextSibling();
        } while (currentNode != null);
    }

    private boolean isTextSeparatedCorrectlyFromPrevious(String line, int columnNo) {
        return SingleSpaceSeparatorCheck.isSingleSpace(line, columnNo) || !SingleSpaceSeparatorCheck.isWhitespace(line, columnNo) || SingleSpaceSeparatorCheck.isFirstInLine(line, columnNo) || !this.validateComments && SingleSpaceSeparatorCheck.isBlockCommentEnd(line, columnNo);
    }

    private static boolean isSingleSpace(String line, int columnNo) {
        return SingleSpaceSeparatorCheck.isSpace(line, columnNo) && !Character.isWhitespace(line.charAt(columnNo - 1));
    }

    private static boolean isSpace(String line, int columnNo) {
        return line.charAt(columnNo) == ' ';
    }

    private static boolean isWhitespace(String line, int columnNo) {
        return Character.isWhitespace(line.charAt(columnNo));
    }

    private static boolean isFirstInLine(String line, int columnNo) {
        return CommonUtil.isBlank(line.substring(0, columnNo));
    }

    private static boolean isBlockCommentEnd(String line, int columnNo) {
        return line.substring(0, columnNo).trim().endsWith("*/");
    }
}

