/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaBaseFragmentCollectionContributorExtendedClassesCheck
extends BaseUpgradeCheck {
    private static final Pattern _pattern = Pattern.compile("return \"(.*?)\";");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (!extendedClassNames.contains("BaseFragmentCollectionContributor")) {
            return content;
        }
        return content.replaceFirst("@Component\\(service = FragmentCollectionContributor\\.class\\)", this.joinLines("@Component(", String.format("\tproperty = \"fragment.collection.key=%s\",", this._getFragmentCollectionKey(javaClass)), "\tservice = FragmentCollectionContributor.class", ")"));
    }

    private String _getFragmentCollectionKey(JavaClass javaClass) throws Exception {
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            Matcher matcher;
            JavaSignature javaSignature = childJavaTerm.getSignature();
            List<JavaParameter> javaParameters = javaSignature.getParameters();
            if (!Objects.equals(childJavaTerm.getName(), "getFragmentCollectionKey") || !javaParameters.isEmpty() || !(matcher = _pattern.matcher(javaClass.getContent())).find()) continue;
            return matcher.group(1);
        }
        throw new Exception(StringBundler.concat("Unable to find FragmentCollectionKey in Java Class ", javaClass.getName(), ". Please add FragmentCollectionKey to ", "method getFragmentCollectionKey"));
    }
}

