/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.util.ArrayList;

public class PropertiesDuplicateKeysCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = null;
            String propertyKey = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (Validator.isBlank(line = line.trim()) || line.startsWith("#") || previousLine != null && previousLine.endsWith("\\")) {
                    previousLine = line;
                    continue;
                }
                int x = line.indexOf(61);
                if (x == -1) {
                    previousLine = line;
                    continue;
                }
                propertyKey = line.substring(0, x);
                if (propertyKey.equals("include-and-override")) {
                    previousLine = line;
                    continue;
                }
                if (propertyKeys.contains(propertyKey)) {
                    this.addMessage(fileName, "Do not add duplicate property key \"" + propertyKey + "\"");
                }
                previousLine = line;
                propertyKeys.add(propertyKey);
            }
        }
        return content;
    }
}

