/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class ContainsPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "contains";
    private static final Pattern _conditionPattern = Pattern.compile("^contains\\((.*)[\\s]*,[\\s]*(\\d+|(?:\\$\\{|\\\")[\\s\\S]*(?:\\}|\"))\\)$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new ContainsPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new ContainsPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        Matcher matcher = _conditionPattern.matcher(poshiScript);
        matcher.find();
        String string = matcher.group(1);
        if (this.isQuotedContent(string)) {
            string = this.getDoubleQuotedContent(string);
        }
        this.addAttribute("string", string);
        String substring = matcher.group(2);
        if (this.isQuotedContent(substring)) {
            substring = this.getDoubleQuotedContent(substring);
        }
        this.addAttribute("substring", substring);
    }

    @Override
    public String toPoshiScript() {
        String substringValue;
        String stringValue = this.attributeValue("string");
        if (this.isQuotedContent(stringValue)) {
            stringValue = "\"" + stringValue + "\"";
        }
        if (this.isQuotedContent(substringValue = this.attributeValue("substring"))) {
            substringValue = "\"" + substringValue + "\"";
        }
        return StringUtil.combine(_ELEMENT_NAME, "(" + stringValue + ", ", substringValue, ")");
    }

    protected ContainsPoshiElement() {
        super(_ELEMENT_NAME);
    }

    protected ContainsPoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected ContainsPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        return _ELEMENT_NAME;
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (!this.isConditionValidInParent(parentPoshiElement)) {
            return false;
        }
        Matcher matcher = _conditionPattern.matcher(poshiScript);
        return matcher.find();
    }
}

