/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.ExecutePoshiElement;
import com.liferay.poshi.core.elements.PoshiCDATA;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.script.PoshiScriptParserUtil;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.Node;

public class VarPoshiElement
extends PoshiElement {
    protected String valueAttributeName;
    private static final String _ELEMENT_NAME = "var";
    private static final String _VAR_VALUE_INTEGER_REGEX = "\\d+[\\s]*(?![\\+-\\/\\*])";
    private static final String _VAR_VALUE_MATH_EXPRESSION_REGEX;
    private static final String _VAR_VALUE_MATH_VALUE_REGEX = "[\\s]*(\\$\\{[\\w]*\\}|[\\d]*)[\\s]*";
    private static final String _VAR_VALUE_MULTILINE_REGEX = "'''.*?'''";
    private static final String _VAR_VALUE_OBJECT_REGEX = "(new[\\s]*|)[\\w\\.]*\\(.*?\\)";
    private static final String _VAR_VALUE_REGEX;
    private static final String _VAR_VALUE_STRING_REGEX = "\".*?\"";
    private static final String _VAR_VALUE_VARIABLE_REGEX = "\\$\\{[\\w_-]+\\}";
    private static final Map<String, String> _mathOperatorsMap;
    private static final Pattern _mathUtilMethodCallPattern;
    private static final Pattern _nestedCDATAPattern;
    private static final Pattern _partialStatementPattern;
    private static final Pattern _statementPattern;
    private static final Pattern _varValueMathExpressionPattern;

    public Element addAttribute(String name, String value) {
        if (name.equals("from") || name.equals("method") || name.equals("value")) {
            this.valueAttributeName = name;
        }
        return super.addAttribute(name, value);
    }

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new VarPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(poshiScript)) {
            return new VarPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    public String getVarValue() {
        if (this.valueAttributeName == null) {
            ArrayList<Node> cdataNodes = new ArrayList<Node>();
            for (Node node : Dom4JUtil.toNodeList(this.content())) {
                if (!(node instanceof CDATA)) continue;
                cdataNodes.add(node);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("'''");
            for (Node cdataNode : cdataNodes) {
                sb.append(cdataNode.getText());
            }
            sb.append("'''");
            return sb.toString();
        }
        return this.attributeValue(this.valueAttributeName);
    }

    public boolean isDoubleQuotedVar(String value) {
        if (value.matches(_VAR_VALUE_INTEGER_REGEX)) {
            return false;
        }
        if (value.matches(_VAR_VALUE_MATH_EXPRESSION_REGEX)) {
            return true;
        }
        return !value.matches(_VAR_VALUE_VARIABLE_REGEX);
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        String name;
        if (!(this.getParent() instanceof ExecutePoshiElement)) {
            this.validateSemicolon(poshiScript);
        }
        if (poshiScript.startsWith("static var")) {
            this.addAttribute("static", "true");
            poshiScript = poshiScript.replaceFirst("static", "");
            poshiScript = poshiScript.trim();
        }
        if ((name = this.getNameFromAssignment(poshiScript)).contains(" ")) {
            int index = name.indexOf(" ");
            name = name.substring(index);
        }
        name = name.trim();
        this.addAttribute("name", name);
        String value = this.getValueFromAssignment(poshiScript);
        if (value.startsWith("'''")) {
            if ((value = this.getPoshiScriptEscapedContent(value)).contains("CDATA")) {
                Matcher nestedCDATAMatcher = _nestedCDATAPattern.matcher(value);
                nestedCDATAMatcher.find();
                String cdata1 = nestedCDATAMatcher.group("cdata1");
                String cdata2 = nestedCDATAMatcher.group("cdata2");
                this.add((CDATA)new PoshiCDATA(cdata1));
                this.add((CDATA)new PoshiCDATA(cdata2));
                return;
            }
            this.add((CDATA)new PoshiCDATA(value));
            return;
        }
        if (value.startsWith("new ")) {
            this.addAttribute("from", this.getDoubleQuotedContent(value));
            value = StringUtil.replace(value, "new ", "");
            int index = value.indexOf("(");
            String type = value.substring(0, index);
            this.addAttribute("type", type);
            return;
        }
        if (value.endsWith("\"") && value.startsWith("\"")) {
            if (value.contains("\n")) {
                throw new PoshiScriptParserException("Invalid variable assignment syntax, please use triple quotes (''') to wrap a multiline string instead of double quotes", value, (PoshiElement)this.getParent());
            }
            if ((value = this.getDoubleQuotedContent(value)).endsWith("}") && value.startsWith("${")) {
                String bracedContent = this.getBracedContent(value);
                if (bracedContent.contains(".hash(")) {
                    int index = bracedContent.indexOf(".");
                    String fromValue = StringUtil.combine("${", bracedContent.substring(0, index), "}");
                    this.addAttribute("from", fromValue);
                    this.addAttribute("hash", this.getSingleQuotedContent(bracedContent));
                    return;
                }
                if (bracedContent.contains("[")) {
                    int index = bracedContent.indexOf("[");
                    String fromValue = StringUtil.combine("${", bracedContent.substring(0, index), "}");
                    this.addAttribute("from", fromValue);
                    this.addAttribute("index", this.getBracketedContent(bracedContent));
                    return;
                }
            }
            value = value.replace("\\\"", "\"");
            value = StringEscapeUtils.unescapeXml((String)value);
            this.addAttribute("value", value);
            return;
        }
        if (value.matches(_VAR_VALUE_INTEGER_REGEX)) {
            this.addAttribute("value", value);
            return;
        }
        if (!this.isValidFunctionFileName(value) && !this.isValidMacroFileName(value) || value.startsWith("selenium.")) {
            Matcher matcher = _varValueMathExpressionPattern.matcher(value);
            if (matcher.matches()) {
                String mathOperation = _mathOperatorsMap.get(matcher.group(2));
                String mathUtilValue = StringUtil.combine("MathUtil#", mathOperation, "('", matcher.group(1), "', '", matcher.group(3), "')");
                this.addAttribute("method", mathUtilValue);
                return;
            }
            if (value.matches(_VAR_VALUE_VARIABLE_REGEX)) {
                this.addAttribute("value", value);
                return;
            }
            String content = this.getParentheticalContent(value = value.replaceFirst("\\.", "#"));
            if (!content.equals("")) {
                value = StringUtil.replace(value, content, this.swapParameterQuotations(content, false));
            }
            this.addAttribute("method", value);
        }
    }

    @Override
    public String toPoshiScript() {
        PoshiElement parentElement;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n\t");
        String staticAttribute = this.attributeValue("static");
        if (staticAttribute != null) {
            sb.append("static ");
        }
        if (!((parentElement = (PoshiElement)this.getParent()) instanceof ExecutePoshiElement)) {
            sb.append(this.getName());
            sb.append(" ");
        }
        if (Validator.isNotNull(this.valueAttributeName) && this.valueAttributeName.equals("from") && this.attribute("type") != null) {
            sb.append(this.attributeValue("type"));
            sb.append(" ");
        }
        String name = this.attributeValue("name");
        sb.append(name);
        sb.append(" = ");
        String value = this.getVarValue();
        if (Validator.isNotNull(this.valueAttributeName)) {
            if (this.valueAttributeName.equals("from")) {
                if (this.attribute("hash") != null) {
                    String innerValue = this.getBracedContent(value);
                    String newInnerValue = StringUtil.combine(innerValue, ".hash('", this.attributeValue("hash"), "')");
                    value = StringUtil.replace(value, innerValue, newInnerValue);
                    value = this.doubleQuoteContent(value);
                } else if (this.attribute("index") != null) {
                    String innerValue = this.getBracedContent(value);
                    String newInnerValue = StringUtil.combine(innerValue, "[", this.attributeValue("index"), "]");
                    value = StringUtil.replace(value, innerValue, newInnerValue);
                    value = this.doubleQuoteContent(value);
                } else if (this.attribute("type") != null) {
                    value = StringUtil.combine("new ", this.attributeValue("type"), "(\"", value, "\")");
                }
            } else if (this.valueAttributeName.equals("method")) {
                String content;
                if ((!this.isValidFunctionFileName(value) && !this.isValidMacroFileName(value) || value.startsWith("selenium#")) && !(content = this.getParentheticalContent(value = value.replaceFirst("#", "."))).equals("")) {
                    Matcher matcher = _mathUtilMethodCallPattern.matcher(value);
                    String mathOperator = "";
                    if (matcher.find()) {
                        for (Map.Entry<String, String> entry : _mathOperatorsMap.entrySet()) {
                            if (!Objects.equals(entry.getValue(), matcher.group(1))) continue;
                            mathOperator = " " + entry.getKey() + " ";
                            break;
                        }
                    }
                    value = !mathOperator.equals("") && !(parentElement instanceof ExecutePoshiElement) ? matcher.group(2) + mathOperator + matcher.group(3) : StringUtil.replace(value, content, this.swapParameterQuotations(content, true));
                }
            } else {
                value = StringUtil.replace(value, "\"", "\\\"");
                String elementName = this.getName();
                if (this.isDoubleQuotedVar(value) || elementName.equals("property")) {
                    value = this.doubleQuoteContent(value);
                }
            }
        }
        sb.append(value);
        if (!(parentElement instanceof ExecutePoshiElement)) {
            sb.append(";");
        }
        return sb.toString();
    }

    protected VarPoshiElement() {
        this(_ELEMENT_NAME);
    }

    protected VarPoshiElement(Element element) {
        this(_ELEMENT_NAME, element);
    }

    protected VarPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this(_ELEMENT_NAME, attributes, nodes);
    }

    protected VarPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        this(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    protected VarPoshiElement(String name) {
        super(name);
    }

    protected VarPoshiElement(String name, Element element) {
        super(name, element);
        if (this.isElementType(name, element)) {
            this.initValueAttributeName(element);
        }
    }

    protected VarPoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected VarPoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    @Override
    protected String getBlockName() {
        return null;
    }

    @Override
    protected Pattern getStatementPattern() {
        return _statementPattern;
    }

    protected void initValueAttributeName(Element element) {
        if (element.attribute("from") != null) {
            this.valueAttributeName = "from";
            return;
        }
        if (element.attribute("method") != null) {
            this.valueAttributeName = "method";
            return;
        }
        if (element.attribute("value") != null) {
            this.valueAttributeName = "value";
            return;
        }
        if (this.getText() != null) {
            return;
        }
        try {
            throw new IllegalArgumentException("Invalid variable element " + Dom4JUtil.format(element));
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Invalid variable element", ioException);
        }
    }

    protected String swapParameterQuotations(String parametersString, boolean toScript) {
        StringBuilder sb = new StringBuilder();
        parametersString = parametersString.trim();
        List<String> methodParameterValues = PoshiScriptParserUtil.getMethodParameterValues(parametersString, this);
        for (String methodParameterValue : methodParameterValues) {
            if ((methodParameterValue = methodParameterValue.trim()).endsWith("'") && methodParameterValue.startsWith("'")) {
                methodParameterValue = this.getSingleQuotedContent(methodParameterValue);
                methodParameterValue = StringUtil.replace(methodParameterValue, "\\'", "'");
                methodParameterValue = StringUtil.replace(methodParameterValue, "&quot;", "\"");
                if (this.isQuotedContent(methodParameterValue = StringUtil.replace(methodParameterValue, "\"", "\\\"")) && toScript) {
                    methodParameterValue = this.doubleQuoteContent(methodParameterValue);
                }
            } else if (methodParameterValue.endsWith("\"") && methodParameterValue.startsWith("\"")) {
                methodParameterValue = this.getDoubleQuotedContent(methodParameterValue);
                methodParameterValue = StringUtil.replace(methodParameterValue, "'", "\\'");
                methodParameterValue = StringUtil.replace(methodParameterValue, "\\\"", "\"");
                methodParameterValue = this.singleQuoteContent(methodParameterValue);
            } else {
                if (!toScript) {
                    methodParameterValue = this.singleQuoteContent(methodParameterValue);
                }
                methodParameterValue = methodParameterValue.trim();
            }
            sb.append(methodParameterValue);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    private boolean _isElementType(String poshiScript) {
        if (this.isVarAssignedToMacroInvocation(poshiScript)) {
            return false;
        }
        return this.isValidPoshiScriptStatement(_partialStatementPattern, poshiScript);
    }

    static {
        _mathOperatorsMap = new HashMap<String, String>(){
            {
                this.put("*", "product");
                this.put("+", "sum");
                this.put("-", "difference");
                this.put("/", "quotient");
            }
        };
        _mathUtilMethodCallPattern = Pattern.compile("MathUtil\\.(\\w+)\\('(.+)', '(.+)'\\)");
        _nestedCDATAPattern = Pattern.compile("(?<cdata1><.+]])(?<cdata2>>.*>?)");
        _VAR_VALUE_MATH_EXPRESSION_REGEX = "[\\s]*(\\$\\{[\\w]*\\}|[\\d]*)[\\s]*([\\+\\-\\*\\/])[\\s]*(\\$\\{[\\w]*\\}|[\\d]*)[\\s]*";
        _VAR_VALUE_REGEX = StringUtil.combine("(", _VAR_VALUE_STRING_REGEX, "|", _VAR_VALUE_MATH_EXPRESSION_REGEX, "|", _VAR_VALUE_INTEGER_REGEX, "|", _VAR_VALUE_MULTILINE_REGEX, "|", _VAR_VALUE_OBJECT_REGEX, "|", _VAR_VALUE_VARIABLE_REGEX, ")");
        _statementPattern = Pattern.compile("^((static[\\s]*|)var|)([\\s]*[A-Z][\\w]*|)[\\s]*[\\w]*[\\s]*=[\\s]*" + _VAR_VALUE_REGEX + "(;|)$", 40);
        _partialStatementPattern = Pattern.compile("^((static[\\s]*|)var|)([\\s]*[A-Z][\\w]*|)[\\s]*[\\w]*[\\s]*=[\\s]*" + _VAR_VALUE_REGEX, 32);
        _varValueMathExpressionPattern = Pattern.compile(_VAR_VALUE_MATH_EXPRESSION_REGEX);
    }
}

