/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;

public class CapsNameCheck
extends BaseCheck {
    private static final String[][] _ALL_CAPS_STRINGS = new String[][]{{"DDL", "Ddl"}, {"DDM", "Ddm"}, {"DL", "Dl"}, {"JAAS", "Jaas"}, {"PK", "Pk"}};
    private static final String _MSG_RENAME = "rename";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15, 9, 21, 178, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 9) {
            if (AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
                return;
            }
            String absolutePath = this.getAbsolutePath();
            if (absolutePath.contains("/taglib/") && absolutePath.endsWith("Tag.java")) {
                return;
            }
        }
        String name = this.getName(detailAST);
        String tokenTypeName = this.getTokenTypeName(detailAST);
        for (String[] array : _ALL_CAPS_STRINGS) {
            String s = array[1];
            int x = -1;
            while ((x = name.indexOf(s, x + 1)) != -1) {
                int y = x + s.length();
                if (y != name.length() && !Character.isUpperCase(name.charAt(y))) continue;
                String newName = name.substring(0, x) + array[0] + name.substring(y);
                this.log(detailAST, _MSG_RENAME, new Object[]{tokenTypeName, name, newName});
            }
        }
    }
}

