/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.util.GradleDependency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;

public class GradleBuildFileVisitor
extends CodeVisitorSupport {
    private final Stack<Boolean> _blockStatementStack = new Stack();
    private final List<GradleDependency> _buildScriptDependencies = new ArrayList<GradleDependency>();
    private int _buildScriptLastLineNumber = -1;
    private String _configuration;
    private int _dependenciesLastLineNumber = -1;
    private int _dependenciesLineNumber = -1;
    private final List<GradleDependency> _gradleDependencies = new ArrayList<GradleDependency>();
    private boolean _inBuildScript;
    private boolean _inDependencies;
    private int _methodCallLastLineNumber = -1;
    private int _methodCallLineNumber = -1;

    public List<GradleDependency> getBuildScriptDependencies() {
        return this._buildScriptDependencies;
    }

    public int getDependenciesLastLineNumber() {
        return this._dependenciesLastLineNumber;
    }

    public int getDependenciesLineNumber() {
        return this._dependenciesLineNumber;
    }

    public List<GradleDependency> getGradleDependencies() {
        return this._gradleDependencies;
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression argumentListExpression) {
        ConstantExpression constantExpression;
        String text;
        String[] textParts;
        if (!this._inDependencies && !this._inBuildScript) {
            return;
        }
        List<Expression> expressions = argumentListExpression.getExpressions();
        if (expressions.size() == 1 && expressions.get(0) instanceof ConstantExpression && (textParts = (text = (constantExpression = (ConstantExpression)expressions.get(0)).getText()).split(":")).length >= 3 && this._inDependencies) {
            GradleDependency gradleDependency = new GradleDependency(this._configuration, textParts[0], textParts[1], textParts[2], this._methodCallLineNumber, this._methodCallLastLineNumber);
            if (this._inBuildScript) {
                this._buildScriptDependencies.add(gradleDependency);
            } else {
                this._gradleDependencies.add(gradleDependency);
            }
        }
        super.visitArgumentlistExpression(argumentListExpression);
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) {
        if (this._inDependencies) {
            this._blockStatementStack.push(true);
            super.visitBlockStatement(blockStatement);
            this._blockStatementStack.pop();
        } else {
            super.visitBlockStatement(blockStatement);
        }
    }

    @Override
    public void visitMapExpression(MapExpression mapExpression) {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        boolean gav = false;
        for (MapEntryExpression mapEntryExpression : mapExpression.getMapEntryExpressions()) {
            Expression keyExpression = mapEntryExpression.getKeyExpression();
            String key = keyExpression.getText();
            Expression valueExpression = mapEntryExpression.getValueExpression();
            String value = valueExpression.getText();
            if (StringUtil.equalsIgnoreCase(key, "group")) {
                gav = true;
            }
            keyValues.put(key, value);
        }
        if (gav && this._inDependencies) {
            GradleDependency gradleDependency = new GradleDependency(this._configuration, (String)keyValues.get("group"), (String)keyValues.get("name"), (String)keyValues.get("version"), this._methodCallLineNumber, this._methodCallLastLineNumber);
            if (this._inBuildScript) {
                this._buildScriptDependencies.add(gradleDependency);
            } else {
                this._gradleDependencies.add(gradleDependency);
            }
        }
        super.visitMapExpression(mapExpression);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        String methodName;
        this._methodCallLineNumber = methodCallExpression.getLineNumber();
        this._methodCallLastLineNumber = methodCallExpression.getLastLineNumber();
        if (this._methodCallLineNumber > this._buildScriptLastLineNumber) {
            this._inBuildScript = false;
        }
        if (this._methodCallLineNumber > this._dependenciesLastLineNumber) {
            this._inDependencies = false;
        }
        if ((methodName = methodCallExpression.getMethodAsString()).equals("buildscript")) {
            this._inBuildScript = true;
            this._buildScriptLastLineNumber = methodCallExpression.getLastLineNumber();
        }
        if (methodName.equals("dependencies")) {
            this._inDependencies = true;
            this._dependenciesLineNumber = methodCallExpression.getLineNumber();
            this._dependenciesLastLineNumber = methodCallExpression.getLastLineNumber();
        }
        if (this._inDependencies && !this._blockStatementStack.isEmpty() && this._blockStatementStack.peek().booleanValue()) {
            this._configuration = methodName;
        }
        super.visitMethodCallExpression(methodCallExpression);
    }
}

