/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.util.PortalJSONObjectUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BaseAPICheck
extends BaseCheck {
    private final Map<String, JSONObject> _javaClassesJSONObjectMap = new HashMap<String, JSONObject>();

    protected Map<String, Set<Integer>> addTypeName(Map<String, Set<Integer>> typeNamesMap, String typeName, int lineNumber) {
        return this._addTypeName(typeNamesMap, typeName, lineNumber, null);
    }

    protected List<ConstructorCall> getConstructorCalls(DetailAST detailAST, List<String> excludeImportNames, boolean skipDeprecated) {
        ArrayList<ConstructorCall> constructorCalls = new ArrayList<ConstructorCall>();
        List<DetailAST> literalNewDetailASTList = this.getAllChildTokens(detailAST, true, 136);
        for (DetailAST literalNewDetailAST : literalNewDetailASTList) {
            String constructorTypeName;
            DetailAST lparenDetailAST;
            if (skipDeprecated && (this.hasDeprecatedParent(literalNewDetailAST) || this.hasSuppressDeprecationWarningsAnnotation(literalNewDetailAST)) || (lparenDetailAST = literalNewDetailAST.findFirstToken(76)) == null || (constructorTypeName = this._getConstructorTypeName(literalNewDetailAST)) == null || !constructorTypeName.startsWith("com.liferay.") || excludeImportNames.contains(constructorTypeName)) continue;
            constructorCalls.add(new ConstructorCall(constructorTypeName, this._getParameterTypeNames(literalNewDetailAST), literalNewDetailAST.getLineNo()));
        }
        return constructorCalls;
    }

    protected List<JSONObject> getConstructorJSONObjects(ConstructorCall constructorCall, JSONObject javaClassesJSONObject) {
        ArrayList<JSONObject> constructorJSONObjects = new ArrayList<JSONObject>();
        JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(constructorCall.getTypeName());
        if (classJSONObject == null) {
            return constructorJSONObjects;
        }
        JSONArray constructorsJSONArray = classJSONObject.getJSONArray("constructors");
        if (constructorsJSONArray == null) {
            return constructorJSONObjects;
        }
        List<String> parameterTypeNames = constructorCall.getParameterTypeNames();
        block0: for (JSONObject constructorJSONObject : constructorsJSONArray) {
            JSONArray parametersJSONArray = constructorJSONObject.getJSONArray("parameters");
            if (parametersJSONArray == null) {
                if (!parameterTypeNames.isEmpty()) continue;
                constructorJSONObjects.add(constructorJSONObject);
                continue;
            }
            if (parametersJSONArray.length() != parameterTypeNames.size()) continue;
            for (int i = 0; i < parameterTypeNames.size(); ++i) {
                String actualTypeName = parameterTypeNames.get(i);
                String methodTypeName = parametersJSONArray.getString(i);
                if (Validator.isNotNull(actualTypeName) && !StringUtil.equalsIgnoreCase(actualTypeName, methodTypeName) && !methodTypeName.equals("Object") && (!this._isNumeric(actualTypeName) || !this._isNumeric(methodTypeName))) continue block0;
            }
            constructorJSONObjects.add(constructorJSONObject);
        }
        return constructorJSONObjects;
    }

    protected synchronized JSONObject getJavaClassesJSONObject(String version) throws Exception {
        JSONObject javaClassesJSONObject = this._javaClassesJSONObjectMap.get(version);
        if (javaClassesJSONObject != null) {
            return javaClassesJSONObject;
        }
        JSONObject portalJSONObject = null;
        portalJSONObject = version.equals(this.getBaseDirName()) ? PortalJSONObjectUtil.getPortalJSONObject(version) : PortalJSONObjectUtil.getPortalJSONObjectByVersion(version);
        javaClassesJSONObject = portalJSONObject.has("javaClasses") ? portalJSONObject.getJSONObject("javaClasses") : new JSONObjectImpl();
        this._javaClassesJSONObjectMap.put(version, javaClassesJSONObject);
        return javaClassesJSONObject;
    }

    protected List<MethodCall> getMethodCalls(DetailAST detailAST, List<String> excludeImportNames, boolean skipDeprecated) {
        ArrayList<MethodCall> methodCalls = new ArrayList<MethodCall>();
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            if (skipDeprecated && (this.hasDeprecatedParent(methodCallDetailAST) || this.hasSuppressDeprecationWarningsAnnotation(methodCallDetailAST))) continue;
            String methodName = null;
            String variableTypeName = null;
            DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 58) {
                methodName = firstChildDetailAST.getText();
                variableTypeName = StringBundler.concat(this.getPackageName(detailAST), ".", JavaSourceUtil.getClassName(this.getAbsolutePath()));
            } else {
                if (firstChildDetailAST.getType() != 59) continue;
                DetailAST firstGrandChildDetailAST = firstChildDetailAST.getFirstChild();
                DetailAST lastGrandChildDetailAST = firstChildDetailAST.getLastChild();
                if (firstGrandChildDetailAST.getType() != 58 || lastGrandChildDetailAST.getType() != 58) continue;
                methodName = lastGrandChildDetailAST.getText();
                variableTypeName = this.getVariableTypeName(firstChildDetailAST, firstGrandChildDetailAST.getText(), false, false, true);
            }
            if (!variableTypeName.startsWith("com.liferay.") || excludeImportNames.contains(variableTypeName)) continue;
            methodCalls.add(new MethodCall(methodName, variableTypeName, this._getParameterTypeNames(methodCallDetailAST), methodCallDetailAST.getLineNo()));
        }
        return methodCalls;
    }

    protected List<JSONObject> getMethodJSONObjects(MethodCall methodCall, JSONObject javaClassesJSONObject) {
        JSONArray extendedClassNamesJSONArray;
        ArrayList<JSONObject> methodJSONObjects = new ArrayList<JSONObject>();
        JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(methodCall.getVariableTypeName());
        if (classJSONObject == null) {
            return methodJSONObjects;
        }
        JSONArray methodsJSONArray = classJSONObject.getJSONArray("methods");
        if (methodsJSONArray != null) {
            String methodName = methodCall.getName();
            List<String> parameterTypeNames = methodCall.getParameterTypeNames();
            block0: for (JSONObject methodJSONObject : methodsJSONArray) {
                if (!methodName.equals(methodJSONObject.getString("name"))) continue;
                JSONArray parametersJSONArray = methodJSONObject.getJSONArray("parameters");
                if (parametersJSONArray == null) {
                    if (!parameterTypeNames.isEmpty()) continue;
                    methodJSONObjects.add(methodJSONObject);
                    continue;
                }
                if (parametersJSONArray.length() != parameterTypeNames.size()) continue;
                for (int i = 0; i < parameterTypeNames.size(); ++i) {
                    String actualTypeName = parameterTypeNames.get(i);
                    String methodTypeName = parametersJSONArray.getString(i);
                    if (Validator.isNotNull(actualTypeName) && !StringUtil.equalsIgnoreCase(actualTypeName, methodTypeName) && !methodTypeName.equals("Object") && (!this._isNumeric(actualTypeName) || !this._isNumeric(methodTypeName))) continue block0;
                }
                methodJSONObjects.add(methodJSONObject);
            }
        }
        if ((extendedClassNamesJSONArray = classJSONObject.getJSONArray("extendedClassNames")) != null) {
            for (String extendedClassName : extendedClassNamesJSONArray) {
                if (!extendedClassName.startsWith("com.liferay.")) continue;
                methodJSONObjects.addAll(this.getMethodJSONObjects(new MethodCall(methodCall.getName(), extendedClassName, methodCall.getParameterTypeNames(), methodCall.getLineNumber()), javaClassesJSONObject));
            }
        }
        return methodJSONObjects;
    }

    protected Map<String, Set<Integer>> getTypeNamesMap(DetailAST detailAST, List<String> excludeImportNames, boolean skipDeprecated) {
        Map<String, Set<Integer>> typeNamesMap = new HashMap<String, Set<Integer>>();
        List<DetailAST> clauseDetailASTList = this.getAllChildTokens(detailAST, true, 18, 19);
        for (DetailAST clauseDetailAST : clauseDetailASTList) {
            if (skipDeprecated && (this.hasDeprecatedParent(clauseDetailAST) || this.hasSuppressDeprecationWarningsAnnotation(clauseDetailAST))) continue;
            List<DetailAST> childDetailASTList = this.getAllChildTokens(clauseDetailAST, false, 59, 58);
            for (DetailAST childDetailAST : childDetailASTList) {
                if (childDetailAST.getType() == 58) {
                    typeNamesMap = this._addTypeName(typeNamesMap, this.getVariableTypeName(childDetailAST, childDetailAST.getText(), false, false, true), childDetailAST.getLineNo(), excludeImportNames);
                    continue;
                }
                DetailAST firstChildDetailAST = childDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() == 58) {
                    typeNamesMap = this._addTypeName(typeNamesMap, this.getVariableTypeName(firstChildDetailAST, firstChildDetailAST.getText(), false, false, true), firstChildDetailAST.getLineNo(), excludeImportNames);
                    continue;
                }
                FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)childDetailAST);
                typeNamesMap = this._addTypeName(typeNamesMap, fullIdent.getText(), firstChildDetailAST.getLineNo(), excludeImportNames);
            }
        }
        List<DetailAST> typeDetailASTList = this.getAllChildTokens(detailAST, true, 13);
        for (DetailAST typeDetailAST : typeDetailASTList) {
            if (skipDeprecated && (this.hasDeprecatedParent(typeDetailAST) || this.hasSuppressDeprecationWarningsAnnotation(typeDetailAST))) continue;
            typeNamesMap = this._addTypeName(typeNamesMap, this.getTypeName(typeDetailAST, false, false, true), typeDetailAST.getLineNo(), excludeImportNames);
        }
        return typeNamesMap;
    }

    protected List<VariableCall> getVariableCalls(DetailAST detailAST, List<String> excludeImportNames, boolean skipDeprecated) {
        ArrayList<VariableCall> variableCalls = new ArrayList<VariableCall>();
        List<DetailAST> dotDetailASTList = this.getAllChildTokens(detailAST, true, 59);
        for (DetailAST dotDetailAST : dotDetailASTList) {
            String variableTypeName;
            if (skipDeprecated && (this.hasDeprecatedParent(dotDetailAST) || this.hasSuppressDeprecationWarningsAnnotation(dotDetailAST))) continue;
            DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
            DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
            if (firstChildDetailAST.getType() != 58 || lastChildDetailAST.getType() != 58 || !(variableTypeName = this.getVariableTypeName(firstChildDetailAST, firstChildDetailAST.getText(), false, false, true)).startsWith("com.liferay.") || excludeImportNames.contains(variableTypeName)) continue;
            variableCalls.add(new VariableCall(lastChildDetailAST.getText(), variableTypeName, lastChildDetailAST.getLineNo()));
        }
        return variableCalls;
    }

    protected JSONObject getVariableJSONObject(VariableCall variableCall, JSONObject javaClassesJSONObject) {
        JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(variableCall.getTypeName());
        if (classJSONObject == null) {
            return null;
        }
        JSONArray variablesJSONArray = classJSONObject.getJSONArray("variables");
        if (variablesJSONArray == null) {
            return null;
        }
        for (JSONObject variableJSONObject : variablesJSONArray) {
            if (!Objects.equals(variableCall.getName(), variableJSONObject.getString("name"))) continue;
            return variableJSONObject;
        }
        return null;
    }

    protected boolean hasDeprecatedParent(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if ((parentDetailAST.getType() == 8 || parentDetailAST.getType() == 9 || parentDetailAST.getType() == 10) && AnnotationUtil.containsAnnotation((DetailAST)parentDetailAST, (String)"Deprecated")) {
                return true;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }

    protected boolean hasSuppressDeprecationWarningsAnnotation(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            DetailAST annotationDetailAST;
            if (parentDetailAST.findFirstToken(5) != null && (annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)parentDetailAST, (String)"SuppressWarnings")) != null) {
                List<DetailAST> literalStringDetailASTList = this.getAllChildTokens(annotationDetailAST, true, 139);
                for (DetailAST literalStringDetailAST : literalStringDetailASTList) {
                    String s = literalStringDetailAST.getText();
                    if (!s.equals("\"deprecation\"")) continue;
                    return true;
                }
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }

    private Map<String, Set<Integer>> _addTypeName(Map<String, Set<Integer>> typeNamesMap, String typeName, int lineNumber, List<String> excludeImportNames) {
        if (excludeImportNames != null && (excludeImportNames.contains(typeName) || !typeName.startsWith("com.liferay."))) {
            return typeNamesMap;
        }
        Set<Integer> lineNumbers = typeNamesMap.get(typeName);
        if (lineNumbers == null) {
            lineNumbers = new HashSet<Integer>();
        }
        lineNumbers.add(lineNumber);
        typeNamesMap.put(typeName, lineNumbers);
        return typeNamesMap;
    }

    private String _getConstructorTypeName(DetailAST literalNewDetailAST) {
        DetailAST identDetailAST = literalNewDetailAST.findFirstToken(58);
        if (identDetailAST != null) {
            return StringBundler.concat(JavaSourceUtil.getPackageName(identDetailAST.getText(), this.getPackageName(identDetailAST), this.getImportNames(identDetailAST)), ".", identDetailAST.getText());
        }
        DetailAST dotDetailAST = literalNewDetailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return null;
        }
        identDetailAST = dotDetailAST.findFirstToken(58);
        if (identDetailAST != null) {
            return StringBundler.concat(JavaSourceUtil.getPackageName(identDetailAST.getText(), this.getPackageName(identDetailAST), this.getImportNames(identDetailAST)), ".", identDetailAST.getText());
        }
        return null;
    }

    private String _getParameterTypeName(DetailAST detailAST) {
        if (detailAST.getType() == 58) {
            return this.getVariableTypeName(detailAST, detailAST.getText(), true, true, true);
        }
        if (detailAST.getType() == 139) {
            return "java.lang.String";
        }
        if (detailAST.getType() == 138) {
            return "char";
        }
        if (detailAST.getType() == 134 || detailAST.getType() == 133 || detailAST.getType() == 132) {
            return "boolean";
        }
        if (detailAST.getType() == 125) {
            DetailAST stringLiteralDetailAST = detailAST.findFirstToken(139);
            if (stringLiteralDetailAST != null) {
                return "java.lang.String";
            }
            return null;
        }
        if (detailAST.getType() == 136) {
            String parameterTypeName = null;
            DetailAST firstChildDetailAST = detailAST.getFirstChild();
            parameterTypeName = firstChildDetailAST.getType() == 58 ? this.getVariableTypeName(firstChildDetailAST, firstChildDetailAST.getText(), true, true, true) : this._getParameterTypeName(firstChildDetailAST);
            if (parameterTypeName == null) {
                return parameterTypeName;
            }
            DetailAST curDetailAST = firstChildDetailAST.getNextSibling();
            while (true) {
                if (curDetailAST.getType() != 17) {
                    return parameterTypeName;
                }
                parameterTypeName = parameterTypeName + "[]";
                curDetailAST = curDetailAST.getFirstChild();
            }
        }
        if (detailAST.getType() == 24) {
            String parameterTypeName = this._getParameterTypeName(detailAST.getFirstChild());
            if (parameterTypeName != null) {
                parameterTypeName = StringUtil.replaceLast(parameterTypeName, "[]", "");
            }
            return parameterTypeName;
        }
        if (detailAST.getType() == 23) {
            return this.getTypeName(detailAST, true, true, true);
        }
        if (ArrayUtil.contains(UNARY_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            return this._getParameterTypeName(detailAST.getFirstChild());
        }
        if (detailAST.getType() == 78) {
            DetailAST parentDetailAST = this.getParentWithTokenType(detailAST, 14);
            if (parentDetailAST == null) {
                return null;
            }
            DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
            return identDetailAST.getText();
        }
        if (ArrayUtil.contains(CONDITIONAL_OPERATOR_TOKEN_TYPES, detailAST.getType()) || ArrayUtil.contains(RELATIONAL_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            return "boolean";
        }
        if (detailAST.getType() == 142) {
            return "double";
        }
        if (detailAST.getType() == 140) {
            return "float";
        }
        if (detailAST.getType() == 137) {
            return "int";
        }
        if (detailAST.getType() == 141) {
            return "long";
        }
        if (detailAST.getType() == 50 || detailAST.getType() == 51 || detailAST.getType() == 57 || detailAST.getType() == 55 || detailAST.getType() == 54 || detailAST.getType() == 56 || detailAST.getType() == 53) {
            return detailAST.getText();
        }
        if (detailAST.getType() == 109) {
            return this._getParameterTypeName(detailAST.getLastChild());
        }
        return null;
    }

    private List<String> _getParameterTypeNames(DetailAST detailAST) {
        ArrayList<String> parameterTypeNames = new ArrayList<String>();
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            parameterTypeNames.add(this._getParameterTypeName(exprDetailAST.getFirstChild()));
        }
        return parameterTypeNames;
    }

    private boolean _isNumeric(String typeName) {
        return typeName.equals("double") || typeName.equals("float") || typeName.equals("int") || typeName.equals("long");
    }

    protected class ConstructorCall {
        private int _lineNumber;
        private final List<String> _parameterTypeNames;
        private final String _typeName;

        public ConstructorCall(String typeName, List<String> parameterTypeNames, int lineNumber) {
            this._typeName = typeName;
            this._parameterTypeNames = parameterTypeNames;
            this._lineNumber = lineNumber;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public List<String> getParameterTypeNames() {
            return this._parameterTypeNames;
        }

        public String getTypeName() {
            return this._typeName;
        }
    }

    protected class MethodCall {
        private int _lineNumber;
        private final String _name;
        private final List<String> _parameterTypeNames;
        private final String _variableTypeName;

        public MethodCall(String name, String variableTypeName, List<String> parameterTypeNames, int lineNumber) {
            this._name = name;
            this._variableTypeName = variableTypeName;
            this._parameterTypeNames = parameterTypeNames;
            this._lineNumber = lineNumber;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public String getName() {
            return this._name;
        }

        public List<String> getParameterTypeNames() {
            return this._parameterTypeNames;
        }

        public String getVariableTypeName() {
            return this._variableTypeName;
        }
    }

    protected class VariableCall {
        private int _lineNumber;
        private final String _name;
        private final String _typeName;

        public VariableCall(String name, String typeName, int lineNumber) {
            this._name = name;
            this._typeName = typeName;
            this._lineNumber = lineNumber;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public String getName() {
            return this._name;
        }

        public String getTypeName() {
            return this._typeName;
        }
    }
}

