/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableNameCheck
extends BaseCheck {
    protected static final String MSG_RENAME_VARIABLE = "variable.rename";
    private static final String _ALLOWED_VARIABLE_NAMES_KEY = "allowedVariableNames";
    private static final String _ENFORCE_SHORT_TYPE_NAMES_KEY = "enforceShortTypeNames";
    private static final String _ENFORCE_TABLE_SCHEMA_FIELD_TYPE_NAMES_KEY = "enforceTableSchemaFieldTypeNames";
    private static final String _ENFORCE_TYPE_NAMES_KEY = "enforceTypeNames";
    private static final String _MSG_INCORRECT_COUNT_VARIABLE = "variable.incorrect.count";
    private static final String _MSG_INCORRECT_ENDING_VARIABLE = "variable.incorrect.ending";
    private static final String _MSG_INCORRECT_NAME_FOR_STATEMENT = "variable.name.incorrect.for.statement";
    private static final String _MSG_TYPO_VARIABLE = "variable.typo";
    private static final Pattern _camelCaseNamePattern = Pattern.compile("[a-z][A-Z](?=[a-z])");
    private static final Pattern _classNameVariableNamePattern = Pattern.compile("^_(.+)_CLASS_NAME$");
    private static final Pattern _countVariableNamePattern = Pattern.compile("^(\\w+?)([1-9][0-9]*)$");
    private static final Pattern _isVariableNamePattern = Pattern.compile("^(_?)(is|IS_)([A-Z])(.*)");

    public int[] getDefaultTokens() {
        return new int[]{21, 178, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST;
        if (detailAST.findFirstToken(171) != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String name = this._getVariableName(detailAST);
        if (detailAST.getType() == 10) {
            this._checkClassNameVariable(detailAST, name);
            this._checkTypo(detailAST, name);
        }
        this._checkIsVariableName(detailAST, name);
        DetailAST typeDetailAST = detailAST.findFirstToken(13);
        DetailAST firstChildDetailAST = typeDetailAST.getFirstChild();
        if (firstChildDetailAST == null) {
            return;
        }
        String typeName = this.getTypeName(typeDetailAST, false);
        if (!typeName.contains("[")) {
            if (firstChildDetailAST.getType() != 59) {
                this._checkCountVariableName(detailAST, name, typeName);
                this._checkInstanceVariableName(detailAST, name, typeName);
                this._checkTypeName(detailAST, name, typeName);
                this._checkTypo(detailAST, name, typeName, true);
            }
            this._checkExceptionVariableName(detailAST, name, typeName);
        }
        if ((parentDetailAST = this.getParentWithTokenType(detailAST, 14, 8, 9)) == null) {
            return;
        }
        List<DetailAST> assignDetailASTList = this.getAllChildTokens(parentDetailAST, true, 80);
        for (DetailAST assignDetailAST : assignDetailASTList) {
            DetailAST nextSiblingDetailAST;
            firstChildDetailAST = assignDetailAST.getFirstChild();
            if (firstChildDetailAST == null) continue;
            String methodName = "";
            if (this.equals(assignDetailAST.getParent(), detailAST)) {
                if (firstChildDetailAST.getType() != 28) continue;
                if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 27 && (methodName = this.getMethodName(firstChildDetailAST)).equals("stream") && (firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 59) {
                    firstChildDetailAST = firstChildDetailAST.getFirstChild();
                    this._checkTypo(detailAST, name, firstChildDetailAST.getText() + "Stream", false);
                }
            } else if (firstChildDetailAST.getType() == 58 && name.equals(firstChildDetailAST.getText()) && (nextSiblingDetailAST = firstChildDetailAST.getNextSibling()).getType() == 27) {
                methodName = this.getMethodName(nextSiblingDetailAST);
            }
            if (!methodName.matches("get[A-Z].*")) continue;
            this._checkTypo(detailAST, name, methodName.substring(3), false);
        }
    }

    protected String getExpectedVariableName(String typeName) {
        if (StringUtil.isUpperCase(typeName) || typeName.matches("[A-Z]+s")) {
            return StringUtil.toLowerCase(typeName);
        }
        if (typeName.startsWith("IDf")) {
            return StringUtil.replaceFirst(typeName, "IDf", "idf");
        }
        if (typeName.startsWith("OSGi")) {
            return StringUtil.replaceFirst(typeName, "OSGi", "osgi");
        }
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            if (i == 0) {
                return typeName;
            }
            if (i == 1) {
                return StringUtil.toLowerCase(typeName.substring(0, 1)) + typeName.substring(1);
            }
            return StringUtil.toLowerCase(typeName.substring(0, i - 1)) + typeName.substring(i - 1);
        }
        return StringUtil.toLowerCase(typeName);
    }

    private void _checkClassNameVariable(DetailAST detailAST, String variableName) {
        Matcher matcher = _classNameVariableNamePattern.matcher(variableName);
        if (!matcher.find()) {
            return;
        }
        String match = matcher.group(1);
        String className = StringUtil.removeChar(match, '_');
        List<DetailAST> valueDetailASTList = this.getAllChildTokens(detailAST, true, 58, 139);
        for (DetailAST valueDetailAST : valueDetailASTList) {
            String value = StringUtil.removeChar(valueDetailAST.getText(), '\"');
            if (!value.matches("(?i)(.*\\.)?" + className)) continue;
            this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{variableName, "_CLASS_NAME_" + match});
            return;
        }
    }

    private void _checkCountVariableName(DetailAST detailAST, String name, String typeName) {
        DetailAST slistDetailAST;
        Matcher matcher = _countVariableNamePattern.matcher(name);
        if (!matcher.find()) {
            return;
        }
        String countlessVariableName = matcher.group(1);
        matcher = _countVariableNamePattern.matcher(typeName);
        if (matcher.find()) {
            return;
        }
        TreeSet<DetailAST> detailASTSet = new TreeSet<DetailAST>(new Comparator<DetailAST>(){

            @Override
            public int compare(DetailAST detailAST1, DetailAST detailAST2) {
                return detailAST1.getLineNo() - detailAST2.getLineNo();
            }
        });
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() == 6) {
            detailASTSet.addAll(this.getAllChildTokens(parentDetailAST, false, 10));
        } else {
            if (parentDetailAST.getType() == 7) {
                detailASTSet.addAll(this.getAllChildTokens(parentDetailAST, false, 10));
            } else if (parentDetailAST.getType() == 177) {
                DetailAST slistDetailAST2;
                detailASTSet.addAll(this.getAllChildTokens(parentDetailAST, false, 178));
                parentDetailAST = parentDetailAST.getParent();
                parentDetailAST = parentDetailAST.getParent();
                if (parentDetailAST.getType() == 95 && (slistDetailAST2 = parentDetailAST.findFirstToken(7)) != null) {
                    detailASTSet.addAll(this.getAllChildTokens(slistDetailAST2, false, 10));
                }
            }
            parentDetailAST = this.getParentWithTokenType(detailAST, 8, 9);
            if (parentDetailAST != null) {
                DetailAST parametersDetailAST = parentDetailAST.findFirstToken(20);
                detailASTSet.addAll(this.getAllChildTokens(parametersDetailAST, false, 21));
                slistDetailAST = parentDetailAST.findFirstToken(7);
                if (slistDetailAST != null) {
                    detailASTSet.addAll(this.getAllChildTokens(slistDetailAST, false, 10));
                }
            }
        }
        int endLineNumber = -1;
        slistDetailAST = this.getParentWithTokenType(detailAST, 7);
        if (slistDetailAST != null) {
            endLineNumber = this.getEndLineNumber(slistDetailAST);
        }
        String expectedVariableName = countlessVariableName + "1";
        for (DetailAST curDetailAST : detailASTSet) {
            if (endLineNumber != -1 && curDetailAST.getLineNo() > endLineNumber) break;
            String variableName = this._getVariableName(curDetailAST);
            if (variableName.equals(countlessVariableName)) {
                parentDetailAST = detailAST.getParent();
                if (parentDetailAST.getType() == 156) {
                    DetailAST curNameDetailAST = this._getDetailAST(detailASTSet, "cur" + countlessVariableName);
                    if (curNameDetailAST != null) continue;
                    this.log(detailAST, _MSG_INCORRECT_NAME_FOR_STATEMENT, new Object[]{name});
                    continue;
                }
                if (curDetailAST.getType() == 21) {
                    return;
                }
                DetailAST expectedVariableNameDetailAST = this._getDetailAST(detailASTSet, expectedVariableName);
                if (expectedVariableNameDetailAST == null) {
                    this.log(curDetailAST, MSG_RENAME_VARIABLE, new Object[]{countlessVariableName, expectedVariableName});
                    continue;
                }
                this.log(curDetailAST, _MSG_INCORRECT_COUNT_VARIABLE, new Object[]{countlessVariableName, expectedVariableName});
                continue;
            }
            if (!variableName.matches(countlessVariableName + "[0-9]+")) continue;
            int count = GetterUtil.getInteger(StringUtil.removeSubstring(variableName, countlessVariableName));
            expectedVariableName = countlessVariableName + (count + 1);
        }
    }

    private void _checkExceptionVariableName(DetailAST detailAST, String name, String typeName) {
        String expectedVariableName;
        if (!StringUtil.endsWith(this.getAbsolutePath(), "ExceptionMapper.java")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() == 96 || detailAST.getType() != 21) {
            return;
        }
        String[] names = StringUtil.split(typeName, ".");
        if (names.length > 2) {
            return;
        }
        typeName = names[0];
        if (!StringUtil.endsWith(typeName, "Exception")) {
            return;
        }
        if (names.length == 2) {
            typeName = names[1];
        }
        if (!name.equals(expectedVariableName = this.getExpectedVariableName(typeName))) {
            this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{name, expectedVariableName});
        }
    }

    private void _checkInstanceVariableName(DetailAST detailAST, String name, String typeName) {
        if (!name.contentEquals("_instance")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        while (true) {
            if (parentDetailAST == null) {
                return;
            }
            if (parentDetailAST.getType() == 14) break;
            parentDetailAST = parentDetailAST.getParent();
        }
        DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
        if (!typeName.equals(identDetailAST.getText())) {
            return;
        }
        DetailAST grandParentDetailAST = parentDetailAST.getParent();
        if (grandParentDetailAST != null) {
            return;
        }
        String expectedVariableName = this._getExpectedVariableName(typeName, "_", "");
        List<DetailAST> variableDeclarationDetailASTList = this.getAllChildTokens(parentDetailAST, true, 10);
        for (DetailAST variableDeclarationDetailAST : variableDeclarationDetailASTList) {
            identDetailAST = variableDeclarationDetailAST.findFirstToken(58);
            if (!expectedVariableName.equals(identDetailAST.getText())) continue;
            return;
        }
        this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{name, expectedVariableName});
    }

    private void _checkIsVariableName(DetailAST detailAST, String name) {
        if (!this._isBooleanType(detailAST.findFirstToken(13))) {
            return;
        }
        Matcher matcher = _isVariableNamePattern.matcher(name);
        if (!matcher.find()) {
            return;
        }
        String group2 = matcher.group(2);
        String newName = null;
        if (group2.equals("is")) {
            newName = StringUtil.toLowerCase(matcher.group(3)) + matcher.group(4);
            if (!Validator.isVariableName(newName)) {
                return;
            }
            newName = matcher.group(1) + newName;
        } else {
            newName = matcher.group(1) + matcher.group(3) + matcher.group(4);
        }
        if (!this._classHasVariableWithName(detailAST, newName)) {
            this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{name, newName});
        }
    }

    private void _checkShortTypeNames(DetailAST detailAST, String variableName, String typeName, String expectedVariableName) {
        if (StringUtil.equals(variableName, "_" + expectedVariableName) || !detailAST.branchContains(61) || detailAST.branchContains(64)) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        ArrayList<DetailAST> variableDeclarationDetailASTList = new ArrayList<DetailAST>();
        variableDeclarationDetailASTList.addAll(this.getAllChildTokens(parentDetailAST, false, 10));
        int count = 0;
        for (DetailAST variableDeclarationDetailAST : variableDeclarationDetailASTList) {
            DetailAST typeDetailAST = variableDeclarationDetailAST.findFirstToken(13);
            DetailAST firstChildDetailAST = typeDetailAST.getFirstChild();
            if (firstChildDetailAST == null || firstChildDetailAST.getType() == 59 || !typeName.equals(this.getTypeName(typeDetailAST, false))) continue;
            ++count;
        }
        if (count == 1) {
            this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{variableName, "_" + expectedVariableName});
        }
    }

    private void _checkTypeName(DetailAST detailAST, String variableName, String typeName) {
        String expectedVariableName;
        if (variableName.matches("_?INSTANCE") || typeName.equals("Object") && !variableName.matches("(o|obj|(.*Obj))[0-9]*")) {
            return;
        }
        List<String> enforceShortTypeNames = this.getAttributeValues(_ENFORCE_SHORT_TYPE_NAMES_KEY);
        if (enforceShortTypeNames.contains(typeName)) {
            expectedVariableName = this.getExpectedVariableName(typeName);
            this._checkShortTypeNames(detailAST, variableName, typeName, expectedVariableName);
        }
        if (variableName.matches("(?i).*" + typeName + "[0-9]*")) {
            List<String> enforceTableSchemaFieldTypeNames = this.getAttributeValues(_ENFORCE_TABLE_SCHEMA_FIELD_TYPE_NAMES_KEY);
            for (String enforceTableSchemaFieldTypeName : enforceTableSchemaFieldTypeNames) {
                String expectedVariableName2;
                if (!typeName.matches(enforceTableSchemaFieldTypeName + "Field") || Validator.isNull(expectedVariableName2 = this._getExpectedVariableName(detailAST, enforceTableSchemaFieldTypeName)) || variableName.matches("(?i).*" + expectedVariableName2 + "[0-9]*")) continue;
                this.log(detailAST, _MSG_INCORRECT_ENDING_VARIABLE, new Object[]{typeName, expectedVariableName2});
                return;
            }
            return;
        }
        expectedVariableName = this.getExpectedVariableName(typeName);
        if (StringUtil.isUpperCase(variableName)) {
            expectedVariableName = StringUtil.toUpperCase(StringUtil.replace(TextFormatter.format(expectedVariableName, 10), '-', '_'));
            if (variableName.matches("(.*_)?" + expectedVariableName + "(_[0-9]+)?")) {
                return;
            }
            if (variableName.matches("(.*_)?" + expectedVariableName + "[0-9]+")) {
                this.log(detailAST, MSG_RENAME_VARIABLE, new Object[]{variableName, StringUtil.replaceLast(variableName, expectedVariableName, expectedVariableName + "_")});
                return;
            }
        }
        if (typeName.endsWith("Impl")) {
            this.log(detailAST, _MSG_INCORRECT_ENDING_VARIABLE, new Object[]{typeName, expectedVariableName});
            return;
        }
        List<String> enforceTypeNames = this.getAttributeValues(_ENFORCE_TYPE_NAMES_KEY);
        for (String enforceTypeName : enforceTypeNames) {
            if (!typeName.matches(enforceTypeName)) continue;
            this.log(detailAST, _MSG_INCORRECT_ENDING_VARIABLE, new Object[]{typeName, expectedVariableName});
            return;
        }
    }

    private void _checkTypo(DetailAST detailAST, String variableName) {
        List<DetailAST> stringLiteralDetailASTList = this.getAllChildTokens(detailAST, true, 139);
        for (DetailAST stringLiteralDetailAST : stringLiteralDetailASTList) {
            String expectedVariableName = this._getExpectedVariableName(stringLiteralDetailAST.getText());
            if (!SourceUtil.hasTypo(StringUtil.toLowerCase(variableName), StringUtil.toLowerCase(expectedVariableName))) continue;
            this.log(detailAST, _MSG_TYPO_VARIABLE, new Object[]{variableName, expectedVariableName});
        }
    }

    private void _checkTypo(DetailAST detailAST, String variableName, String typeName, boolean checkCaseSensitive) {
        String typeNameTrailingDigits;
        String trimmedTypeName;
        String expectedVariableName;
        List<String> allowedVariableNames;
        if (StringUtil.isUpperCase(variableName) || typeName.contains("_")) {
            return;
        }
        if (checkCaseSensitive && StringUtil.endsWith(variableName, typeName) && !variableName.endsWith(typeName)) {
            String variableEnding = variableName.substring(variableName.length() - typeName.length());
            if (Character.isUpperCase(typeName.charAt(0)) && Character.isUpperCase(variableEnding.charAt(0))) {
                this.log(detailAST, _MSG_TYPO_VARIABLE, new Object[]{variableName, StringUtil.replaceLast(variableName, variableEnding, typeName)});
                return;
            }
        }
        if ((allowedVariableNames = this.getAttributeValues(_ALLOWED_VARIABLE_NAMES_KEY)).contains(variableName)) {
            return;
        }
        String nameTrailingDigits = this._getTrailingDigits(variableName);
        String trimmedName = StringUtil.replaceLast(variableName, nameTrailingDigits, "");
        String leadingUnderline = "";
        if (variableName.startsWith("_")) {
            leadingUnderline = "_";
            trimmedName = trimmedName.substring(1);
        }
        if (StringUtil.equals(trimmedName, expectedVariableName = this.getExpectedVariableName(trimmedTypeName = StringUtil.replaceLast(typeName, typeNameTrailingDigits = this._getTrailingDigits(typeName), "")))) {
            return;
        }
        if (StringUtil.equalsIgnoreCase(trimmedName, trimmedTypeName)) {
            for (int i = expectedVariableName.length() - 1; i >= 0; --i) {
                char c1 = trimmedName.charAt(i);
                if (c1 == expectedVariableName.charAt(i) || i >= expectedVariableName.length() - 1) continue;
                char c2 = trimmedName.charAt(i + 1);
                if (!Character.isUpperCase(c1) || !Character.isDigit(c2) && !Character.isUpperCase(c2)) continue;
                return;
            }
            this.log(detailAST, _MSG_TYPO_VARIABLE, new Object[]{variableName, StringBundler.concat(leadingUnderline, expectedVariableName, nameTrailingDigits)});
            return;
        }
        String lowerCaseTrimmedTypeName = StringUtil.toLowerCase(trimmedTypeName);
        if (SourceUtil.hasTypo(StringUtil.toLowerCase(trimmedName), lowerCaseTrimmedTypeName)) {
            this.log(detailAST, _MSG_TYPO_VARIABLE, new Object[]{variableName, this._getExpectedVariableName(typeName, leadingUnderline, nameTrailingDigits)});
        }
        Matcher matcher = _camelCaseNamePattern.matcher(trimmedName);
        while (matcher.find()) {
            int x = matcher.start() + 1;
            if (!SourceUtil.hasTypo(StringUtil.toLowerCase(trimmedName.substring(x)), lowerCaseTrimmedTypeName)) continue;
            this.log(detailAST, _MSG_TYPO_VARIABLE, new Object[]{variableName, StringBundler.concat(leadingUnderline, variableName.substring(0, x), typeName, nameTrailingDigits)});
        }
    }

    private boolean _classHasVariableWithName(DetailAST detailAST, String variableName) {
        ArrayList<DetailAST> definitionDetailASTList = new ArrayList<DetailAST>();
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (parentDetailAST.getType() == 9) {
                definitionDetailASTList.addAll(this.getAllChildTokens(parentDetailAST, true, 21, 10));
            }
            if (parentDetailAST.getType() != 14) continue;
            DetailAST objBlockDetailAST = parentDetailAST.findFirstToken(6);
            definitionDetailASTList.addAll(this.getAllChildTokens(objBlockDetailAST, false, 10));
        }
        for (DetailAST definitionDetailAST : definitionDetailASTList) {
            if (!variableName.equals(this.getName(definitionDetailAST))) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getDetailAST(Set<DetailAST> detailASTSet, String name) {
        for (DetailAST detailAST : detailASTSet) {
            if (!StringUtil.equalsIgnoreCase(name, this._getVariableName(detailAST))) continue;
            return detailAST;
        }
        return null;
    }

    private String _getExpectedVariableName(DetailAST detailAST, String enforceTableSchemaFieldTypeName) {
        DetailAST assignDetailAST = detailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return null;
        }
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 28) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 27) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 59) {
            return null;
        }
        List<String> names = this.getNames(firstChildDetailAST, false);
        if (names.size() != 2) {
            return null;
        }
        String methodCallClassName = names.get(0);
        String methodCallMethodName = names.get(1);
        if (!methodCallClassName.matches("(?i)" + enforceTableSchemaFieldTypeName + "Builder") && !methodCallMethodName.matches("(?i)add" + enforceTableSchemaFieldTypeName)) {
            return null;
        }
        DetailAST parameterDetailAST = this.getParameterDetailAST(firstChildDetailAST.getParent());
        if (parameterDetailAST.getType() != 139) {
            return null;
        }
        String s = parameterDetailAST.getText();
        s = TextFormatter.format(StringUtil.replace(TextFormatter.format(s, 16), '.', '-'), 12);
        return s.substring(1, s.length() - 1) + enforceTableSchemaFieldTypeName + "Field";
    }

    private String _getExpectedVariableName(String literalString) {
        String s = literalString.substring(1, literalString.length() - 1);
        if (s.matches("_?[a-z][A-Za-z0-9]+")) {
            return StringUtil.removeChar(s, '_');
        }
        if (s.matches("[A-Z0-9_]+")) {
            return TextFormatter.format(StringUtil.replace(StringUtil.toLowerCase(s), '_', '-'), 12);
        }
        if (s.matches("[A-Z][A-Za-z0-9]+")) {
            return TextFormatter.format(s, 11);
        }
        if (s.matches("[a-z0-9 ._-]+")) {
            return TextFormatter.format(StringUtil.replace(s, new char[]{'_', ' ', '.'}, new char[]{'-', '-', '-'}), 12);
        }
        return null;
    }

    private String _getExpectedVariableName(String typeName, String leadingUnderline, String trailingDigits) {
        return StringBundler.concat(leadingUnderline, this.getExpectedVariableName(typeName), trailingDigits);
    }

    private String _getTrailingDigits(String s) {
        String digits = "";
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(s.charAt(i))) {
                return digits;
            }
            digits = s.charAt(i) + digits;
        }
        return digits;
    }

    private String _getVariableName(DetailAST variableDefinitionDetailAST) {
        DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        return nameDetailAST.getText();
    }

    private boolean _isBooleanType(DetailAST typeDetailAST) {
        String name;
        DetailAST childDetailAST = typeDetailAST.getFirstChild();
        if (childDetailAST == null) {
            return false;
        }
        if (childDetailAST.getType() == 50) {
            return true;
        }
        return childDetailAST.getType() == 58 && (name = childDetailAST.getText()).equals("Boolean");
    }
}

