/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaBaseUpgradeCallableCheck
extends BaseJavaTermCheck {
    private static final Pattern _packageNamePattern = Pattern.compile("\\.internal(\\..+)?\\.(upgrade|verify)(\\.|\\Z)");
    private static final Pattern _runnablePattern = Pattern.compile("\\WRunnable\\W");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass = (JavaClass)javaTerm;
        String name = javaClass.getName();
        if (name.endsWith("Test")) {
            return javaTerm.getContent();
        }
        String packageName = javaClass.getPackageName();
        if (packageName == null) {
            return javaTerm.getContent();
        }
        Matcher packageNameMatcher = _packageNamePattern.matcher(packageName);
        if (!packageNameMatcher.find()) {
            return javaTerm.getContent();
        }
        Matcher runnableMatcher = _runnablePattern.matcher(fileContent);
        if (runnableMatcher.find()) {
            this.addMessage(fileName, StringBundler.concat("Do not use \"java.lang.Runnable\" in \"", packageNameMatcher.group(2), "\" classes, use \"BaseUpgradeCallable\" instead."), this.getLineNumber(fileContent, runnableMatcher.start()));
        }
        List<String> importNames = javaClass.getImportNames();
        for (String importName : importNames) {
            if (!importName.equals("com.liferay.petra.function.UnsafeRunnable") && !importName.equals("java.util.concurrent.Callable")) continue;
            this.addMessage(fileName, StringBundler.concat("Do not use \"", importName, "\" in \"", packageNameMatcher.group(2), "\" classes, use \"BaseUpgradeCallable\" instead."), this.getLineNumber(fileContent, fileContent.indexOf(importName)));
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

