/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class LinkedHashMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> LinkedHashMapWrapper<K, V> create(int initialCapacity) {
        return new LinkedHashMapWrapper(initialCapacity);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> create(int initialCapacity, float loadFactor) {
        return new LinkedHashMapWrapper(initialCapacity, loadFactor);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> create(int initialCapacity, float loadFactor, boolean accessOrder) {
        return new LinkedHashMapWrapper(initialCapacity, loadFactor, accessOrder);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> create(Map<? extends K, ? extends V> map) {
        return new LinkedHashMapWrapper<K, V>(map);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        LinkedHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>> linkedHashMapWrapper = new LinkedHashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>();
        return linkedHashMapWrapper.put(inputCollection, unsafeFunction);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> linkedHashMapWrapper = new LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return linkedHashMapWrapper.put(key, valueUnsafeSupplier);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(K key, V value) {
        LinkedHashMapWrapper<K, V> linkedHashMapWrapper = new LinkedHashMapWrapper<K, V>();
        return linkedHashMapWrapper.put(key, value);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> linkedHashMapWrapper = new LinkedHashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return linkedHashMapWrapper.put(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        LinkedHashMapWrapper<K, V> linkedHashMapWrapper = new LinkedHashMapWrapper<K, V>();
        return linkedHashMapWrapper.put(keyUnsafeSupplier, value);
    }

    public static <K, V> LinkedHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
        LinkedHashMapWrapper<? extends K, ? extends V> linkedHashMapWrapper = new LinkedHashMapWrapper<K, V>();
        return linkedHashMapWrapper.putAll(inputMap);
    }

    public static final class LinkedHashMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final LinkedHashMap<K, V> _linkedHashMap;

        public LinkedHashMapWrapper() {
            this._linkedHashMap = new LinkedHashMap();
        }

        public LinkedHashMapWrapper(int initialCapacity) {
            this._linkedHashMap = new LinkedHashMap(initialCapacity);
        }

        public LinkedHashMapWrapper(int initialCapacity, float loadFactor) {
            this._linkedHashMap = new LinkedHashMap(initialCapacity, loadFactor);
        }

        public LinkedHashMapWrapper(int initialCapacity, float loadFactor, boolean accessOrder) {
            this._linkedHashMap = new LinkedHashMap(initialCapacity, loadFactor, accessOrder);
        }

        public LinkedHashMapWrapper(Map<? extends K, ? extends V> map) {
            this._linkedHashMap = new LinkedHashMap<K, V>(map);
        }

        public LinkedHashMap<K, V> build() {
            return this._linkedHashMap;
        }

        public LinkedHashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(K key, V value) {
            this._linkedHashMap.put(key, value);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public LinkedHashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        public LinkedHashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
            return this;
        }

        @Override
        protected LinkedHashMap<K, V> getMap() {
            return this._linkedHashMap;
        }
    }
}

