/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.Objects;

public class URLInputStreamCheck
extends BaseCheck {
    private static final String _MSG_REPLACE_USAGE = "replace.usage";

    public int[] getDefaultTokens() {
        return new int[]{27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<String> importNames = this.getImportNames(detailAST);
        if (!importNames.contains("java.net.URL")) {
            return;
        }
        this._checkMethodCall(detailAST, "FileUtil", "getBytes", "URLUtil.toByteArray()");
        this._checkMethodCall(detailAST, "Properties", "load", "PropertiesUtil.load()");
        this._checkMethodCall(detailAST, "StringUtil", "read", "URLUtil.toString()");
    }

    private void _checkMethodCall(DetailAST methodCallDetailAST, String className, String methodName, String expectedUsage) {
        DetailAST typeDetailAST;
        if (!Objects.equals(this.getMethodName(methodCallDetailAST), methodName)) {
            return;
        }
        String variableName = this.getClassOrVariableName(methodCallDetailAST);
        if (variableName == null) {
            return;
        }
        if (!(variableName.equals(className) || (typeDetailAST = this.getVariableTypeDetailAST(methodCallDetailAST, variableName, true)) != null && Objects.equals(this.getName(typeDetailAST), className))) {
            return;
        }
        DetailAST parameterDetailAST = this.getParameterDetailAST(methodCallDetailAST);
        if (this._isURLOpenStream(parameterDetailAST)) {
            String actualUsage = StringBundler.concat(variableName, ".", methodName, "(", ")");
            this.log(methodCallDetailAST, _MSG_REPLACE_USAGE, new Object[]{expectedUsage, actualUsage});
        } else if (parameterDetailAST.getType() == 58) {
            DetailAST parameterDefinitionDetailAST = this.getVariableDefinitionDetailAST(parameterDetailAST, parameterDetailAST.getText());
            if (parameterDefinitionDetailAST == null || !Objects.equals(this.getTypeName(parameterDefinitionDetailAST, false), "InputStream")) {
                return;
            }
            DetailAST assignDetailAST = parameterDefinitionDetailAST.findFirstToken(80);
            if (assignDetailAST == null) {
                return;
            }
            DetailAST exprDetailAST = assignDetailAST.findFirstToken(28);
            DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
            if (this._isURLOpenStream(firstChildDetailAST)) {
                String actualUsage = StringBundler.concat(variableName, ".", methodName, "(", ")");
                this.log(methodCallDetailAST, _MSG_REPLACE_USAGE, new Object[]{expectedUsage, actualUsage});
            }
        }
    }

    private boolean _isURLOpenStream(DetailAST methodCallDetailAST) {
        if (methodCallDetailAST.getType() != 27 || !Objects.equals(this.getMethodName(methodCallDetailAST), "openStream")) {
            return false;
        }
        String variableName = this.getVariableName(methodCallDetailAST);
        if (variableName == null) {
            return false;
        }
        DetailAST variableTypeDetailAST = this.getVariableTypeDetailAST(methodCallDetailAST, variableName, true);
        if (variableTypeDetailAST == null) {
            return false;
        }
        return Objects.equals(this.getTypeName(variableTypeDetailAST, false), "URL");
    }
}

