/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaBaseModelListenerCheck
extends BaseUpgradeCheck {
    private static final Pattern _modelTypePattern = Pattern.compile("extends\\s+\\w+\\<(\\w+)\\>");
    private static final Pattern _superMethodPattern = Pattern.compile("super\\.\\s*(onAfterUpdate|onBeforeUpdate)\\(\\s*\\w+\\)");
    private String _modelType;

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (!extendedClassNames.contains("BaseModelListener")) {
            return content;
        }
        this._modelType = this._getModelType(content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String newJavaMethodContent = this._formatMethod(javaMethod);
            content = StringUtil.replace(content, javaMethod.getContent(), newJavaMethodContent);
        }
        return content;
    }

    private String _formatMethod(JavaMethod javaMethod) {
        String javaMethodName = javaMethod.getName();
        if (javaMethodName.equals("onAfterUpdate") || javaMethodName.equals("onBeforeUpdate")) {
            return this._formatMethodDefinitionWithParameterUpgrade(javaMethod);
        }
        return this._formatMethodDefinitionWithoutParameterUpgrade(javaMethod);
    }

    private String _formatMethodDefinitionWithoutParameterUpgrade(JavaMethod javaMethod) {
        String javaMethodContent = javaMethod.getContent();
        Matcher matcher = _superMethodPattern.matcher(javaMethodContent);
        if (!matcher.find()) {
            return javaMethodContent;
        }
        String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
        methodCall = methodCall.trim();
        return StringUtil.replace(javaMethodContent, methodCall, this._formatSuperMethod(methodCall, false));
    }

    private String _formatMethodDefinitionWithParameterUpgrade(JavaMethod javaMethod) {
        String javaMethodContent = javaMethod.getContent();
        JavaSignature javaSignature = javaMethod.getSignature();
        List<JavaParameter> parameters = javaSignature.getParameters();
        if (parameters.size() != 1) {
            return javaMethodContent;
        }
        javaMethodContent = this._formatSuperMethod(javaMethodContent, true);
        JavaParameter javaParameter = parameters.get(0);
        String javaParameterName = javaParameter.getParameterName();
        String javaParameterType = javaParameter.getParameterType();
        String newParameter = StringBundler.concat(javaParameterType, " original", StringUtil.upperCaseFirstLetter(javaParameterName));
        String newParameters = StringBundler.concat(newParameter, ", ", javaParameterType, " ", javaParameterName);
        return StringUtil.replace(javaMethodContent, JavaSourceUtil.getParameters(javaMethodContent), newParameters);
    }

    private String _formatSuperMethod(String javaMethodContent, boolean parameterUpgrade) {
        Matcher matcher = _superMethodPattern.matcher(javaMethodContent);
        if (!matcher.find()) {
            return javaMethodContent;
        }
        String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
        List<String> parameterNames = JavaSourceUtil.getParameterNames(methodCall);
        if (parameterNames.size() != 1) {
            return javaMethodContent;
        }
        String parameterName = parameterNames.get(0);
        String newParameter = null;
        newParameter = parameterUpgrade ? StringBundler.concat("original", StringUtil.upperCaseFirstLetter(parameterName), ", ", parameterName) : StringBundler.concat("(", this._modelType, ")", parameterName, ".clone(), ", parameterName);
        String newMethodCall = StringUtil.replace(methodCall, parameterName, newParameter);
        return StringUtil.replace(javaMethodContent, methodCall, newMethodCall);
    }

    private String _getModelType(String content) throws Exception {
        Matcher matcher = _modelTypePattern.matcher(content);
        if (!matcher.find()) {
            throw new Exception("Unable to get model type");
        }
        return matcher.group(1);
    }
}

