/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSStylingCheck
extends BaseFileCheck {
    private static final Pattern _multipleVarsOnSingleLinePattern = Pattern.compile("\t+var \\w+\\, ");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (content.contains("debugger.")) {
            this.addMessage(fileName, "Do not use debugger");
        }
        return this._formatMultipleVarsOnSingleLine(content);
    }

    private String _formatMultipleVarsOnSingleLine(String content) {
        Matcher matcher;
        while ((matcher = _multipleVarsOnSingleLinePattern.matcher(content)).find()) {
            String match = matcher.group();
            int pos = match.indexOf("var ");
            content = StringUtil.replace(content, match, StringBundler.concat(match.substring(0, match.length() - 2), ";\n", match.substring(0, pos + 4)));
        }
        return content;
    }
}

