/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.PropertyValueComparator;
import com.liferay.source.formatter.util.FileUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class JSONPackageJSONCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws JSONException {
        if (!absolutePath.endsWith("/package.json") || !absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/dxp/apps/") && !absolutePath.contains("/modules/private/apps/")) {
            return content;
        }
        String dirName = absolutePath.substring(0, absolutePath.length() - 12);
        if (!FileUtil.exists(dirName + "build.gradle") && !FileUtil.exists(dirName + "bnd.bnd")) {
            return content;
        }
        JSONObjectImpl jsonObject = new JSONObjectImpl(content);
        if (jsonObject.isNull("scripts")) {
            return content;
        }
        JSONObject scriptsJSONObject = jsonObject.getJSONObject("scripts");
        if (!scriptsJSONObject.isNull("build") && Objects.equals(scriptsJSONObject.get("build"), "liferay-npm-bundler")) {
            return content;
        }
        this._checkIncorrectEntry(fileName, jsonObject, "devDependencies");
        if (absolutePath.endsWith("commerce-theme-minium/package.json") || absolutePath.endsWith("commerce-theme-speedwell/package.json") || absolutePath.endsWith("frontend-theme-admin/package.json") || absolutePath.endsWith("frontend-theme-classic/package.json") || absolutePath.endsWith("frontend-theme-dialect/package.json") || absolutePath.endsWith("frontend-theme-styled/package.json") || absolutePath.endsWith("frontend-theme-unstyled/package.json")) {
            this._checkScript(fileName, scriptsJSONObject, "build", false, "theme build", "build:theme");
        } else {
            this._checkScript(fileName, scriptsJSONObject, "build", false, "build", "build:custom", "webpack");
        }
        this._checkScript(fileName, scriptsJSONObject, "checkFormat", true, "--check", "check", "check:ci");
        this._checkScript(fileName, scriptsJSONObject, "format", true, "fix", "format");
        return this._checkJest(content);
    }

    private void _checkIncorrectEntry(String fileName, JSONObject jsonObject, String entryName) {
        if (!jsonObject.isNull(entryName)) {
            this.addMessage(fileName, "Entry \"" + entryName + "\" is not allowed");
        }
    }

    private String _checkJest(String content) throws JSONException {
        JSONObjectImpl jsonObject = new JSONObjectImpl(content);
        JSONObject jestJSONObject = jsonObject.getJSONObject("jest");
        if (jestJSONObject == null) {
            return content;
        }
        String testMatch = jestJSONObject.getString("testMatch");
        if (Validator.isNotNull(testMatch)) {
            jestJSONObject.put("testMatch", this._sortTestMatch(testMatch));
        }
        jsonObject.put("jest", jestJSONObject);
        return JSONUtil.toString(jsonObject) + "\n";
    }

    private void _checkScript(String fileName, JSONObject scriptsJSONObject, String key, boolean requiredScript, String ... allowedValues) {
        if (scriptsJSONObject.isNull(key)) {
            if (requiredScript) {
                this.addMessage(fileName, "Missing entry \"" + key + "\" in \"scripts\"");
            }
            return;
        }
        String value = scriptsJSONObject.getString(key);
        for (String allowedValue : allowedValues) {
            if (!value.equals(allowedValue) && !value.endsWith(" " + allowedValue)) continue;
            return;
        }
        if (allowedValues.length == 1) {
            this.addMessage(fileName, StringBundler.concat("Value \"", value, "\" for entry \"", key, "\" should end with \"", allowedValues[0], "\""));
            return;
        }
        StringBundler sb = new StringBundler(allowedValues.length * 4 + 5);
        sb.append("Value \"");
        sb.append(value);
        sb.append("\" for entry \"");
        sb.append(key);
        sb.append("\" should end with (or be exactly) one of the following values: ");
        for (int i = 0; i < allowedValues.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"");
            sb.append(allowedValues[i]);
            sb.append("\"");
        }
        this.addMessage(fileName, sb.toString());
    }

    private JSONArray _sortTestMatch(String testMatch) throws JSONException {
        JSONArrayImpl testMatchJSONArray = new JSONArrayImpl(testMatch);
        List<Object> objects = JSONUtil.toObjectList(testMatchJSONArray);
        Collections.sort(objects, new TestMatchComparator());
        testMatchJSONArray = new JSONArrayImpl();
        for (Object object : objects) {
            testMatchJSONArray.put(object);
        }
        return testMatchJSONArray;
    }

    private class TestMatchComparator
    implements Comparator<Object> {
        private TestMatchComparator() {
        }

        @Override
        public int compare(Object object1, Object object2) {
            PropertyValueComparator comparator = new PropertyValueComparator();
            return comparator.compare(object1.toString(), object2.toString());
        }
    }
}

