/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import java.util.List;

public class CSPComplianceCheck
extends BaseTagAttributesCheck {
    private static final String _ILLEGAL_TAG_NAMES_DATA_KEY = "illegalTagNamesData";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> illegalTagNamesData = this.getAttributeValues(_ILLEGAL_TAG_NAMES_DATA_KEY, absolutePath);
        for (String illegalTagNameData : illegalTagNamesData) {
            String[] parts = StringUtil.split(illegalTagNameData, ":");
            String tagName = parts[0];
            String requiredAttribute = null;
            if (parts.length == 2) {
                requiredAttribute = parts[1];
            }
            int x = -1;
            while ((x = content.indexOf("<" + tagName, x + 1)) != -1) {
                String tagString = this.getTag(content, x);
                if (Validator.isNull(tagString) || requiredAttribute != null && !tagString.contains(requiredAttribute)) continue;
                int lineNumber = this.getLineNumber(content, x);
                if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".jspx")) {
                    this.addMessage(fileName, StringBundler.concat("Use <aui:", tagName, "> tag instead of <", tagName, ">, see LPD-18227"), lineNumber);
                    continue;
                }
                if (fileName.endsWith(".ftl")) {
                    this._checkMissingAttribute(fileName, tagName, "${nonceAttribute}", tagString, lineNumber);
                    continue;
                }
                if (!fileName.endsWith(".vm")) continue;
                this._checkMissingAttribute(fileName, tagName, "$nonceAttribute", tagString, lineNumber);
            }
        }
        return content;
    }

    private void _checkMissingAttribute(String fileName, String tagName, String attribute, String tagString, int lineNumber) {
        if (!tagString.contains(attribute)) {
            this.addMessage(fileName, StringBundler.concat("Missing attribute '", attribute, "' in <", tagName, "> tag, see LPD-18227"), lineNumber);
        }
    }
}

