/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import java.util.ArrayList;
import java.util.List;

public class CSPComplianceCheck
extends BaseTagAttributesCheck {
    private static final String _IGNORED_FTL_TAG_PREFIXES_KEY = "ignoredFTLTagPrefixes";
    private static final String _IGNORED_JSP_TAG_PREFIXES_KEY = "ignoredJSPTagPrefixes";
    private static final String _ILLEGAL_ATTRIBUTE_NAMES_KEY = "illegalAttributeNames";
    private static final String _ILLEGAL_TAG_NAMES_DATA_KEY = "illegalTagNamesData";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String lowerCaseContent = StringUtil.toLowerCase(content);
        this._checkIllegalAttributes(fileName, absolutePath, content, lowerCaseContent);
        this._checkIllegalTags(fileName, absolutePath, content, lowerCaseContent);
        return content;
    }

    private void _checkIllegalAttributes(String fileName, String absolutePath, String content, String lowerCaseContent) {
        List<Object> ignoredTagPrefixes = new ArrayList();
        if (fileName.endsWith(".ftl")) {
            ignoredTagPrefixes = this.getAttributeValues(_IGNORED_FTL_TAG_PREFIXES_KEY, absolutePath);
        } else if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".jspx")) {
            ignoredTagPrefixes = this.getAttributeValues(_IGNORED_JSP_TAG_PREFIXES_KEY, absolutePath);
        }
        if (ListUtil.isEmpty(ignoredTagPrefixes)) {
            return;
        }
        List<String> illegalAttributeNames = this.getAttributeValues(_ILLEGAL_ATTRIBUTE_NAMES_KEY, absolutePath);
        for (String illegalAttributeName : illegalAttributeNames) {
            int x = -1;
            block1: while ((x = lowerCaseContent.indexOf(illegalAttributeName + "=", x + 1)) != -1) {
                String tagString;
                int tagStartPosition;
                if (x == 0 || !Character.isWhitespace(content.charAt(x - 1)) || this.isJavaSource(content, x) || (tagStartPosition = this._getTagStartPosition(content, x)) == -1 || Validator.isNull(tagString = this.getTag(content, tagStartPosition))) continue;
                for (String string : ignoredTagPrefixes) {
                    if (!tagString.startsWith(string)) continue;
                    continue block1;
                }
                this.addMessage(fileName, "Tag attribute '" + illegalAttributeName + "' is not allowed, see LPD-18227", this.getLineNumber(content, x));
            }
        }
    }

    private void _checkIllegalTags(String fileName, String absolutePath, String content, String lowerCaseContent) {
        List<String> illegalTagNamesData = this.getAttributeValues(_ILLEGAL_TAG_NAMES_DATA_KEY, absolutePath);
        for (String illegalTagNameData : illegalTagNamesData) {
            String[] parts = StringUtil.split(illegalTagNameData, ":");
            String tagName = parts[0];
            String requiredAttribute = null;
            if (parts.length == 2) {
                requiredAttribute = parts[1];
            }
            int x = -1;
            while ((x = lowerCaseContent.indexOf("<" + tagName, x + 1)) != -1) {
                String tagString = this.getTag(content, x);
                if (Validator.isNull(tagString) || requiredAttribute != null && !tagString.contains(requiredAttribute)) continue;
                int lineNumber = this.getLineNumber(content, x);
                if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".jspx")) {
                    this.addMessage(fileName, StringBundler.concat("Use <aui:", tagName, "> tag instead of <", tagName, ">, see LPD-18227"), lineNumber);
                    continue;
                }
                if (fileName.endsWith(".ftl")) {
                    this._checkMissingAttribute(fileName, tagName, "${nonceAttribute}", tagString, lineNumber);
                    continue;
                }
                if (!fileName.endsWith(".vm")) continue;
                this._checkMissingAttribute(fileName, tagName, "$nonceAttribute", tagString, lineNumber);
            }
        }
    }

    private void _checkMissingAttribute(String fileName, String tagName, String attribute, String tagString, int lineNumber) {
        if (!tagString.contains(attribute)) {
            this.addMessage(fileName, StringBundler.concat("Missing attribute '", attribute, "' in <", tagName, "> tag, see LPD-18227"), lineNumber);
        }
    }

    private int _getTagStartPosition(String content, int x) {
        while (x >= 0) {
            char c = content.charAt(x);
            if (c == '<' && content.charAt(x + 1) != '%' && !this.isJavaSource(content, x, true)) {
                return x;
            }
            --x;
        }
        return -1;
    }
}

